/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.upgrade.configuration;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradeMessage;
import org.kantega.atlaskerb.upgrade.data.UpgradePluginSettingsEntryResult;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.KssoStringUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.PageNameUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalConfigUpgrade {
    private static final Logger log = LoggerFactory.getLogger(GlobalConfigUpgrade.class);
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;

    public GlobalConfigUpgrade(KerbConfManager kerbConfManager, UserLookupService userLookupService, HostApp hostApp) {
        this.kerbConfManager = kerbConfManager;
        this.userLookupService = userLookupService;
        this.hostApp = hostApp;
    }

    public io.vavr.collection.List<UpgradeMessage> run() {
        return io.vavr.collection.List.of((Object[])new UpgradeMessage[]{this.updateCsrfCheck(), this.updateIpRestrictionsFormat(), this.updateBasicAuthIpRestrictionsAfterFlippedBool(), this.updateKerberosSingleToMultiRegex(), this.updateBasicAuthPermissionSomeUsersConfig()}).appendAll(this.updateDisableTraditionalLoginSettings());
    }

    public boolean isBreakingDisableTraditionalLogin() {
        Version versionWithRefactoredTraditionalLogin = new Version("6.3.0");
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.compareTo(versionWithRefactoredTraditionalLogin) < 0).getOrElse((Object)true);
    }

    public boolean isBreakingChanges() {
        return this.isBreakingCsrfCheck() || this.isBreakingDisableTraditionalLogin() || this.isBreakingBasicAuthIpRestrictions() || this.isBreakingIpRestrictionsVersion6_20() || this.isBreakingKerberosSingleToMultiRegex() || this.isBreakingBasicAuthPermissionSomeUsersConfig();
    }

    public boolean isBreakingCsrfCheck() {
        Version versionWithNewCsrfCheck = new Version("5.5.2");
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.compareTo(versionWithNewCsrfCheck) < 0).getOrElse((Object)true);
    }

    public boolean isBreakingBasicAuthIpRestrictions() {
        Version firstVersionWithBasicAuthIpRestriction = Version.of((String)"6.3.0");
        Version versionWithBreakingChangesBasicAuth = new Version("6.15.0");
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.isLowerThan(versionWithBreakingChangesBasicAuth) && version.isHigherThanOrEqualTo(firstVersionWithBasicAuthIpRestriction)).getOrElse((Object)false);
    }

    public boolean isBreakingIpRestrictionsVersion6_20() {
        Version versionWithBreakingChangesBasicAuth = new Version("6.20.0");
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.isLowerThan(versionWithBreakingChangesBasicAuth)).getOrElse((Object)false);
    }

    public boolean isBreakingKerberosSingleToMultiRegex() {
        Version versionWithBreakingChanges = new Version("6.28.0");
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.isLowerThan(versionWithBreakingChanges)).getOrElse((Object)false);
    }

    private boolean isBreakingBasicAuthPermissionSomeUsersConfig() {
        Version versionWithRefactoredApiTokenGroupConfiguration = new Version("6.40.0");
        Version platform7VersionWithRefactoredApiTokenGroupConfiguration = new Version("7.40.0");
        Version v = (Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull();
        if (v == null) {
            return true;
        }
        return v.isLowerThan(versionWithRefactoredApiTokenGroupConfiguration) || v.isHigherThanOrEqualTo(Version.of((String)"7.0.0")) && v.isLowerThan(platform7VersionWithRefactoredApiTokenGroupConfiguration);
    }

    private io.vavr.collection.List<UpgradeMessage> updateDisableTraditionalLoginSettings() {
        if (this.isBreakingDisableTraditionalLogin()) {
            log.info("Converting old traditional login settings to new format introduced in K-SSO Enterprise version 6.3");
            boolean traditionalLoginPrevented = this.kerbConfManager.oldIsTraditionalLoginDisabled();
            boolean traditionalLoginJsmPrevented = this.kerbConfManager.oldIsTraditionalLoginDisabledJSD();
            boolean basicAuthDisabled = this.kerbConfManager.oldIsBasicAuthDisabled();
            String disableLoginUri = this.kerbConfManager.getPluginRootAbsoluteUrl() + "/disableLogin";
            String disableLoginTitle = "Disable traditional username/password login";
            UpgradeMessage traditionalLogin = this.kerbConfManager.setTraditionalLoginPrevented(traditionalLoginPrevented) ? new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Successfully updated 'disable traditional username password login' to new format.") : new UpgradeMessage(KssoUpgradeManager.ResultCode.FAILURE, "Failed to update 'disable traditional username password login' to new format.", disableLoginUri, "Disable traditional username/password login");
            UpgradeMessage traditionalLoginJsm = this.kerbConfManager.setTraditionalLoginJsmPrevented(traditionalLoginJsmPrevented) ? new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Successfully updated 'disable traditional username password login for JSM' to new format.", disableLoginUri, "Disable traditional username/password login") : new UpgradeMessage(KssoUpgradeManager.ResultCode.FAILURE, "Failed to update 'disable traditional username password login' to new format.", disableLoginUri, "Disable traditional username/password login");
            UpgradeMessage basicAuth = this.kerbConfManager.setBasicAuthPreventedByFile(basicAuthDisabled) ? new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Successfully updated 'disable traditional username password login' to new format.") : new UpgradeMessage(KssoUpgradeManager.ResultCode.FAILURE, "Failed to update 'disable traditional username password login' to new format.");
            return io.vavr.collection.List.of((Object[])new UpgradeMessage[]{traditionalLogin, traditionalLoginJsm, basicAuth});
        }
        return io.vavr.collection.List.of((Object)new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "No need to update 'disable traditional login and basic auth' settings."));
    }

    private UpgradeMessage updateCsrfCheck() {
        if (this.isBreakingCsrfCheck()) {
            return this.kerbConfManager.setCsrfOriginCheckEnabled(true) ? new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Successfully upgraded CSRF origin header check to new format.") : new UpgradeMessage(KssoUpgradeManager.ResultCode.FAILURE, "Failed to upgrade CSRF origin header check to new format.");
        }
        return new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "No need to update CSRF origin header check.");
    }

    @NotNull
    private UpgradeMessage updateIpRestrictionsFormat() {
        io.vavr.collection.List<UpgradePluginSettingsEntryResult> convertedIpRestrictionsResults = this.updateIpRestrictions();
        return convertedIpRestrictionsResults.forAll(UpgradePluginSettingsEntryResult::isSuccess) ? new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Successfully upgraded Kantega SSO Enterprise IP restrictions to new format.", convertedIpRestrictionsResults) : new UpgradeMessage(KssoUpgradeManager.ResultCode.FAILURE, "Failed to upgrade Kantega SSO Enterprise IP restrictions to new format.", convertedIpRestrictionsResults);
    }

    private UpgradeMessage updateBasicAuthIpRestrictionsAfterFlippedBool() {
        if (this.isBreakingBasicAuthIpRestrictions()) {
            boolean hasConfiguredBasicAuthIpRestrictions;
            IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
            boolean oldBasicAuthEnabled = !this.kerbConfManager.isBasicAuthPreventedByFileExisting();
            boolean bl = hasConfiguredBasicAuthIpRestrictions = ipRestrictionConfig.getBasicAuthIpBlockedList().length > 0 || ipRestrictionConfig.getBasicAuthIpUnblockedList().length > 0;
            if (oldBasicAuthEnabled && hasConfiguredBasicAuthIpRestrictions) {
                log.info("Updating IP restrictions for basic auth to be compatible with new format");
                log.info("Setting basicAuthPrevented to true and let IP restrictions decide access to basic auth");
                this.kerbConfManager.setBasicAuthPreventedByFile(true);
                log.info("Setting all directories present to Basic Auth allowed directories.");
                for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
                    try {
                        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                        HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                        attrs.put("ksso.basic.auth.allowed", "true");
                        builder.setAttributes(attrs);
                        this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
                    }
                    catch (UnsupportedOperationException u) {
                        String errorMessage = ErrorUtils.createErrorMessage((String)"KSSO-UIBQ35Z52X", (String)("Unable to update directory " + directory.getName() + " during update of config"));
                        log.error(errorMessage, (Throwable)u);
                        return UpgradeMessage.failure(errorMessage);
                    }
                }
                return UpgradeMessage.success("Successfully updated basic auth IP restrictions.");
            }
        }
        log.debug("Skipping update of Basic Auth Ip restrictions");
        return UpgradeMessage.success("Skipping update of basic auth IP restrictions.");
    }

    public boolean hasUpgradeFailures() {
        return !this.getUpdateFailures().isEmpty();
    }

    public boolean hasSavedOldPreV5IpRestrictions() {
        return io.vavr.collection.List.of((Object[])new KerbConfManager.KEYS[]{KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST}).map(key -> (String)this.kerbConfManager.get((KerbConfManager.KEYS)((Object)key))).exists(StringUtils::isNotBlank);
    }

    public boolean hasSavedIpRestrictions() {
        return GlobalConfigUpgrade.ipRestrictionKeys().map(key -> (String)this.kerbConfManager.get((KerbConfManager.KEYS)((Object)key))).exists(StringUtils::isNotBlank);
    }

    private void saveUpdateFailures(io.vavr.collection.List<UpgradePluginSettingsEntryResult> failedResults) {
        io.vavr.collection.List maybeJsonList = failedResults.filter(UpgradePluginSettingsEntryResult::isFailure).map(JsonMapping.Write::objectAsJson);
        if (maybeJsonList.forAll(Try::isSuccess)) {
            JSONArray resultsToSave = new JSONArray((Collection)maybeJsonList.map(Try::get).toJavaList());
            this.kerbConfManager.put(KerbConfManager.KEYS.CONFIG_UPDATE_FAILURES, (Object)resultsToSave.toString());
        } else {
            maybeJsonList.find(Try::isFailure).map(Try::getCause).peek(throwable -> log.error("Encountered an error while saving the upgrade results: ", throwable));
        }
    }

    private io.vavr.collection.List<UpgradePluginSettingsEntryResult> updateIpRestrictions() {
        io.vavr.collection.List results = this.updateToV5IpRestrictions().appendAll(this.updateToV6_20IpRestrictions());
        if (results.forAll(UpgradePluginSettingsEntryResult::isSuccess)) {
            this.kerbConfManager.flushOneMinuteCache();
        }
        this.saveUpdateFailures((io.vavr.collection.List<UpgradePluginSettingsEntryResult>)results.filter(UpgradePluginSettingsEntryResult::isFailure));
        log.info("No conversion needed for Kantega SSO IP restrictions. Skipping conversion.");
        return io.vavr.collection.List.empty();
    }

    private io.vavr.collection.List<UpgradePluginSettingsEntryResult> updateToV6_20IpRestrictions() {
        if (this.isBreakingIpRestrictionsVersion6_20() && this.hasSavedIpRestrictions()) {
            log.info("Converting old IP restrictions to new format introduced in K-SSO Enterprise version 6.20.0");
            return GlobalConfigUpgrade.ipRestrictionKeys().map(this::convertAndSaveToV6_20IpRestriction);
        }
        return io.vavr.collection.List.empty();
    }

    private UpgradeMessage updateKerberosSingleToMultiRegex() {
        if (this.isBreakingKerberosSingleToMultiRegex() && this.kerbConfManager.get(KerbConfManager.KEYS.LEGACY_REGEX_LOOKUP) != null && this.kerbConfManager.get(KerbConfManager.KEYS.LEGACY_REGEX_REPLACEMENT) != null) {
            log.info("Converting Kerberos single to multi regex");
            this.kerbConfManager.setKerberosMultiRegex(new JSONArray().put((Object)new JSONObject().put("regexLookup", this.kerbConfManager.get(KerbConfManager.KEYS.LEGACY_REGEX_LOOKUP)).put("regexReplacement", this.kerbConfManager.get(KerbConfManager.KEYS.LEGACY_REGEX_REPLACEMENT))).toString());
        }
        return UpgradeMessage.success("Skipping update of Kerberos single to multi regex.");
    }

    private io.vavr.collection.List<UpgradePluginSettingsEntryResult> updateToV5IpRestrictions() {
        if (this.hasSavedOldPreV5IpRestrictions() && this.isSavedConfigVersionPreV5()) {
            IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
            log.info("Converting old IP restrictions to new format introduced in K-SSO Enterprise version 5");
            io.vavr.collection.List results = GlobalConfigUpgrade.legacyIpRestrictionKeysMapped().filter(oldKeyAndNewKey -> {
                boolean isSettingConfigured = false;
                if (((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST) || ((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST)) {
                    isSettingConfigured = this.kerbConfManager.isKerberosEnabled() && ipRestrictionConfig.getGlobalRestrictionType() != KerbConfManager.IpRestrictionType.UNRESTRICTED;
                } else if (((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST) || ((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST)) {
                    isSettingConfigured = this.kerbConfManager.isKerberosEnabled() && this.kerbConfManager.isKerberosRestAuthEnabled() && ipRestrictionConfig.getRestRestrictionType() != KerbConfManager.IpRestrictionType.UNRESTRICTED;
                } else if (((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST) || ((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST)) {
                    isSettingConfigured = this.kerbConfManager.isApiTokensEnabled() != false && ipRestrictionConfig.getApiTokenRestrictionType() != KerbConfManager.IpRestrictionType.UNRESTRICTED;
                }
                return isSettingConfigured && StringUtils.isNotBlank((CharSequence)((String)this.kerbConfManager.get((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1())))));
            }).map(this::convertAndSaveLegacyIpRestriction);
            if (results.forAll(UpgradePluginSettingsEntryResult::isSuccess)) {
                this.kerbConfManager.flushOneMinuteCache();
            }
            return results;
        }
        log.info("Skipping KSSO Version 5 format update. Already up to date.");
        return io.vavr.collection.List.empty();
    }

    private UpgradeMessage updateBasicAuthPermissionSomeUsersConfig() {
        if (this.isBreakingBasicAuthPermissionSomeUsersConfig()) {
            boolean hasGroupAndDirectorySettings;
            log.info("Saving basic auth permission for some users config");
            this.kerbConfManager.setBasicAuthIpOpenUnblockedList(new ArrayList<String>());
            this.kerbConfManager.setBasicAuthIpOpenBlockedList(new ArrayList<String>());
            this.kerbConfManager.setBasicAuthIpStrictUnblockedList(new ArrayList<String>());
            this.kerbConfManager.setBasicAuthIpStrictBlockedList(new ArrayList<String>());
            this.handleUpgradeGroupDirectoryPermission();
            if (!this.kerbConfManager.isBasicAuthPreventedByFileExisting()) {
                this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.ENABLE_ALL_USERS);
                return UpgradeMessage.success("Skipping update of basic auth permission for some users config.");
            }
            boolean hasIpUnblockedList = this.kerbConfManager.getIpRestrictionConfig().getBasicAuthIpUnblockedList().length > 0;
            boolean hasIpBlockedList = this.kerbConfManager.getIpRestrictionConfig().getBasicAuthIpBlockedList().length > 0;
            boolean bl = hasGroupAndDirectorySettings = !this.kerbConfManager.getAllowBasicAuthGroups().isEmpty() || !this.kerbConfManager.getDisallowBasicAuthGroups().isEmpty() || !this.userLookupService.getCachedDirectoriesAllowingBasicAuth().isEmpty();
            if (this.kerbConfManager.getIpRestrictionConfig().getBasicAuthIpRestrictionType() == KerbConfManager.IpRestrictionType.STRICT) {
                if (!(hasIpUnblockedList || hasIpBlockedList || hasGroupAndDirectorySettings)) {
                    this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.DISABLE_ALL_USERS);
                } else if (hasIpUnblockedList || hasIpBlockedList) {
                    if (hasGroupAndDirectorySettings) {
                        this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.IP_ADDRESS_GROUP_DIRECTORY);
                    } else {
                        this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.IP_ADDRESS);
                    }
                } else {
                    this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.GROUP_DIRECTORY);
                }
                if (hasIpBlockedList) {
                    String[] blockedList = this.kerbConfManager.getIpRestrictionConfig().getBasicAuthIpBlockedList();
                    this.kerbConfManager.setBasicAuthIpStrictBlockedList(Arrays.asList(blockedList));
                }
                if (hasIpUnblockedList) {
                    String[] unblockedList = this.kerbConfManager.getIpRestrictionConfig().getBasicAuthIpUnblockedList();
                    this.kerbConfManager.setBasicAuthIpStrictUnblockedList(Arrays.asList(unblockedList));
                }
            } else if (this.kerbConfManager.getIpRestrictionConfig().getBasicAuthIpRestrictionType() == KerbConfManager.IpRestrictionType.OPEN) {
                if (!(hasIpUnblockedList || hasIpBlockedList || hasGroupAndDirectorySettings)) {
                    this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.ENABLE_ALL_USERS);
                } else if (hasIpUnblockedList || hasIpBlockedList) {
                    if (hasGroupAndDirectorySettings) {
                        this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.IP_ADDRESS_GROUP_DIRECTORY);
                    } else {
                        this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.IP_ADDRESS);
                    }
                } else {
                    this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.GROUP_DIRECTORY);
                }
                if (hasIpBlockedList) {
                    String[] blockedList = this.kerbConfManager.getIpRestrictionConfig().getBasicAuthIpBlockedList();
                    this.kerbConfManager.setBasicAuthIpOpenBlockedList(Arrays.asList(blockedList));
                }
                if (hasIpUnblockedList) {
                    String[] unblockedList = this.kerbConfManager.getIpRestrictionConfig().getBasicAuthIpUnblockedList();
                    this.kerbConfManager.setBasicAuthIpOpenUnblockedList(Arrays.asList(unblockedList));
                }
            } else {
                this.kerbConfManager.setBasicAuthPermissionType(KerbConfManager.BasicAuthUserPermissionType.DISABLE_ALL_USERS);
            }
        }
        return UpgradeMessage.success("Successfully updated basic auth permission for some users config.");
    }

    private void handleUpgradeGroupDirectoryPermission() {
        boolean isDirectory;
        boolean isUserInGroup = !this.kerbConfManager.getAllowBasicAuthGroups().isEmpty();
        boolean isUserNotInGroup = !this.kerbConfManager.getDisallowBasicAuthGroups().isEmpty();
        boolean bl = isDirectory = !this.userLookupService.getCachedDirectoriesAllowingBasicAuth().isEmpty();
        if (isUserInGroup && isDirectory) {
            this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
            this.kerbConfManager.setBasicAuthPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
        } else if (isUserNotInGroup && isDirectory) {
            this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY_OR_GROUP);
            this.kerbConfManager.setBasicAuthPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_NOT_IN_GROUP);
        } else if (isUserInGroup) {
            this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.GROUP);
            this.kerbConfManager.setBasicAuthPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
        } else if (isUserNotInGroup) {
            this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.GROUP);
            this.kerbConfManager.setBasicAuthPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_NOT_IN_GROUP);
        } else if (isDirectory) {
            this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.DIRECTORY);
            this.kerbConfManager.setBasicAuthPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
        } else {
            this.kerbConfManager.setBasicAuthPermissionSome(KerbConfManager.UserPermissionGroupDirectoryType.GROUP);
            this.kerbConfManager.setBasicAuthPermissionGroup(KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP);
        }
    }

    private boolean isSavedConfigVersionPreV5() {
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(v -> v.isLowerThan(Version.of((String)"5.0.0"))).getOrElse((Object)true);
    }

    private void blockEveryPatternInBlockedListDueToFailedUpdate(KerbConfManager.KEYS oldConfigKey, KerbConfManager.KEYS newConfigKey) {
        String blockEveryIpAddressPattern = "^.*$" + System.lineSeparator();
        List<KerbConfManager.KEYS> blockedListConfigKeys = Arrays.asList(KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST);
        if (blockedListConfigKeys.contains((Object)oldConfigKey)) {
            this.kerbConfManager.put(newConfigKey, (Object)blockEveryIpAddressPattern);
        }
    }

    public io.vavr.collection.List<UpgradePluginSettingsEntryResult> getUpdateFailures() {
        return (io.vavr.collection.List)Option.of((Object)((String)this.kerbConfManager.get(KerbConfManager.KEYS.CONFIG_UPDATE_FAILURES))).filter(StringUtils::isNotBlank).toTry().mapTry((CheckedFunction1 & Serializable)source -> {
            JSONArray jsonArray = new JSONArray(source);
            ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonObjects.add(jsonArray.optJSONObject(i));
            }
            return io.vavr.collection.List.ofAll(jsonObjects).map(Option::of).map(Value::toTry).map(maybeJson -> maybeJson.flatMap(json -> JsonMapping.Read.valueFromJson((JSONObject)json, UpgradePluginSettingsEntryResult.class).onFailure(error -> log.error("JSON error while reading config upgrade result: ", error)))).filter(Try::isSuccess).map(Try::get);
        }).getOrElse((Object)io.vavr.collection.List.empty());
    }

    public void removeUpdateFailureAfterFix(KerbConfManager.KEYS oldConfigurationKey) {
        io.vavr.collection.List resultsReduced = this.getUpdateFailures().removeFirst(failure -> failure.getOldConfigurationKey() == oldConfigurationKey);
        this.saveUpdateFailures((io.vavr.collection.List<UpgradePluginSettingsEntryResult>)resultsReduced);
        if (!this.hasUpgradeFailures()) {
            this.kerbConfManager.upgradeKssoVersionInConfig();
        }
    }

    @NotNull
    private UpgradePluginSettingsEntryResult convertAndSaveLegacyIpRestriction(Tuple2<KerbConfManager.KEYS, KerbConfManager.KEYS> oldKeyAndNewKey) {
        io.vavr.collection.List convertedRestrictions = InternetAddressUtils.Versioning.convertOldIpRestrictionFormatToVersion5Format((String)((String)this.kerbConfManager.get((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1()))));
        if (convertedRestrictions.isEmpty()) {
            return new UpgradePluginSettingsEntryResult((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull(), KssoUpgradeManager.ResultCode.SUCCESS, "No data for conversion found.", (KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1()), this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrNull());
        }
        if (this.isIpRestrictionConversionSuccessful((io.vavr.collection.List<Either<String, String>>)convertedRestrictions)) {
            String convertedIpRestrictions = ListParseUtils.listToStringWithNewlines((io.vavr.collection.List)convertedRestrictions.map(Either::get));
            log.info("Converted " + ((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1())).name());
            this.kerbConfManager.put((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2()), (Object)convertedIpRestrictions);
            return new UpgradePluginSettingsEntryResult((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull(), KssoUpgradeManager.ResultCode.SUCCESS, "Conversion succeeded for " + ((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1())).key, (KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1()), this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrNull());
        }
        log.error("Conversion failed for " + ((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1())).name());
        io.vavr.collection.List failedConversions = convertedRestrictions.map(either -> (String)either.getOrElse(() -> ((Either)either).getLeft()));
        log.error("Failed conversion: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List)failedConversions, (KssoStringUtils.StringLiteral)KssoStringUtils.StringLiteral.COMMA));
        this.blockEveryPatternInBlockedListDueToFailedUpdate((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1()), (KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2()));
        return new UpgradePluginSettingsEntryResult((String)this.kerbConfManager.getSavedKssoConfigVersion().map(Version::stringValue).getOrNull(), KssoUpgradeManager.ResultCode.FAILURE, "Conversion failed for " + ((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1())).key, (KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1()), this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrNull(), ListParseUtils.listToStringWithNewlines((io.vavr.collection.List)failedConversions));
    }

    @NotNull
    private UpgradePluginSettingsEntryResult convertAndSaveToV6_20IpRestriction(KerbConfManager.KEYS ipRestrictionKey) {
        io.vavr.collection.List convertedRestrictions = InternetAddressUtils.Versioning.convertV5IpRestrictionFormatToV6_20Format((String)((String)this.kerbConfManager.get(ipRestrictionKey))).map(InternetAddressUtils.IpRestrictionConversionResult::getMaybeConvertedRestriction);
        if (convertedRestrictions.isEmpty()) {
            return new UpgradePluginSettingsEntryResult((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull(), KssoUpgradeManager.ResultCode.SUCCESS, "No data for conversion found.", ipRestrictionKey, this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl(ipRestrictionKey).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle(ipRestrictionKey).getOrNull());
        }
        if (this.isIpRestrictionConversionSuccessful((io.vavr.collection.List<Either<String, String>>)convertedRestrictions)) {
            String convertedIpRestrictions = ListParseUtils.listToStringWithNewlines((io.vavr.collection.List)convertedRestrictions.map(Either::get));
            log.info("Converted " + ipRestrictionKey.name());
            this.kerbConfManager.put(ipRestrictionKey, (Object)convertedIpRestrictions);
            return new UpgradePluginSettingsEntryResult((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull(), KssoUpgradeManager.ResultCode.SUCCESS, "Conversion succeeded for " + ipRestrictionKey.key, ipRestrictionKey, this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl(ipRestrictionKey).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle(ipRestrictionKey).getOrNull());
        }
        log.error("Conversion failed for " + ipRestrictionKey.name());
        io.vavr.collection.List failedConversions = convertedRestrictions.map(either -> (String)either.getOrElse(() -> ((Either)either).getLeft()));
        log.error("Failed conversion: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List)failedConversions, (KssoStringUtils.StringLiteral)KssoStringUtils.StringLiteral.COMMA));
        this.blockEveryPatternInBlockedListDueToFailedUpdate(ipRestrictionKey, ipRestrictionKey);
        return new UpgradePluginSettingsEntryResult((String)this.kerbConfManager.getSavedKssoConfigVersion().map(Version::stringValue).getOrNull(), KssoUpgradeManager.ResultCode.FAILURE, "Conversion failed for " + ipRestrictionKey.key, ipRestrictionKey, this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl(ipRestrictionKey).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle(ipRestrictionKey).getOrNull(), ListParseUtils.listToStringWithNewlines((io.vavr.collection.List)failedConversions));
    }

    public boolean isIpRestrictionConversionSuccessful(io.vavr.collection.List<Either<String, String>> convertedIpRestrictions) {
        return !convertedIpRestrictions.isEmpty() && convertedIpRestrictions.forAll(Either::isRight) && convertedIpRestrictions.filter(Either::isRight).map(Either::get).forAll(InternetAddressUtils::isValidExistingPermissionList);
    }

    private static io.vavr.collection.List<KerbConfManager.KEYS> ipRestrictionNewKeys() {
        return io.vavr.collection.List.of((Object[])new KerbConfManager.KEYS[]{KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST, KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.REST_IP_BLOCKEDLIST, KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST, KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_STRICT_BLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_STRICT_UNBLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_OPEN_BLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_OPEN_UNBLOCKEDLIST});
    }

    private static io.vavr.collection.List<KerbConfManager.KEYS> ipRestrictionKeys() {
        return io.vavr.collection.List.of((Object[])new KerbConfManager.KEYS[]{KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST, KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.REST_IP_BLOCKEDLIST, KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST, KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_BLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST});
    }

    private static io.vavr.collection.List<Tuple2<KerbConfManager.KEYS, KerbConfManager.KEYS>> legacyIpRestrictionKeysMapped() {
        return io.vavr.collection.List.of((Object[])new Tuple2[]{Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.REST_IP_BLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST))});
    }
}

