/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.security.SameSiteCookiePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SetSameSiteResponseWrapper
extends HttpServletResponseWrapper {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ArrayList<String> sessionIdCookieNames = new ArrayList();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SameSiteCookiePolicy sameSiteCookiePolicy;

    public SetSameSiteResponseWrapper(HttpServletRequest request, HttpServletResponse response, SameSiteCookiePolicy sameSiteCookiePolicy) {
        super(response);
        this.sessionIdCookieNames.add("JSESSIONID");
        this.sessionIdCookieNames.add("BITBUCKETSESSIONID");
        this.request = request;
        this.response = response;
        this.sameSiteCookiePolicy = sameSiteCookiePolicy;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.setSameSiteCookie();
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        this.setSameSiteCookie();
        return super.getWriter();
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setSameSiteCookie();
        super.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.setSameSiteCookie();
        super.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.setSameSiteCookie();
        super.sendRedirect(location);
    }

    private void setSameSiteCookie() {
        if (this.sameSiteCookiePolicy == SameSiteCookiePolicy.DEFAULT) {
            return;
        }
        this.log.trace("KSSO: Changing set-cookie to SameSite=" + this.sameSiteCookiePolicy.value());
        Collection setSessionIdCookieHeaders = this.response.getHeaders("Set-Cookie").stream().filter(setSessionIdCookieHeader -> this.sessionIdCookieNames.stream().anyMatch(cookieName -> setSessionIdCookieHeader.contains((CharSequence)cookieName))).filter(header -> !header.contains(String.format("SameSite=%s", this.sameSiteCookiePolicy.value()))).collect(Collectors.toCollection(ArrayList::new));
        for (String cookieHeader : setSessionIdCookieHeaders) {
            if (!StringUtils.contains((CharSequence)cookieHeader, (CharSequence)"Secure") && StringUtils.equals((CharSequence)this.request.getScheme(), (CharSequence)"https")) {
                this.log.trace("Setting cookie secure");
                this.response.setHeader("Set-Cookie", String.format("%s; SameSite=%s%s", cookieHeader, this.sameSiteCookiePolicy.value(), this.sameSiteCookiePolicy.additionalAttributes()));
                continue;
            }
            this.log.trace("Setting cookie (secure already set or plain HTTP)");
            this.response.setHeader("Set-Cookie", String.format("%s; SameSite=%s", cookieHeader, this.sameSiteCookiePolicy.value()));
        }
    }
}

