/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.okta;

import io.vavr.control.Option;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.kantega.atlaskerb.connector.AbstractConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaHttpClient
extends AbstractConnectorHttpClient {
    private static final Logger log = LoggerFactory.getLogger(OktaHttpClient.class);
    private final String domain;
    private final String token;

    OktaHttpClient(String domain, String token) {
        this.domain = domain;
        this.token = token;
    }

    @Override
    protected boolean isRateLimitExceeded(HttpURLConnection conn) throws IOException {
        return conn.getResponseCode() == 429;
    }

    @Override
    protected void waitForRateLimit(HttpURLConnection conn) throws InterruptedException {
        Instant reset = (Instant)Option.of((Object)conn.getHeaderField("X-Rate-Limit-Reset")).map(Long::parseLong).map(Instant::ofEpochSecond).getOrElse(() -> Instant.now().plusSeconds(30L));
        long duration = Math.max(0L, Duration.between(Instant.now(), reset).plusSeconds(1L).toMillis());
        long sleepTime = Math.min(TimeUnit.SECONDS.toMillis(61L), duration);
        String rateLimit = conn.getHeaderField("X-Rate-Limit-Limit");
        log.warn("Okta rate limit exceeded ({}), quota reset on: {}, wait time: {} ({}) ms", new Object[]{rateLimit, reset.toString(), duration, sleepTime});
        Thread.sleep(sleepTime);
    }

    @Override
    protected ConnectorHttpClient.AuthContext createAuthContext() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "SSWS " + this.token);
        headers.put("Accept", "application/json");
        headers.put("Host", this.domain);
        return new ConnectorHttpClient.AuthContext(headers);
    }
}

