/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.crowdserver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.kantega.atlaskerb.connector.crowdserver.CrowdResponseDocumentHandler;
import org.kantega.atlaskerb.connector.crowdserver.CrowdSocketKeepalive;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCrowdResponseDocumentHandler
implements CrowdResponseDocumentHandler,
CrowdSocketKeepalive {
    private static final long KEEPALIVE_INTERVAL = TimeUnit.MINUTES.toNanos(1L);
    private static final Logger log = LoggerFactory.getLogger(DefaultCrowdResponseDocumentHandler.class);
    private final PrintWriter pw;
    private final CountingOutputStream cos;
    private long lastWrite = 0L;
    private long lastCount = 0L;

    private DefaultCrowdResponseDocumentHandler(OutputStream os) {
        this.cos = new CountingOutputStream(os);
        this.pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.cos, StandardCharsets.UTF_8));
        this.lastWrite = System.nanoTime();
    }

    public static DefaultCrowdResponseDocumentHandler startDocument(HttpServletResponse res) {
        try {
            res.setContentType("text/xml;charset=UTF-8");
            return new DefaultCrowdResponseDocumentHandler((OutputStream)res.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void endDocument() {
        this.pw.flush();
        this.updateLastWriteTime();
    }

    @Override
    public synchronized void startUsers() {
        try {
            this.pw.println("<users expand=\"users\">");
        }
        finally {
            this.updateLastWriteTime();
        }
    }

    @Override
    public synchronized void endUsers() {
        try {
            this.pw.println("</users>");
        }
        catch (Exception e) {
            this.updateLastWriteTime();
        }
    }

    @Override
    public synchronized void startGroups() {
        try {
            this.pw.println("<groups expand=\"groups\">");
        }
        finally {
            this.updateLastWriteTime();
        }
    }

    @Override
    public synchronized void endGroups() {
        try {
            this.pw.println("</groups>");
        }
        finally {
            this.updateLastWriteTime();
        }
    }

    @Override
    public synchronized void startMemberships() {
        try {
            this.pw.println("<memberships>");
        }
        finally {
            this.updateLastWriteTime();
        }
    }

    @Override
    public synchronized void endMemberships() {
        try {
            this.pw.println("</memberships>");
        }
        finally {
            this.updateLastWriteTime();
        }
    }

    @Override
    public synchronized void outputUser(UserItem user) {
        try {
            this.pw.println("<user name=\"" + StringEscapeUtils.escapeXml11((String)user.getName()) + "\">");
            this.textElem(user.getFirstName(), "first-name");
            this.textElem(user.getLastName(), "last-name");
            this.textElem(user.getDisplayName(), "display-name");
            this.textElem(user.getEmail(), "email");
            this.textElem(user.getKey(), "key");
            this.textElem(Boolean.toString(user.isActive()), "active");
            this.pw.println("<attributes/>");
            this.pw.println("</user>");
        }
        finally {
            this.updateLastWriteTime();
        }
    }

    @Override
    public synchronized void outputGroup(GroupItem group) {
        try {
            this.pw.println("<group name=\"" + StringEscapeUtils.escapeXml11((String)group.getName()) + "\">");
            this.textElem(group.getDescription(), "description");
            this.textElem(group.getType(), "type");
            this.textElem(Boolean.toString(group.isActive()), "active");
            this.pw.println("<attributes/>");
            this.pw.println("</group>");
        }
        finally {
            this.updateLastWriteTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void outputMembership(MembershipItem membership) {
        try {
            this.pw.println("<membership group=\"" + StringEscapeUtils.escapeXml11((String)membership.getName()) + "\">");
            this.pw.println("<users>");
            for (UserMember member : membership.getUserCollection().getUsers()) {
                this.pw.println("<user name=\"" + StringEscapeUtils.escapeXml11((String)member.getName()) + "\" />");
            }
            this.pw.println("</users>");
            this.pw.println("</membership>");
        }
        finally {
            this.updateLastWriteTime();
        }
    }

    @Override
    public synchronized void outputError(String message, String reason) {
        try {
            this.pw.println("<error>");
            this.textElem(reason, "reason");
            this.textElem(message, "message");
            this.pw.println("</error>");
        }
        finally {
            this.updateLastWriteTime();
        }
    }

    @Override
    public synchronized void keepalive() {
        long nanosSinceLastWrite = System.nanoTime() - this.lastWrite;
        if (nanosSinceLastWrite > KEEPALIVE_INTERVAL) {
            log.debug("sending keepalive");
            this.pw.println("<!-- keepalive -->");
            this.pw.flush();
            this.updateLastWriteTime();
        }
    }

    private void updateLastWriteTime() {
        int bytesWritten = this.cos.getCount();
        if ((long)bytesWritten > this.lastCount) {
            this.lastWrite = System.nanoTime();
            this.lastCount = bytesWritten;
        }
    }

    private void textElem(String text, String tagName) {
        this.pw.println("<" + StringEscapeUtils.escapeXml11((String)tagName) + ">" + StringEscapeUtils.escapeXml11((String)text) + "</" + StringEscapeUtils.escapeXml11((String)tagName) + ">");
    }
}

