/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.azure;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.api.ConnectorApiException;
import org.kantega.atlaskerb.connector.azure.AzureConnectorPropUtil;
import org.kantega.atlaskerb.connector.azure.AzureDirectory;
import org.kantega.atlaskerb.connector.azure.AzureGraphApi;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.SecurityGroupFilter;
import org.kantega.atlaskerb.connector.model.UsernameSelectionAttribute;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Element;

@Component
public class AzureAdConnectorType
extends ConnectorType {
    private static final String TENANT_ID = "tenantId";
    private static final String APPLICATION_ID = "applicationId";
    private static final String APPLICATION_SECRET = "applicationSecret";
    private static final String AVATARS_ACTIVE = "isAvatarFetchActive";
    private static final String AVATARS_FETCH_FREQUENCY = "avatarFetchFrequency";
    private static final String AVATARS_LAST_FETCH_DATE = "avatarLastFetchDate";
    private static final String AVATAR_FETCH_STATUS = "avatarFetchStatus";
    private static final String USE_SAMACCOUNT_NAME = "useSAMAccountName";
    private AzureConnectorPropUtil azureConnectorPropUtil;

    @Autowired
    public void setAzureConnectorPropUtil(AzureConnectorPropUtil azureConnectorPropUtil) {
        this.azureConnectorPropUtil = azureConnectorPropUtil;
    }

    @Override
    public ConnectorAPI getConnectorApi(Directory directory) {
        AzureDirectory adir = (AzureDirectory)directory;
        return new AzureGraphApi(adir.getTenantId(), adir.getApplicationId(), this.azureConnectorPropUtil.getClientSecret(adir.getId(), adir.getApplicationSecret()), adir.isUseSAMAccountName(), directory.getSecurityGroupFilter(), adir.getUsernameSelectionAttribute());
    }

    @Override
    public String getKey() {
        return this.AZURE_AD;
    }

    @Override
    public String getEditDirectoryTemplate() {
        return "azure/edit-connector.vm";
    }

    @Override
    public Directory processEditDirectoryPost(MultipartHttpRequest multipartRequest, Map<String, Object> model, Directory existingConnector, Directory.Common common) {
        String newAppSecret;
        model.put("redirectUrl", this.getRedirectUrl((HttpServletRequest)multipartRequest));
        String tenantId = multipartRequest.getParameter(TENANT_ID).trim();
        String applicationId = multipartRequest.getParameter(APPLICATION_ID).trim();
        String applicationSecret = null;
        if (existingConnector != null) {
            AzureDirectory dir = (AzureDirectory)existingConnector;
            applicationSecret = dir.getApplicationSecret();
            model.put("applicationSecretDefined", true);
        }
        if ((newAppSecret = multipartRequest.getParameter(APPLICATION_SECRET)) != null) {
            newAppSecret = newAppSecret.trim();
        }
        if (newAppSecret != null && !newAppSecret.isEmpty()) {
            applicationSecret = newAppSecret;
            model.put("suppliedSecret", newAppSecret);
            model.put("applicationSecretDefined", false);
        }
        HashSet<String> missingFields = new HashSet<String>();
        model.put("missingFields", missingFields);
        if (tenantId.isEmpty()) {
            missingFields.add(TENANT_ID);
        }
        if (applicationId.isEmpty()) {
            missingFields.add(APPLICATION_ID);
        }
        if (applicationSecret == null || applicationSecret.isEmpty()) {
            missingFields.add(APPLICATION_SECRET);
        }
        model.put(TENANT_ID, tenantId);
        model.put(APPLICATION_ID, applicationId);
        model.put("requiredFields", true);
        if (!missingFields.isEmpty()) {
            return null;
        }
        try {
            AzureGraphApi connectorAPI = new AzureGraphApi(tenantId, applicationId, this.azureConnectorPropUtil.getClientSecret(applicationId, applicationSecret), false, existingConnector == null ? SecurityGroupFilter.SECURITY_GROUPS_ONLY : existingConnector.getSecurityGroupFilter(), UsernameSelectionAttribute.USER_PRINCIPAL_NAME);
            connectorAPI.findAllGroups(item -> {});
            String isFetchActive = Boolean.toString(false);
            String fetchFrequency = Integer.toString(24);
            String lastFetchDate = "";
            String fetchStatus = AzureDirectory.AvatarFetchStatus.NOT_RUN.name();
            boolean useSAMAccountName = false;
            UsernameSelectionAttribute usernameSelectionAttribute = UsernameSelectionAttribute.USER_PRINCIPAL_NAME;
            if (existingConnector != null) {
                AzureDirectory dir = (AzureDirectory)existingConnector;
                isFetchActive = Boolean.toString(dir.isAvatarFetchActive());
                fetchFrequency = Integer.toString(dir.getAvatarFetchFrequency());
                lastFetchDate = dir.getAvatarLastFetchDate() != null ? dir.getAvatarLastFetchDate().toString() : "";
                fetchStatus = dir.getAvatarFetchStatus();
                useSAMAccountName = dir.isUseSAMAccountName();
                usernameSelectionAttribute = dir.getUsernameSelectionAttribute();
            }
            return new AzureDirectory(common, tenantId, applicationId, applicationSecret, isFetchActive, fetchFrequency, lastFetchDate, fetchStatus, useSAMAccountName);
        }
        catch (ConnectorApiException e) {
            model.put(TENANT_ID, tenantId);
            model.put(APPLICATION_ID, applicationId);
            model.put("jsonException", e);
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDisplayName() {
        return "Entra ID";
    }

    @Override
    public void persist(Directory directory, Element element) {
        AzureDirectory dir = (AzureDirectory)directory;
        element.setAttribute(AVATARS_ACTIVE, String.valueOf(dir.isAvatarFetchActive()));
        element.setAttribute(AVATARS_FETCH_FREQUENCY, String.valueOf(dir.getAvatarFetchFrequency()));
        element.setAttribute(AVATARS_LAST_FETCH_DATE, String.valueOf(dir.getAvatarLastFetchDate()));
        element.setAttribute(AVATAR_FETCH_STATUS, dir.getAvatarFetchStatus());
        element.setAttribute(TENANT_ID, dir.getTenantId());
        element.setAttribute(APPLICATION_ID, dir.getApplicationId());
        element.setAttribute(APPLICATION_SECRET, this.azureConnectorPropUtil.getConfigurationLocation(dir.getApplicationId()) == AzureConnectorPropUtil.CONFIGURATION_LOCATION.KSSO_FILE ? dir.getApplicationSecret() : "USING_ENVIRONMENT_PROPERTY");
        element.setAttribute(USE_SAMACCOUNT_NAME, String.valueOf(dir.isUseSAMAccountName()));
    }

    @Override
    public IdpConfiguration.Kind getIdentityProviderKind() {
        return IdpConfiguration.Kind.AZURE_AD;
    }

    @Override
    public void editDirectory(HttpServletRequest request, Directory directory, Map<String, Object> model) {
        model.put("redirectUrl", this.getRedirectUrl(request));
        if (directory != null) {
            AzureDirectory dir = (AzureDirectory)directory;
            model.put(TENANT_ID, dir.getTenantId());
            model.put(APPLICATION_ID, dir.getApplicationId());
            model.put("applicationSecretDefined", dir.getApplicationSecret() != null);
        }
    }

    private String getRedirectUrl(HttpServletRequest req) {
        try {
            URI uri = new URI(req.getRequestURL().toString());
            URI serviceUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), req.getContextPath() + "/kantegasso/azac", null, null);
            return serviceUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Directory parse(Element element, Directory.Common common) {
        return new AzureDirectory(common, element.getAttribute(TENANT_ID), element.getAttribute(APPLICATION_ID), element.getAttribute(APPLICATION_SECRET), element.getAttribute(AVATARS_ACTIVE), element.getAttribute(AVATARS_FETCH_FREQUENCY), element.getAttribute(AVATARS_LAST_FETCH_DATE), element.getAttribute(AVATAR_FETCH_STATUS), Boolean.parseBoolean(element.getAttribute(USE_SAMACCOUNT_NAME)));
    }
}

