/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import net.java.ao.ActiveObjectsException;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.apitokens.ApiToken;
import org.kantega.atlaskerb.apitokens.ApiTokenObject;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.apitokens.ApiTokenV570;
import org.kantega.atlaskerb.config.ConfigNameSpaces;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.utils.DateTimeUtil;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiTokenServiceImpl
implements ApiTokenService {
    private static final String AUTHORIZED_API_TOKEN_PROFILE = "authorized_api_token_profile";
    private static final String VALID_FOR_CUSTOM_CODE = "custom";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ActiveObjects ao;
    private final SecureRandom secureRandom;
    private final UserManager userManager;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final TransactionTemplate transaction;
    private final AuditLogFacade auditLogFacade;
    private final JsonWrapper jsonWrapper;

    @Inject
    public ApiTokenServiceImpl(@ComponentImport ActiveObjects activeObjects, @ComponentImport UserManager userManager, @ComponentImport TransactionTemplate transactionTemplate, KerbConfManager kerbConfManager, HostAppFactory hostApp, AuditLogFacade auditLogFacade, JsonWrapper jsonWrapper) {
        this.ao = activeObjects;
        this.userManager = userManager;
        this.secureRandom = new SecureRandom();
        this.kerbConfManager = kerbConfManager;
        this.hostApp = hostApp.getInstance();
        this.transaction = transactionTemplate;
        this.auditLogFacade = auditLogFacade;
        this.jsonWrapper = jsonWrapper;
    }

    @Override
    public String addToken(String username, String tokenName, String description, long validFor) {
        return this.addTokenAndGetSecret(username, tokenName, description, validFor, null, null);
    }

    private Try<Tuple2<String, ApiTokenV570>> addTokenAndGetSecretAndObject(String username, String tokenName, String description, long validFor) {
        return this.addToken(username, tokenName, description, validFor, null, null);
    }

    private String addTokenAndGetSecret(String username, String tokenName, String description, long validFor, byte[] salt, byte[] hashedSecret) {
        Try maybeSecret = this.addToken(username, tokenName, description, validFor, salt, hashedSecret).onFailure(throwable -> this.log.warn(ErrorUtils.createErrorMessage((String)"KSSO-UVBDEW0QM7", (String)"Failed to create API token:"), throwable)).map(Tuple2::_1);
        return (String)maybeSecret.getOrNull();
    }

    private void migrateToken(Class<?> apiTokenClass, String username, String tokenName, String description, long createdAt, long validFor, String saltBase64, String hashedSecretBase64) {
        Try.of((CheckedFunction0 & Serializable)() -> (ApiTokenV570)this.ao.create(ApiTokenV570.class, new DBParam[0])).map(apiToken -> {
            apiToken.setTokenName(tokenName);
            apiToken.setUsername(username);
            apiToken.setCreatedAt(createdAt);
            apiToken.setValidFor(validFor);
            apiToken.setDescription((String)Option.of((Object)description).getOrElse((Object)""));
            apiToken.setHashed(hashedSecretBase64);
            apiToken.setSalt(saltBase64);
            return apiToken;
        }).onSuccess(apiToken -> this.log.info("Migrating API token with ID " + apiToken.getID())).flatMapTry((CheckedFunction1 & Serializable)apiToken -> Try.run(() -> apiToken.save())).onFailure(throwable -> this.log.warn(ErrorUtils.createErrorMessage((String)"KSSO-ISVYUZW5MV", (String)"Encountered an error during migration of API token: "), throwable)).onSuccess(_void -> this.log.info("Successfully migrated {}", Option.of((Object)apiTokenClass).map(Class::getName).getOrElse((Object)"Old KSSO api token")));
    }

    private Try<Tuple2<String, ApiTokenV570>> addToken(String username, String alias, String description, long validFor, byte[] salt, byte[] hashedSecret) {
        int entropyFactor = 16;
        int bitsOfEntropy = 640;
        int bytesOfEntropy = 80;
        String secret = BaseEncoding.base32().encode(this.generateSecret(80));
        if (salt == null || hashedSecret == null) {
            salt = this.generateSalt();
            hashedSecret = this.hash(secret, salt);
        }
        String saltBase64 = Base64.getEncoder().encodeToString(salt);
        String hashedSecretBase64 = Base64.getEncoder().encodeToString(hashedSecret);
        return Try.of((CheckedFunction0 & Serializable)() -> (ApiTokenV570)this.ao.create(ApiTokenV570.class, new DBParam[0])).map(apiToken -> {
            apiToken.setTokenName(alias);
            apiToken.setUsername(username);
            apiToken.setCreatedAt(System.currentTimeMillis());
            apiToken.setValidFor(validFor);
            apiToken.setDescription((String)Option.of((Object)description).getOrElse((Object)""));
            apiToken.setHashed(hashedSecretBase64);
            apiToken.setSalt(saltBase64);
            return apiToken;
        }).andThenTry(apiToken -> apiToken.save()).onFailure(throwable -> this.log.warn(ErrorUtils.createErrorMessage((String)"KSSO-QDB8DFQUFO", (String)"Encountered an error during creation of API token: "), throwable)).onSuccess(apiToken -> this.log.info("Successfully created API token with ID " + apiToken.getID() + " and description " + apiToken.getTokenName())).map(token -> Tuple.of((Object)secret, (Object)token));
    }

    @Override
    public boolean isAnyApiTokensConfigured() {
        return !this.findAllTokens().isEmpty();
    }

    @Override
    public List<ApiTokenV570> findAllTokens() {
        return (List)Try.of((CheckedFunction0 & Serializable)() -> Lists.newArrayList((Object[])((ApiTokenV570[])this.ao.find(ApiTokenV570.class, Query.select().order("ID DESC"))))).getOrElse(new ArrayList());
    }

    @Override
    public boolean migrateOldSettings() {
        String runningVersion = KerbConfManager.getRunningKssoVersion().stringValue;
        boolean isUpdateFromBeforeVersion43 = this.isUpdateFromBeforeV43();
        boolean isUpdateFromBeforeV570 = this.isUpdateFromBeforeV570();
        if (isUpdateFromBeforeVersion43) {
            int count = (Integer)Try.of((CheckedFunction0 & Serializable)() -> (Integer)this.transaction.execute(() -> this.ao.count(ApiToken.class))).getOrElse((Object)0);
            if (count == 0) {
                this.log.info("No v4 API tokens to convert");
                return true;
            }
            List<ApiToken> oldTokens = this.fetchPreV_4_3_Tokens();
            this.log.info("Upgrading {} tokens to new format.", (Object)oldTokens.size());
            try {
                for (ApiToken old : oldTokens) {
                    String username = this.extractUsername(old.getUserKey());
                    this.migrateToken(ApiToken.class, username, old.getAlias(), "", old.getCreatedAt(), old.getValidFor(), Base64.getEncoder().encodeToString(old.getSalt()), Base64.getEncoder().encodeToString(old.getHashed()));
                    this.ao.delete(new RawEntity[]{old});
                }
                this.log.info("Successfully converted old tokens from pre-version 4.3.1");
                return true;
            }
            catch (ActiveObjectsException e) {
                this.log.error("Unable to convert old API tokens pre-version 4.3.1, encountered a database issue: ", (Throwable)e);
            }
            catch (Exception e) {
                this.log.error("Something went wrong while converting old API tokens pre-version 4.3.1: ", (Throwable)e);
            }
            return false;
        }
        if (isUpdateFromBeforeV570) {
            int count = (Integer)Try.of((CheckedFunction0 & Serializable)() -> (Integer)this.transaction.execute(() -> this.ao.count(ApiTokenObject.class))).getOrElse((Object)0);
            if (count == 0) {
                this.log.info("No ApiTokenObjects to convert");
                return true;
            }
            List<ApiTokenObject> oldTokens = this.fetchPreV_5_7_Tokens();
            this.log.info("Upgrading {} ApiTokenObjects to new format compatible with version" + runningVersion, (Object)oldTokens.size());
            try {
                for (ApiTokenObject old : oldTokens) {
                    String username = this.extractUsername(old.getUserKey());
                    this.migrateToken(ApiTokenObject.class, username, old.getAlias(), "", old.getCreatedAt(), old.getValidFor(), old.getSalt(), old.getHashed());
                    this.ao.delete(new RawEntity[]{old});
                }
                this.log.info("Successfully converted ApiTokenObjects to version " + runningVersion);
                return true;
            }
            catch (ActiveObjectsException e) {
                this.log.error("Unable to convert old API tokens to version" + runningVersion + "encountered a database issue: ", (Throwable)e);
            }
            catch (Exception e) {
                this.log.error("Something went wrong while converting old API tokens to version " + runningVersion, (Throwable)e);
            }
            return false;
        }
        this.log.info("No need to update Kantega SSO Enterprise API tokens. Skipping conversion.");
        return true;
    }

    private boolean isUpdateFromBeforeV570() {
        return KssoUpgradeManager.isUpdateApiTokenFromBeforeVersion57((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrElse((Object)Version.empty()), KerbConfManager.getRunningKssoVersion());
    }

    private boolean isUpdateFromBeforeV43() {
        return KssoUpgradeManager.isUpdateApiTokenFromBeforeVersion43((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrElse((Object)Version.empty()), KerbConfManager.getRunningKssoVersion());
    }

    private List<ApiToken> fetchPreV_4_3_Tokens() {
        return (List)Try.of((CheckedFunction0 & Serializable)() -> (ApiToken[])this.ao.find(ApiToken.class, Query.select().order("ID ASC"))).map(io.vavr.collection.List::of).map(io.vavr.collection.List::asJava).onFailure(ActiveObjectsException.class, t -> this.log.warn("Could not find old API tokens.This might be because there were no API tokens to convert in a certain version, or that the table does not exist. Stacktrace:", (Throwable)t)).getOrElse(ArrayList::new);
    }

    private List<ApiTokenObject> fetchPreV_5_7_Tokens() {
        return (List)Try.of((CheckedFunction0 & Serializable)() -> (ApiTokenObject[])this.ao.find(ApiTokenObject.class, Query.select().order("ID ASC"))).map(io.vavr.collection.List::of).map(io.vavr.collection.List::asJava).onFailure(ActiveObjectsException.class, t -> this.log.warn("Could not find old ApiTokenObjects.This might be because there were no ApiTokenObjects to convert in a certain version, or that the table does not exist. Stacktrace:", (Throwable)t)).getOrElse(ArrayList::new);
    }

    @Override
    public List<ApiTokenV570> findTokensByUsername(String username) {
        return (List)Try.of((CheckedFunction0 & Serializable)() -> {
            this.log.debug("Executing transaction - searching for tokens for user " + username);
            return Lists.newArrayList((Object[])((ApiTokenV570[])this.transaction.execute(() -> (ApiTokenV570[])this.ao.find(ApiTokenV570.class, Query.select().where("USERNAME = ?", new Object[]{username}).order("ID DESC")))));
        }).onFailure(t -> this.log.error("Failed to find tokens for user: ", t)).onSuccess(t -> this.log.debug("Successfully search for tokens for user " + username)).getOrElse(new ArrayList());
    }

    @Override
    @Nullable
    public ApiTokenV570 findTokenByIdAndUsername(String id, String username) {
        ApiTokenV570[] apiTokenObjects = (ApiTokenV570[])Try.of((CheckedFunction0 & Serializable)() -> (ApiTokenV570[])this.ao.find(ApiTokenV570.class, Query.select().where("ID = ? AND USERNAME = ?", new Object[]{Integer.parseInt(id), username}).order("ID DESC"))).onFailure(t -> this.log.error(String.format("Failed to find tokens for id %s and username %s: ", id, username), t)).onSuccess(t -> this.log.debug(String.format("Successfully searched for tokens for user %s", username))).getOrElse((Object)new ApiTokenV570[0]);
        if (apiTokenObjects.length == 1) {
            return apiTokenObjects[0];
        }
        return null;
    }

    @Override
    @Nullable
    public ApiTokenV570 findTokenById(String id) {
        if (id == null) {
            return null;
        }
        ApiTokenV570[] apiTokenObjects = (ApiTokenV570[])Try.of((CheckedFunction0 & Serializable)() -> (ApiTokenV570[])this.ao.find(ApiTokenV570.class, Query.select().where("ID = ?", new Object[]{Integer.parseInt(id)}).order("ID DESC"))).getOrElse((Object)new ApiTokenV570[0]);
        if (apiTokenObjects.length == 1) {
            return apiTokenObjects[0];
        }
        return null;
    }

    @Override
    public boolean delete(ApiTokenV570 token) {
        try {
            return (Boolean)this.transaction.execute(() -> {
                this.ao.delete(new RawEntity[]{token});
                return true;
            });
        }
        catch (Exception e) {
            this.log.warn(ErrorUtils.createErrorMessage((String)"KSSO-3PYAINXRYT", (String)"Encountered an error while deleting API token: "), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean delete(Entity token) {
        try {
            return (Boolean)this.transaction.execute(() -> {
                this.ao.delete(new RawEntity[]{token});
                return true;
            });
        }
        catch (Exception e) {
            this.log.warn(ErrorUtils.createErrorMessage((String)"KSSO-3PYAINXRYT", (String)"Encountered an error while deleting API token: "), (Throwable)e);
            return false;
        }
    }

    private boolean isInAllowedGroups(String username, List<String> allowedUserGroups) {
        if (username == null) {
            return false;
        }
        return allowedUserGroups.stream().anyMatch(g -> this.hostApp.isUserInGroup(username, (String)g));
    }

    @Override
    public Validation<String, UserProfile> validateApiToken(HttpServletRequest request) {
        UserProfile userProfileInRequest = (UserProfile)request.getAttribute(AUTHORIZED_API_TOKEN_PROFILE);
        if (userProfileInRequest != null) {
            return Validation.valid((Object)userProfileInRequest);
        }
        this.log.debug("Obtaining credentials from header");
        if (this.isTokenScheme(request)) {
            String token = this.getApiTokenFromHeader(request);
            Option<ApiTokenV570> maybeToken = this.findApiTokenObject(token);
            if (maybeToken.isDefined()) {
                UserProfile userProfile = this.userManager.getUserProfile(((ApiTokenV570)maybeToken.get()).getUsername());
                if (userProfile != null) {
                    return this.validateUserProfileAndApiToken(request, userProfile, (ApiTokenV570)maybeToken.get());
                }
                return Validation.invalid((Object)("No user profile found for user " + ((ApiTokenV570)maybeToken.get()).getUsername()));
            }
            return Validation.invalid((Object)("Token " + ApiTokenServiceImpl.loggableToken(token) + " not found"));
        }
        Option<Tuple2<String, String>> userNameAndToken = this.getUserNameAndToken(request);
        if (userNameAndToken.isDefined()) {
            this.log.debug("Found token with basic auth");
            String username = (String)((Tuple2)userNameAndToken.get())._1();
            String token = (String)((Tuple2)userNameAndToken.get())._2();
            if (username != null && token != null) {
                UserProfile userProfile = this.userManager.getUserProfile(username);
                Option<ApiTokenV570> maybeToken = this.getApiToken(username, token);
                if (!maybeToken.isDefined()) {
                    return Validation.invalid((Object)("Token " + ApiTokenServiceImpl.loggableToken(token) + " not found"));
                }
                if (userProfile == null) {
                    return Validation.invalid((Object)("No user profile found for user " + username));
                }
                return this.validateUserProfileAndApiToken(request, userProfile, (ApiTokenV570)maybeToken.get());
            }
            return Validation.invalid((Object)"Missing user or token in basic auth");
        }
        this.log.debug("Invalid API token or basic auth with password");
        return Validation.invalid((Object)"Invalid API token or basic auth with password");
    }

    private String getApiTokenFromHeader(HttpServletRequest request) {
        String[] parts = request.getHeader("Authorization").split("\\s+");
        String additionalKey = this.kerbConfManager.getAdditionalBearerKey();
        if ((StringUtils.equalsIgnoreCase((CharSequence)parts[0], (CharSequence)"ksso-token") || StringUtils.equalsIgnoreCase((CharSequence)parts[0], (CharSequence)additionalKey)) && parts.length == 2) {
            return parts[1];
        }
        return null;
    }

    private boolean isTokenScheme(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (StringUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)"ksso-token")) {
            this.log.debug("Found token name ksso-token in header");
            return true;
        }
        if (this.kerbConfManager.getAdditionalBearerKey() != null && StringUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)this.kerbConfManager.getAdditionalBearerKey())) {
            this.log.debug("Found token name " + this.kerbConfManager.getAdditionalBearerKey() + " in header");
            return true;
        }
        return false;
    }

    Validation<String, UserProfile> validateUserProfileAndApiToken(HttpServletRequest request, UserProfile userProfile, ApiTokenV570 token) {
        boolean isTokenAuthorized;
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        String ipAddress = this.kerbConfManager.getRemoteIpAddress(request);
        boolean requestHasValidIpAddress = ipRestrictionConfig.getApiTokenFilter().isRemoteAddressEnabled(ipAddress);
        boolean isUserInAllowedGroup = this.isApiTokenUserInAllowedGroups(userProfile.getUsername());
        boolean isValidApiToken = !this.isExpired(token);
        boolean bl = isTokenAuthorized = requestHasValidIpAddress && isUserInAllowedGroup && isValidApiToken;
        if (isTokenAuthorized) {
            request.setAttribute(AUTHORIZED_API_TOKEN_PROFILE, (Object)userProfile);
            return Validation.valid((Object)userProfile);
        }
        String reason = Stream.of(requestHasValidIpAddress ? "" : "IP restrictions", isUserInAllowedGroup ? "" : "group restrictions", isValidApiToken ? "" : "expired token").filter(s -> !s.isEmpty()).collect(Collectors.joining(", "));
        this.log.info(String.format("Login with Kantega SSO API Token failed due to %s", reason));
        this.auditLogFacade.loginFailed(userProfile.getUsername(), AuthMethod.API_TOKEN, String.format("Login with Kantega SSO API Token failed due to %s", reason));
        return Validation.invalid((Object)"Invalid API token or basic auth with password");
    }

    private static String loggableToken(String tokenStr) {
        if (tokenStr == null) {
            return "<empty token>";
        }
        if (tokenStr.length() < 5) {
            return "'" + tokenStr + "'";
        }
        return "'" + tokenStr.substring(0, 2) + '\u2026' + tokenStr.substring(tokenStr.length() - 2) + "'";
    }

    @Override
    public boolean requestHasApiToken(HttpServletRequest request) {
        return ApiTokenUtil.requestHasApiTokenAuthHeader(request, this.kerbConfManager.getAdditionalBearerKey()) || (Boolean)this.getUserNameAndToken(request).map(usernameAndToken -> this.isApiToken((String)usernameAndToken._1(), (String)usernameAndToken._2())).getOrElse((Object)false) != false;
    }

    @Override
    public Option<ApiTokenV570> findApiTokenObject(String secret) {
        return io.vavr.collection.List.ofAll(this.findAllTokens()).find(t -> this.isValidHash((ApiTokenV570)t, secret));
    }

    private boolean isApiToken(String maybeUsername, String maybeToken) {
        String token = (String)Option.of((Object)maybeToken).map(ApiTokenUtil.Validation::removePrefixFromApiToken).getOrElse((Object)"");
        return (Boolean)Option.of((Object)maybeUsername).map(this::findTokensByUsername).map(Collection::stream).map(tokens -> tokens.anyMatch(t -> this.isValidHash((ApiTokenV570)t, token))).getOrElse((Object)false);
    }

    private Option<Tuple2<String, String>> getUserNameAndToken(HttpServletRequest request) {
        return HttpUrlUtils.credentialsWithBasicAuthSingleHeader((HttpServletRequest)request);
    }

    @Override
    public boolean isApiTokenUserInAllowedGroups(String username) {
        ApiTokenUtil.TokenUserPermission tokenUserPermission = this.kerbConfManager.getApiTokenUserPermission();
        boolean isSystemAdmin = (Boolean)Option.of((Object)this.userManager.getUserProfile(username)).map(UserProfile::getUserKey).flatMap(Option::of).map(arg_0 -> ((UserManager)this.userManager).isSystemAdmin(arg_0)).getOrElse((Object)false);
        if (isSystemAdmin) {
            return true;
        }
        if (tokenUserPermission == ApiTokenUtil.TokenUserPermission.ALL_USERS) {
            return true;
        }
        if (tokenUserPermission == ApiTokenUtil.TokenUserPermission.USER_GROUPS) {
            JSONArray allowedGroups = this.kerbConfManager.getApiTokensGroupsTimeRestriction();
            for (int i = 0; i < allowedGroups.length(); ++i) {
                JSONObject allowedGroup = allowedGroups.getJSONObject(i);
                if (!this.hostApp.isUserInGroup(username, allowedGroup.get("groupName").toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Long userGroupMaximumTimeRestriction(String username) {
        Long longestTimeRestriction = 0L;
        ApiTokenUtil.TokenUserPermission tokenUserPermission = this.kerbConfManager.getApiTokenUserPermission();
        boolean isSystemAdmin = (Boolean)Option.of((Object)this.userManager.getUserProfile(username)).map(UserProfile::getUserKey).flatMap(Option::of).map(arg_0 -> ((UserManager)this.userManager).isSystemAdmin(arg_0)).getOrElse((Object)false);
        if (tokenUserPermission == ApiTokenUtil.TokenUserPermission.USER_GROUPS) {
            JSONArray allowedGroups = this.kerbConfManager.getApiTokensGroupsTimeRestriction();
            for (int i = 0; i < allowedGroups.length(); ++i) {
                JSONObject allowedGroup = allowedGroups.getJSONObject(i);
                Try<Long> maybeRestriction = ApiTokenUtil.Validation.tryParseTokenTimeLimit(allowedGroup.get("maxAllowed").toString());
                if (!this.hostApp.isUserInGroup(username, allowedGroup.get("groupName").toString()) || !maybeRestriction.isSuccess()) continue;
                if ((Long)maybeRestriction.get() == -1L) {
                    return -1L;
                }
                if (longestTimeRestriction >= (Long)maybeRestriction.get()) continue;
                longestTimeRestriction = (Long)maybeRestriction.get();
            }
        } else {
            longestTimeRestriction = isSystemAdmin ? Long.valueOf(-1L) : Long.valueOf(this.kerbConfManager.getApiTokensUserMaxTimeRestriction());
        }
        return longestTimeRestriction;
    }

    private Option<ApiTokenV570> getApiToken(String username, String secret) {
        if (!StringUtils.isBlank((CharSequence)username) && !StringUtils.isBlank((CharSequence)secret)) {
            for (ApiTokenV570 token : this.findTokensByUsername(username)) {
                if (!this.isValidHash(token, secret)) continue;
                return Option.of((Object)token);
            }
        }
        return Option.none();
    }

    @Override
    public Option<String> createAndPersistToken(HttpServletRequest req) {
        UserProfile remoteUser = this.userManager.getRemoteUser(req);
        if (remoteUser != null && req.getParameterMap().containsKey("tokenName") && req.getParameterMap().containsKey("validFor")) {
            boolean isSystemAdmin;
            Try maybeValidFor;
            String username = remoteUser.getUsername();
            String alias = req.getParameter("tokenName");
            String description = (String)Option.of((Object)req.getParameter("description")).getOrElse((Object)"");
            String validDays = req.getParameter("validFor");
            if (StringUtils.equals((CharSequence)req.getParameter("validFor"), (CharSequence)VALID_FOR_CUSTOM_CODE)) {
                validDays = req.getParameter("userMaxValidForCustom");
            }
            if ((maybeValidFor = ApiTokenUtil.Validation.tryParseTokenTimeLimit(validDays).onFailure(t -> this.log.debug(ErrorUtils.createErrorMessage((String)"KSSO-Y207O7SFP7", (String)"Failed to parse token time limit: "), t))).isFailure()) {
                return Option.none();
            }
            if (StringUtils.equals((CharSequence)req.getParameter("validFor"), (CharSequence)VALID_FOR_CUSTOM_CODE)) {
                maybeValidFor = Try.success((Object)DateTimeUtil.convertDaysToMillis((long)((Long)maybeValidFor.get())));
            }
            if (!(isSystemAdmin = this.userManager.isSystemAdmin(remoteUser.getUserKey()))) {
                if (!ApiTokenUtil.Validation.isValidDurationRestricted((Long)maybeValidFor.get(), this.kerbConfManager.getApiTokensUserMaxTimeRestriction())) {
                    this.log.debug(ErrorUtils.createErrorMessage((String)"KSSO-XYFMV3DIAJ", (String)("Invalid duration for API token during creation.: '" + maybeValidFor.get() + "', restricted by admin to be " + this.kerbConfManager.getApiTokensUserMaxTimeRestriction() + ".")));
                    return Option.none();
                }
            } else if (!ApiTokenUtil.Validation.isValidDuration((Long)maybeValidFor.get())) {
                this.log.debug(ErrorUtils.createErrorMessage((String)"KSSO-2GN1MGSB9D", (String)("Invalid duration for saved token: '" + maybeValidFor.get())));
                return Option.none();
            }
            return Option.of((Object)this.addToken(username, alias, description, (Long)maybeValidFor.get()));
        }
        this.log.debug(ErrorUtils.createErrorMessage((String)"KSSO-HUDGWRMUOP", (String)"Did not contain all required parameters for API token creation."));
        return Option.none();
    }

    private String extractUsername(String remoteUserKeyStr) {
        return (String)Option.of((Object)remoteUserKeyStr).map(UserKey::new).map(arg_0 -> ((UserManager)this.userManager).getUserProfile(arg_0)).flatMap(Option::of).map(UserProfile::getUsername).filter(StringUtils::isNotBlank).getOrElse((Object)"<unknown>");
    }

    @Override
    public boolean isTokenActive(String id) {
        Option maybeApiTokenObject = Option.of((Object)this.findTokenById(id));
        Option maybeUsername = maybeApiTokenObject.map(ApiTokenV570::getUsername);
        boolean isSystemAdmin = (Boolean)maybeUsername.toTry().mapTry(arg_0 -> ((UserManager)this.userManager).getUserProfile(arg_0)).mapTry(UserProfile::getUserKey).mapTry(arg_0 -> ((UserManager)this.userManager).isSystemAdmin(arg_0)).getOrElse((Object)false);
        boolean isInAllowedGroups = (Boolean)maybeUsername.map(this::isApiTokenUserInAllowedGroups).getOrElse((Object)false);
        ApiTokenUtil.TokenUserPermission permission = this.kerbConfManager.getApiTokenUserPermission();
        return permission == ApiTokenUtil.TokenUserPermission.ALL_USERS || permission == ApiTokenUtil.TokenUserPermission.USER_GROUPS && isInAllowedGroups || isSystemAdmin;
    }

    @Override
    public Either<String, JSONObject> createAndPersistTokenJson(UserProfile userProfile, String tokenName, String description, long validForMillis) {
        String username = (String)UserManagerUtils.extractUsername((UserProfile)userProfile).getOrNull();
        if (username == null && tokenName == null) {
            return Either.left((Object)"Missing user or token name");
        }
        boolean isSystemAdmin = UserManagerUtils.isSystemAdmin((UserProfile)userProfile, (UserManager)this.userManager);
        if (!isSystemAdmin) {
            if (!ApiTokenUtil.Validation.isValidDurationRestricted(validForMillis, this.kerbConfManager.getApiTokensUserMaxTimeRestriction())) {
                return Either.left((Object)"Invalid duration restricted");
            }
        } else if (!ApiTokenUtil.Validation.isValidDuration(validForMillis)) {
            return Either.left((Object)"Invalid duration");
        }
        Try<Tuple2<String, ApiTokenV570>> maybeSecretAndObject = this.addTokenAndGetSecretAndObject(username, tokenName, description, validForMillis);
        return (Either)maybeSecretAndObject.mapTry((CheckedFunction1 & Serializable)secretAndDataObject -> {
            Tuple2 secretAndObject = (Tuple2)maybeSecretAndObject.get();
            String token = (String)secretAndObject._1();
            ApiTokenV570 dataObject = (ApiTokenV570)secretAndObject._2();
            JSONObject json = new JSONObject();
            json.put("id", dataObject.getID());
            json.put("apiToken", (Object)token);
            json.put("validForDays", (Object)ApiTokenUtil.Time.convertMillisToDays(validForMillis));
            json.put("tokenName", (Object)tokenName);
            json.put("description", (Object)description);
            json.put("username", (Object)username);
            json.put("expiresAt", (Object)ApiTokenUtil.Time.getExpiryDateTime(dataObject.getCreatedAt(), validForMillis));
            if (validForMillis >= 0L) {
                json.put("expiresAtMillis", dataObject.getCreatedAt() + validForMillis);
            }
            return json;
        }).fold(throwable -> Either.left((Object)ErrorUtils.createErrorMessage((String)"KSSO-GA0P6U5JP2", (String)("Could not create API token: " + throwable.getMessage()))), Either::right);
    }

    private byte[] hash(String secret, byte[] salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(salt);
            md.update(secret.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not create hash for token secret");
        }
    }

    private byte[] generateSalt() {
        return this.generateSecret(16);
    }

    private byte[] generateSecret(int bytes) {
        byte[] randomBytes = new byte[bytes];
        this.secureRandom.nextBytes(randomBytes);
        return randomBytes;
    }

    @Override
    public boolean isProductInReadOnlyMode() {
        return this.hostApp.isProductInReadOnlyMode();
    }

    private boolean isExpired(ApiTokenV570 token) {
        return token.getValidFor() > 0L && System.currentTimeMillis() > token.getCreatedAt() + token.getValidFor();
    }

    private boolean isValidHash(ApiTokenV570 savedToken, String tokenFromRequest) {
        if (savedToken == null || tokenFromRequest == null) {
            return false;
        }
        String tokenToValidate = ApiTokenUtil.Validation.removePrefixFromApiToken(tokenFromRequest);
        byte[] savedHash = Base64.getDecoder().decode(savedToken.getHashed());
        byte[] reqHash = this.hash(tokenToValidate, Base64.getDecoder().decode(savedToken.getSalt()));
        return MessageDigest.isEqual(savedHash, reqHash);
    }

    private <T extends Entity> String serializeApiTokenAsJson(T token, Class<? extends Entity> apiTokenAoClass) {
        return (String)JsonMapping.Write.objectAsJson((Object)apiTokenAoClass.cast(token), apiTokenAoClass).mapTry(JSONObject::toString).onFailure(throwable -> this.log.error("Failed to serialize Api Token " + token.getID(), throwable)).getOrElse((Object)"");
    }

    @Override
    public String getAllTokensAsJsonForBackup() {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> {
            Class<? extends Entity> apiTokenAoClass = this.getApiTokenAoClassForBackup((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrElse((Object)Version.empty()));
            List<? extends Entity> tokens = this.getTokensFromAoClass(apiTokenAoClass);
            io.vavr.collection.List apiTokensInJson = io.vavr.collection.List.ofAll(tokens).map(token -> this.serializeApiTokenAsJson(token, apiTokenAoClass));
            JSONObject allTokens = new JSONObject();
            allTokens.put("allTokens", (Collection)apiTokensInJson.toJavaList());
            return allTokens.toString();
        }).onFailure(throwable -> this.log.error(ErrorUtils.createErrorMessage((String)"KSSO-7NXXWSWKZ1", (String)"Could not transform API tokens to JSON from backup: "), throwable)).getOrElse((Object)"");
    }

    @Override
    public void restoreTokens(Properties props, Set<ConfigNameSpaces.ConfigSubset> configOptions) {
        if (configOptions == null) {
            return;
        }
        if (configOptions.contains((Object)ConfigNameSpaces.ConfigSubset.API_TOKENS)) {
            try {
                String restoreVersion = props.getProperty("kssoVersion");
                String json = props.getProperty("apiTokens");
                List apiTokensFromJSON = (List)JsonMapping.Write.stringAsJson((String)json).flatMapTry(JsonMapping.Read::mapFromJsonObject).mapTry((CheckedFunction1 & Serializable)jsonMap -> jsonMap.get("allTokens")).mapTry((CheckedFunction1 & Serializable)listOfTokens -> (ArrayList)listOfTokens).onFailure(e -> this.log.error(ErrorUtils.createErrorMessage((String)"KSSO-BHEVRY1NP0", (String)"Unable to restore API tokens from backup: "), e)).getOrElse(new ArrayList());
                this.restoreTokens(apiTokensFromJSON, Version.of((String)restoreVersion));
            }
            catch (Exception e2) {
                this.log.error(ErrorUtils.createErrorMessage((String)"KSSO-KCBW7ANZCY", (String)"Encountered an unexpected error while restoring API tokens: "), (Throwable)e2);
            }
        }
    }

    private List<? extends Entity> getTokensFromAoClass(Class<? extends Entity> apiTokenAoClass) {
        if (apiTokenAoClass.equals(ApiToken.class)) {
            return this.fetchPreV_4_3_Tokens();
        }
        if (apiTokenAoClass.equals(ApiTokenObject.class)) {
            return this.fetchPreV_5_7_Tokens();
        }
        if (apiTokenAoClass.equals(ApiTokenV570.class)) {
            return this.findAllTokens();
        }
        return this.findAllTokens();
    }

    private void restoreTokens(List<String> restoredTokens, Version restoreFromVersion) {
        Class<? extends Entity> apiTokenAoClass = this.getApiTokenAoClassForRestore(restoreFromVersion);
        List<? extends Entity> tokens = this.getTokensFromAoClass(apiTokenAoClass);
        boolean someFailed = io.vavr.collection.List.ofAll(restoredTokens).map(t -> this.addTokenFromJson((String)t, apiTokenAoClass)).exists(Try::isFailure);
        if (!someFailed) {
            this.deleteTokens(tokens);
        } else {
            this.log.error(ErrorUtils.createErrorMessage((String)"KSSO-1ETXL3KHST", (String)"Not deleting existing tokens since import of some tokens failed from backup."));
        }
    }

    @NotNull
    private Class<? extends Entity> getApiTokenAoClassForRestore(Version versionFrom) {
        Class apiTokenAoClass = versionFrom.isEmpty() ? ApiToken.class : (versionFrom.isLowerThan(Version.of((String)"5.7.0")) && versionFrom.isHigherThanOrEqualTo(Version.of((String)"4.3.1")) ? ApiTokenObject.class : (versionFrom.isLowerThan(Version.of((String)"4.3.1")) ? ApiToken.class : (versionFrom.isHigherThanOrEqualTo(Version.of((String)"5.7.0")) ? ApiTokenV570.class : ApiTokenV570.class)));
        return apiTokenAoClass;
    }

    @NotNull
    private Class<? extends Entity> getApiTokenAoClassForBackup(Version versionFrom) {
        int apiTokenCount;
        Class apiTokenAoClass = versionFrom.isEmpty() ? ((apiTokenCount = ((Integer)Try.of((CheckedFunction0 & Serializable)() -> (Integer)this.transaction.execute(() -> this.ao.count(ApiToken.class))).getOrElse((Object)0)).intValue()) > 0 ? ApiToken.class : ApiTokenV570.class) : (versionFrom.isLowerThan(Version.of((String)"5.7.0")) && versionFrom.isHigherThanOrEqualTo(Version.of((String)"4.3.1")) ? ApiTokenObject.class : (versionFrom.isLowerThan(Version.of((String)"4.3.1")) ? ApiToken.class : (versionFrom.isHigherThanOrEqualTo(Version.of((String)"5.7.0")) ? ApiTokenV570.class : ApiTokenV570.class)));
        return apiTokenAoClass;
    }

    private void deleteTokens(List<? extends Entity> apiTokens) {
        try {
            for (Entity entity : apiTokens) {
                this.delete(entity);
            }
        }
        catch (Exception e) {
            this.log.error(ErrorUtils.createErrorMessage((String)"KSSO-UE32MM7DYS", (String)"Could not delete API tokens upon import from backup: "), (Throwable)e);
        }
    }

    private <T extends Entity> Try<Void> addTokenFromJson(String json, Class<T> apiTokenAoClass) {
        return Try.run(() -> {
            Entity apiTokenObject = (Entity)apiTokenAoClass.cast(this.ao.create(apiTokenAoClass, new DBParam[0]));
            JsonMapping.Write.stringAsJson((String)json).flatMapTry((CheckedFunction1 & Serializable)jsonObject -> JsonMapping.Read.populateInstanceFromJson((JSONObject)jsonObject, (Object)apiTokenObject, (Class)apiTokenAoClass)).onFailure(throwable -> this.log.warn(ErrorUtils.createErrorMessage((String)"KSSO-V99Q54K9LP", (String)"Failed to restore data from JSON: "), throwable));
            apiTokenObject.save();
        }).onFailure(throwable -> this.log.warn(ErrorUtils.createErrorMessage((String)"KSSO-ICMNAHI3W7", (String)"Unable to restore token from backup: "), throwable));
    }
}

