/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.security.DarkFeaturesServlet;
import org.kantega.atlaskerb.security.SameSiteCookiePolicy;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamesiteContentSecurityPolicyHeadersServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(DarkFeaturesServlet.class);

    @Inject
    public SamesiteContentSecurityPolicyHeadersServlet(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dark-features");
        model.put("menuItem", "samesiteContentSecurityPolicyHeaders");
        model.put("contextPath", req.getContextPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("contentSecurityPolicyHostNames", this.kerbConfManager.getContentSecurityPolicyHostNames());
        model.put("samesite", this.kerbConfManager.getSameSiteCookiePolicy() == SameSiteCookiePolicy.NONE);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/samesite-and-content-security-policy.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        String samesitePosted = req.getParameter("samesitePosted");
        if ("true".equals(samesitePosted)) {
            SameSiteCookiePolicy policy = "on".equals(req.getParameter("samesite")) ? SameSiteCookiePolicy.NONE : SameSiteCookiePolicy.DEFAULT;
            this.kerbConfManager.setSameSiteCookiePolicy(policy);
            return;
        }
        try {
            String addHostName;
            String removeHostName = req.getParameter("removeHostName");
            if (StringUtils.isNotBlank((CharSequence)removeHostName)) {
                this.kerbConfManager.removeContentSecurityPolicyHostNames(removeHostName);
            }
            if (StringUtils.isNotBlank((CharSequence)(addHostName = req.getParameter("addHostName")))) {
                this.kerbConfManager.addContentSecurityPolicyHostNames(addHostName.trim());
            }
            resp.sendRedirect("samesiteContentSecurityPolicyHeaders");
        }
        catch (Exception e) {
            HttpUrlUtils.sendSaveError((HttpServletResponse)resp, (Exception)e);
            this.log.error("Problem saving settings", (Throwable)e);
        }
    }
}

