/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector;

import com.atlassian.json.jsonorg.JSONObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorIOUtil;
import org.kantega.atlaskerb.connector.api.ConnectorApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectorHttpClient
implements ConnectorHttpClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectorHttpClient.class);
    public static final int RETRY_LIMIT = 2;
    private final AtomicReference<ConnectorHttpClient.AuthContext> context = new AtomicReference();

    protected abstract ConnectorHttpClient.AuthContext createAuthContext() throws InterruptedException;

    protected void throwJsonException(HttpURLConnection con) throws IOException, InterruptedException {
        JSONObject error = null;
        try (InputStream errorStream = con.getErrorStream();){
            if (errorStream != null) {
                error = new JSONObject(ConnectorIOUtil.toString(errorStream, StandardCharsets.UTF_8.name()));
            }
        }
        throw new ConnectorApiException(con.getResponseCode(), con.getResponseMessage(), error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectorHttpClient.AuthContext getAuthenticationContext() throws InterruptedException {
        ConnectorHttpClient.AuthContext ctx = this.context.get();
        if (ctx == null) {
            AbstractConnectorHttpClient abstractConnectorHttpClient = this;
            synchronized (abstractConnectorHttpClient) {
                ctx = this.context.get();
                if (ctx == null) {
                    ctx = this.createAuthContext();
                    this.context.set(ctx);
                }
            }
        }
        return ctx;
    }

    public ConnectorHttpClient.Response httpGet(String url) throws ConnectorApiException, InterruptedException {
        try {
            int retries = 0;
            while (true) {
                log.debug("httpGet(): {}", (Object)url);
                ConnectorHttpClient.AuthContext authCtx = this.getAuthenticationContext();
                HttpURLConnection conn = authCtx.openConnection(url);
                conn.setRequestMethod("GET");
                Optional<ConnectorHttpClient.Response> maybeResponse = this.readResponse(conn, authCtx, retries);
                if (maybeResponse.isPresent()) {
                    return maybeResponse.get();
                }
                ++retries;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectorHttpClient.Response httpPost(ConnectorHttpClient.PostRequest postRequest) throws InterruptedException, ConnectorApiException {
        try {
            int retries = 0;
            while (true) {
                String url = postRequest.getUrl();
                log.debug("httpPost(): {}", (Object)url);
                ConnectorHttpClient.AuthContext authCtx = this.getAuthenticationContext();
                HttpURLConnection conn = authCtx.openConnection(url);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Accept", postRequest.getAcceptType());
                conn.setRequestProperty("Content-Type", postRequest.getContentType());
                conn.setDoOutput(true);
                String postBody = postRequest.getPostBody();
                log.debug("httpPost() body: {}", (Object)postBody);
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8));){
                    writer.write(postBody);
                }
                Optional<ConnectorHttpClient.Response> maybeResponse = this.readResponse(conn, authCtx, retries);
                if (maybeResponse.isPresent()) {
                    return maybeResponse.get();
                }
                ++retries;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<ConnectorHttpClient.Response> readResponse(HttpURLConnection conn, ConnectorHttpClient.AuthContext authCtx, int retries) throws IOException, InterruptedException {
        int responseCode = conn.getResponseCode();
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        this.sleepToAvoidFutureRateLimit();
        if (responseCode == 200) {
            try (InputStream is = conn.getInputStream();){
                String responseString = ConnectorIOUtil.toString(is, StandardCharsets.UTF_8.name());
                ConnectorHttpClient.Response response = new ConnectorHttpClient.Response(responseCode, responseString, headerFields);
                Optional<ConnectorHttpClient.Response> optional = Optional.of(response);
                return optional;
            }
        }
        if (retries < 2 && this.isRateLimitExceeded(conn)) {
            log.debug("Retries: {}", (Object)retries);
            this.waitForRateLimit(conn);
            return Optional.empty();
        }
        if (retries < 2 && responseCode == 401) {
            this.context.compareAndSet(authCtx, null);
            log.debug("httpPost() no authorization, re-authing and trying again.");
            return Optional.empty();
        }
        this.throwJsonException(conn);
        return Optional.empty();
    }

    protected abstract void waitForRateLimit(HttpURLConnection var1) throws InterruptedException;

    protected void sleepToAvoidFutureRateLimit() {
    }

    protected boolean isRateLimitExceeded(HttpURLConnection conn) throws IOException {
        return false;
    }
}

