/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.userlookup;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.UserMappingUtils;

public class CheckTransformationHelper {
    public static final String JOHN_DOE_EXAMPLE_COM = "john.doe@example.com";
    public static final String REGEX_LOOKUP = "regexLookup";
    public static final String REGEX_REPLACEMENT = "regexReplacement";

    public static void checkTransformation(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        List<Tuple2<String, String>> regexTuples = CheckTransformationHelper.processRegexTuples(req);
        String testUsername = (String)Option.of((Object)req.getParameter("transformationTestText")).map(StringUtils::trim).filter(StringUtils::isNotBlank).getOrElse((Object)"");
        JSONObject response = CheckTransformationHelper.createTransformationJsonResponse(testUsername, regexTuples);
        resp.setContentType("application/json");
        resp.setStatus(200);
        resp.getWriter().print(response);
        resp.flushBuffer();
    }

    public static JSONArray getRegexTuplesAsJsonArray(List<Tuple2<String, String>> regexTuples) {
        return new JSONArray((Collection)regexTuples.map(t -> new JSONObject().put(REGEX_LOOKUP, t._1).put(REGEX_REPLACEMENT, t._2)).toJavaList());
    }

    public static java.util.List<Pair<String, String>> getRegexTuplesFromJsonArray(JSONArray jsonArray) {
        return jsonArray.toList().stream().map(o -> {
            Map hashMap = (Map)o;
            return Pair.of((Object)((String)hashMap.get(REGEX_LOOKUP)), (Object)((String)hashMap.get(REGEX_REPLACEMENT)));
        }).collect(Collectors.toList());
    }

    public static List<Tuple2<String, String>> processRegexTuples(HttpServletRequest req) {
        int rowNumber = 0;
        List inputRegexTuples = List.empty();
        String regexLookup = req.getParameter(REGEX_LOOKUP + rowNumber);
        String regexReplacement = req.getParameter(REGEX_REPLACEMENT + rowNumber);
        while (regexLookup != null && regexReplacement != null) {
            if (StringUtils.isNotBlank((CharSequence)regexLookup)) {
                inputRegexTuples = inputRegexTuples.append((Object)Tuple.of((Object)regexLookup, (Object)regexReplacement));
            }
            regexLookup = req.getParameter(REGEX_LOOKUP + ++rowNumber);
            regexReplacement = req.getParameter(REGEX_REPLACEMENT + rowNumber);
        }
        return inputRegexTuples;
    }

    private static JSONObject createTransformationJsonResponse(String testUsername, List<Tuple2<String, String>> regexTuples) {
        JSONObject jsonObject = new JSONObject();
        JSONArray validations = CheckTransformationHelper.createValidationsJsonResponse(regexTuples);
        JSONObject result = CheckTransformationHelper.createResultJsonResponse(testUsername, regexTuples);
        jsonObject.put("validations", (Object)validations);
        jsonObject.put("result", (Object)result);
        return jsonObject;
    }

    private static JSONArray createValidationsJsonResponse(List<Tuple2<String, String>> regexTuples) {
        JSONArray validations = new JSONArray();
        List<Either<String, Boolean>> regexTransformationResults = UserMappingUtils.validateRegexTransformations(regexTuples);
        int index = 0;
        for (Either regexTransformationResult : regexTransformationResults) {
            JSONObject result = new JSONObject();
            result.put("index", index);
            result.put("valid", regexTransformationResult.isRight());
            result.put("message", regexTransformationResult.isLeft() ? regexTransformationResult.getLeft() : "");
            validations.put((Object)result);
            ++index;
        }
        return validations;
    }

    private static JSONObject createResultJsonResponse(String testUsername, List<Tuple2<String, String>> regexTuples) {
        JSONObject result = new JSONObject();
        Tuple2 indexAndUsername = (Tuple2)UserMappingUtils.transformUsernameWithIndex(testUsername, regexTuples).getOrNull();
        if (indexAndUsername != null) {
            String username = (String)indexAndUsername.apply((i, name) -> name);
            result.put("username", (Object)username);
            JSONObject rule = new JSONObject();
            int index = (Integer)indexAndUsername.apply((i, name) -> i);
            rule.put("index", index);
            result.put("rule", (Object)rule);
        } else {
            result.put("username", (Object)testUsername);
            JSONObject rule = new JSONObject();
            rule.put("index", -1);
            result.put("rule", (Object)rule);
        }
        return result;
    }
}

