/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.atlassian.annotations.security.UnrestrictedAccess;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.security.SameSiteCookiePolicy;
import org.kantega.atlaskerb.security.SetSameSiteResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public final class SamesiteContentSecurityPolicyHeadersFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SamesiteContentSecurityPolicyHeadersFilter.class);
    private final KerbConfManager kerbConfManager;
    private static final String ALREADY_MATCHED_ATTR = SamesiteContentSecurityPolicyHeadersFilter.class.getName() + "_alreadyMatched";

    @Inject
    public SamesiteContentSecurityPolicyHeadersFilter(KerbConfManager kerbConfManager) {
        this.kerbConfManager = kerbConfManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.kerbConfManager.getSameSiteCookiePolicy() != SameSiteCookiePolicy.DEFAULT) {
            if (response != null) {
                for (String hostName : this.kerbConfManager.getContentSecurityPolicyHostNames()) {
                    if (StringUtils.endsWith((CharSequence)hostName, (CharSequence)"/")) {
                        hostName = StringUtils.substringBeforeLast((String)hostName, (String)"/");
                    }
                    response.setHeader("Content-Security-Policy", response.getHeader("Content-Security-Policy") + " " + hostName);
                }
            }
            if (request.getAttribute(ALREADY_MATCHED_ATTR) != null) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                request.setAttribute(ALREADY_MATCHED_ATTR, (Object)true);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)new SetSameSiteResponseWrapper(request, response, this.kerbConfManager.getSameSiteCookiePolicy()));
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }
}

