/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.ksso.scim.atlassian.auth.BasicAuthCredentials;
import com.ksso.scim.atlassian.auth.BearerTokenCredentials;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.auth.NoCredentials;
import com.ksso.scim.atlassian.auth.ScimAuthMethod;
import com.ksso.scim.spi.ScimServerSpi;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.scim.ScimTenantConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedScimSettingsAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ScimConfManager scimConfManager;
    private final TemplateRenderer renderer;
    private static final Logger log = LoggerFactory.getLogger(AdvancedScimSettingsAction.class);

    @Inject
    public AdvancedScimSettingsAction(RequireAdminServletDependencyBucket bucket, ScimConfManager scimConfManager) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.renderer = bucket.getTemplateRenderer();
        this.scimConfManager = scimConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String tenantId = req.getParameter("tenantId");
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            resp.sendError(404);
            return;
        }
        Map<String, Object> model = this.newModel(req);
        ScimDirectory scimDirectory = this.getScimDirectory(tenantId);
        ScimTenantConfig config = scimDirectory.getConfig();
        model.put("currentScimDirectory", scimDirectory);
        model.put("tenantId", tenantId);
        model.put("tenantName", config.getTenantName());
        model.put("scimAuthMethod", config.getScimAuthMethod());
        model.put("kind", config.getKind());
        model.put("useCacheFile", config.isUseCacheFile());
        model.put("linkUsersOnCreate", config.isLinkUsersOnCreate());
        this.renderPage(resp, model);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ScimAuthMethod scimAuthMethod;
        String changeAuthMethod = req.getParameter("actionSavePressed");
        String saveCredentials = req.getParameter("actionSaveCredentials");
        boolean useCacheFile = "on".equals(req.getParameter("useCacheFile")) || "true".equals(req.getParameter("useCacheFile"));
        boolean linkUsersOnCreate = "on".equals(req.getParameter("linkUsersOnCreate")) || "true".equals(req.getParameter("linkUsersOnCreate"));
        String tenantId = req.getParameter("tenantId");
        if (req.getParameter("clearCache") != null) {
            try {
                Option<ScimServerSpi> spi = this.scimConfManager.getScimServerSpi(tenantId);
                ((ScimServerSpi)spi.get()).clearUserAttributeCache();
            }
            catch (Exception e) {
                log.error("Failed to clear user attribute cache for tenant: " + tenantId, (Throwable)e);
            }
            resp.sendRedirect("advanced-scim-settings?tenantId=" + tenantId);
            return;
        }
        ScimDirectory existingDirectory = this.getScimDirectory(tenantId);
        ScimTenantConfig existingConfig = existingDirectory.getConfig();
        Credentials existingCredentials = existingConfig.getCredentials();
        if (StringUtils.isNotBlank((CharSequence)changeAuthMethod)) {
            scimAuthMethod = (ScimAuthMethod)Try.of((CheckedFunction0 & Serializable)() -> ScimAuthMethod.valueOf((String)req.getParameter("scimAuthMethod"))).getOrElse((Object)ScimAuthMethod.BEARER);
            if (scimAuthMethod != existingCredentials.getAuthMethod()) {
                Map<String, Object> model = this.newModel(req);
                model.put("currentScimDirectory", existingDirectory);
                model.put("tenantId", tenantId);
                model.put("tenantName", existingConfig.getTenantName());
                model.put("scimAuthMethod", scimAuthMethod);
                model.put("kind", existingConfig.getKind());
                model.put("showSaveCredentialsDialog", true);
                model.put("useCacheFile", useCacheFile);
                model.put("linkUsersOnCreate", linkUsersOnCreate);
                if (scimAuthMethod == ScimAuthMethod.BEARER) {
                    String applicationSecretPlainText = this.scimConfManager.nextPassword();
                    model.put("applicationSecretPlainText", applicationSecretPlainText);
                } else if (scimAuthMethod == ScimAuthMethod.BASIC) {
                    String plainTextPassword = this.scimConfManager.nextPassword();
                    model.put("username", tenantId);
                    model.put("plainTextPassword", plainTextPassword);
                }
                this.renderPage(resp, model);
                return;
            }
            ScimTenantConfig newCfg = new ScimTenantConfig(existingConfig.getTenantId(), existingConfig.getTenantName(), existingConfig.getCredentials(), existingConfig.getScimAuthMethod(), existingConfig.getKind(), useCacheFile, linkUsersOnCreate);
            this.scimConfManager.saveOrUpdate(newCfg);
        }
        if (StringUtils.isNotBlank((CharSequence)saveCredentials)) {
            NoCredentials newCredentials;
            String salt;
            scimAuthMethod = (ScimAuthMethod)Try.of((CheckedFunction0 & Serializable)() -> ScimAuthMethod.valueOf((String)req.getParameter("scimAuthMethod"))).getOrElse((Object)ScimAuthMethod.BEARER);
            if (scimAuthMethod == ScimAuthMethod.BEARER) {
                salt = this.scimConfManager.nextId();
                String applicationSecretPlainText = req.getParameter("applicationSecretPlainText");
                newCredentials = BearerTokenCredentials.createHash((String)salt, (String)applicationSecretPlainText);
            } else if (scimAuthMethod == ScimAuthMethod.BASIC) {
                salt = this.scimConfManager.nextId();
                String plainTextPassword = req.getParameter("plainTextPassword");
                newCredentials = BasicAuthCredentials.createHash((String)tenantId, (String)salt, (String)plainTextPassword);
            } else {
                newCredentials = new NoCredentials();
            }
            ScimTenantConfig newCfg = new ScimTenantConfig(existingConfig.getTenantId(), existingConfig.getTenantName(), (Credentials)newCredentials, scimAuthMethod, existingConfig.getKind(), useCacheFile, linkUsersOnCreate);
            this.scimConfManager.saveOrUpdate(newCfg);
        }
        resp.sendRedirect("advanced-scim-settings?tenantId=" + tenantId);
    }

    private ScimDirectory getScimDirectory(String tenantId) {
        return (ScimDirectory)this.scimConfManager.getScimDirectory(tenantId).getOrElseThrow(() -> new RuntimeException("SCIM tenantId not found: " + tenantId));
    }

    private void renderPage(HttpServletResponse resp, Map<String, Object> model) throws IOException {
        model.put("topMenu", "connectors");
        model.put("menuItem", "advancedScimSettings");
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/scim/advanced-scim-settings.vm", model, (Writer)resp.getWriter());
    }
}

