/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.gsuite;

import java.util.Optional;
import org.kantega.atlaskerb.connector.model.Directory;

public class GSuiteDirectory
extends Directory {
    public static final String DOMAIN_NAME = "domainName";
    public static final String CUSTOMER_ID = "customerId";
    public static final String SERVICE_ACCOUNT_ID = "serviceAccountId";
    public static final String ADMIN_ACCOUNT_ADDRESS = "adminAccountAddress";
    public static final String PRIVATE_KEY = "privateKey";

    public GSuiteDirectory(Directory.Common common, String domainName, String customerId, String serviceAccountId, String adminAccountAddress, String privateKey) {
        super(common);
        this.properties.put(DOMAIN_NAME, domainName);
        this.properties.put(SERVICE_ACCOUNT_ID, serviceAccountId);
        this.properties.put(ADMIN_ACCOUNT_ADDRESS, adminAccountAddress);
        this.properties.put(CUSTOMER_ID, customerId);
        if (privateKey != null) {
            this.properties.put(PRIVATE_KEY, privateKey);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getDomainName();
    }

    public String getDomainName() {
        return this.properties.getProperty(DOMAIN_NAME);
    }

    public Optional<String> getCustomerId() {
        return Optional.ofNullable(this.properties.getProperty(CUSTOMER_ID));
    }

    public String getServiceAccountId() {
        return this.properties.getProperty(SERVICE_ACCOUNT_ID);
    }

    public String getAdminAccountAddress() {
        return this.properties.getProperty(ADMIN_ACCOUNT_ADDRESS);
    }

    public String getPrivateKey() {
        return this.properties.getProperty(PRIVATE_KEY);
    }
}

