/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apitokens.ApiTokenEntity;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradePluginSettingsEntryResult;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.GroupSearchUtil;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.Version;

public class ApiTokenMainServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final ApiTokenService apiTokenService;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final UserLookupService userLookupService;
    private final KssoUpgradeManager kssoUpgradeManager;

    @Inject
    public ApiTokenMainServlet(RequireAdminServletDependencyBucket bucket, ApiTokenService apiTokenService) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.apiTokenService = apiTokenService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostApp();
        this.userLookupService = bucket.getUserLookupService();
        this.kssoUpgradeManager = bucket.getKssoUpgradeManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.buildModelAndRenderTemplate(req, resp, new HashMap<String, Object>());
    }

    private boolean hasUpgradeFailures() {
        return this.kssoUpgradeManager.getUpgradeFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        io.vavr.collection.HashMap protoModel = io.vavr.collection.HashMap.empty();
        if (req.getParameter("setApiTokens") != null) {
            String apiTokens = req.getParameter("apiTokens");
            this.kerbConfManager.setApiTokensEnabled("on".equals(apiTokens));
            HttpUrlUtils.sendSaveSuccess((HttpServletResponse)resp);
        } else {
            this.buildModelAndRenderTemplate(req, resp, protoModel.merge(this.setUserPermissions(req)).merge(this.setIpRestrictions(req)).merge(this.setTimeRestriction(req)).toJavaMap());
        }
    }

    private io.vavr.collection.HashMap<String, Object> setTimeRestriction(HttpServletRequest req) {
        if (req.getParameter("userMaxValidFor") != null || req.getParameter("userMaxValidForCustom") != null) {
            String maxvalidfor = "";
            maxvalidfor = !req.getParameter("userMaxValidForCustom").isEmpty() ? String.valueOf(ApiTokenUtil.Time.convertDaysToMillis(req.getParameter("userMaxValidForCustom"))) : req.getParameter("userMaxValidFor");
            if (!ApiTokenUtil.Validation.validTokenTimeLimit(maxvalidfor)) {
                return io.vavr.collection.HashMap.of((Object)"invalidTokenTimeLimitError", (Object)true);
            }
            this.kerbConfManager.setApiTokensUserMaxTimeRestriction(maxvalidfor);
        }
        return io.vavr.collection.HashMap.empty();
    }

    private io.vavr.collection.HashMap<String, Object> setUserPermissions(HttpServletRequest req) {
        if ("delete".equals(req.getParameter("action"))) {
            String groupToRemove = req.getParameter("groupPermissionToRemove");
            this.kerbConfManager.removeApiTokenGroupTimeRestriction(groupToRemove);
        } else if (req.getParameter("apiTokenUserPermission") != null) {
            Try userPermission = Try.of((CheckedFunction0 & Serializable)() -> ApiTokenUtil.TokenUserPermission.valueOf(req.getParameter("apiTokenUserPermission")));
            boolean isCustomTime = false;
            if (userPermission.isSuccess()) {
                this.kerbConfManager.setApiTokenUserPermission((ApiTokenUtil.TokenUserPermission)((Object)userPermission.get()));
                if (userPermission.get() == ApiTokenUtil.TokenUserPermission.USER_GROUPS) {
                    String userGroupName = req.getParameter("groupApiToken");
                    String maxValidFor = "";
                    if (req.getParameter("userMaxValidForCustomInputGroup") != null) {
                        maxValidFor = String.valueOf(ApiTokenUtil.Time.convertDaysToMillis(req.getParameter("userMaxValidForCustomInputGroup")));
                        isCustomTime = true;
                    } else {
                        maxValidFor = req.getParameter("userMaxValidForGroup");
                    }
                    if (userGroupName == null || StringUtils.isBlank((CharSequence)userGroupName)) {
                        this.kerbConfManager.setApiTokenAllowedUserGroups("");
                        return io.vavr.collection.HashMap.of((Object)"userGroupsEmptyWarning", (Object)true, (Object)"apiTokenUserPermission", (Object)((ApiTokenUtil.TokenUserPermission)((Object)userPermission.get())).name());
                    }
                    this.kerbConfManager.setApiTokensGroupTimeRestriction(userGroupName, maxValidFor, isCustomTime);
                }
            }
        }
        return io.vavr.collection.HashMap.empty();
    }

    private String invalidGroupName(List<String> allowedUserGroups) {
        Option maybeNotExistingGroup = io.vavr.collection.List.ofAll(allowedUserGroups).find(g -> !this.hostApp.isExistingGroup((String)g));
        return (String)maybeNotExistingGroup.getOrElse((Object)"");
    }

    private io.vavr.collection.HashMap<String, Object> setIpRestrictions(HttpServletRequest req) throws IOException {
        if (req.getParameter("setIpRestrictions") != null) {
            String ipRestrictionTypeParam = req.getParameter("ipRestrictionType");
            String ipUnblockedList = req.getParameter("token_ip_unblockedlist");
            String ipBlockedList = req.getParameter("token_ip_blockedlist");
            HashMap<String, Boolean> additionalData = new HashMap<String, Boolean>();
            Option.of((Object)ipRestrictionTypeParam).filter(StringUtils::isNotBlank).toTry().mapTry(KerbConfManager.IpRestrictionType::valueOf).peek(this.kerbConfManager::setApiTokenIpRestrictionType);
            Option maybeValidUnblockedList = Option.of((Object)ipUnblockedList).orElse(Option.of((Object)"")).map(InternetAddressUtils::softNormalizeIpRestrictions).filter(InternetAddressUtils::isValidExistingPermissionList).peek(_list -> {
                if (this.hasUpgradeFailures()) {
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST);
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setApiTokenIpUnblockedList).onEmpty(() -> {
                if (!this.hasUpgradeFailures()) {
                    additionalData.put("tokenIpUnblockedList", (Boolean)((Object)ipUnblockedList));
                }
                additionalData.put("tokenRegexFailedUnblockedList", true);
                additionalData.put("invalidDataInIpUnblockedlist", (Boolean)Option.of((Object)ipUnblockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpgradeManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull());
            });
            Option maybeValidBlockedList = Option.of((Object)ipBlockedList).orElse(Option.of((Object)"")).map(InternetAddressUtils::softNormalizeIpRestrictions).filter(InternetAddressUtils::isValidExistingPermissionList).peek(_list -> {
                if (this.hasUpgradeFailures()) {
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST);
                    this.kssoUpgradeManager.removeUpgradeFailureAfterFix(KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setApiTokenIpBlockedList).onEmpty(() -> {
                if (!this.hasUpgradeFailures()) {
                    additionalData.put("tokenIpBlockedList", (Boolean)((Object)ipBlockedList));
                }
                additionalData.put("tokenRegexFailedBlockedList", true);
                additionalData.put("invalidDataInIpBlockedlist", (Boolean)Option.of((Object)ipBlockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpgradeManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull());
            });
            boolean success = io.vavr.collection.List.of((Object[])new Option[]{maybeValidUnblockedList, maybeValidBlockedList}).forAll(Option::isDefined);
            if (!success) {
                additionalData.put("tokenRegexError", true);
            }
            return io.vavr.collection.HashMap.ofAll(additionalData);
        }
        return io.vavr.collection.HashMap.empty();
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalData) throws IOException {
        String query = req.getParameter("query");
        if (query != null) {
            GroupSearchUtil.printGroupsAsJson(resp, query, this.userManager);
        } else {
            Map<String, Object> model = this.buildModel(req);
            model.putAll(additionalData);
            resp.setContentType("text/html");
            this.renderer.render("templates/atlaskerb/api-tokens-main.vm", model, (Writer)resp.getWriter());
        }
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "api-tokens-main");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.putIfAbsent("durationOptions", ApiTokenUtil.DatePair.getDurationOptions());
        model.putIfAbsent("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.putIfAbsent("tokenIpRestrictionType", ipRestrictionConfig.getApiTokenRestrictionType().name());
        model.putIfAbsent("tokenIpUnblockedList", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines((String[])ipRestrictionConfig.getApiTokenIpUnblockedList())));
        model.putIfAbsent("tokenIpBlockedList", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines((String[])ipRestrictionConfig.getApiTokenIpBlockedList())));
        model.putIfAbsent("isRestApiRestrictedToToken", this.kerbConfManager.isRestApiRestrictedToApiTokens());
        ApiTokenUtil.TokenUserPermission tokenUserPermission = this.kerbConfManager.getApiTokenUserPermission();
        model.putIfAbsent("apiTokenUserPermission", (Object)tokenUserPermission);
        String commaSeparatedAllowedGroups = ListParseUtils.iterableToCommaSeparatedString(this.kerbConfManager.getApiTokenAllowedUserGroups());
        JSONArray apiTokenGroupsTimeRestriction = this.kerbConfManager.getApiTokensGroupsTimeRestriction();
        if (!apiTokenGroupsTimeRestriction.isEmpty()) {
            for (int i = 0; i < apiTokenGroupsTimeRestriction.length(); ++i) {
                JSONObject groupRestriction = apiTokenGroupsTimeRestriction.getJSONObject(i);
                if (!groupRestriction.get("isCustomTime").equals(true)) continue;
                Try<Long> parsedTimeLimit = ApiTokenUtil.Validation.tryParseTokenTimeLimit(groupRestriction.get("maxAllowed").toString());
                groupRestriction.put("maxAllowed", (Object)ApiTokenUtil.Time.convertMillisToDays((Long)parsedTimeLimit.get()));
            }
            model.putIfAbsent("apiTokenGroupsTimeRestriction", apiTokenGroupsTimeRestriction);
        } else {
            model.putIfAbsent("userGroupsEmptyWarning", true);
        }
        model.putIfAbsent("allowedUserGroups", commaSeparatedAllowedGroups);
        model.putIfAbsent("apiTokensUserMaxTimeRestriction", this.kerbConfManager.getApiTokensUserMaxTimeRestriction());
        model.put("groupMemberships", this.hostApp.getAllGroups());
        model.putIfAbsent("apiTokensUserMaxTimeRestrictionInDays", ApiTokenUtil.Time.convertMillisToDays(this.kerbConfManager.getApiTokensUserMaxTimeRestriction()));
        for (ApiTokenUtil.DatePair pair : ApiTokenUtil.DatePair.getDurationOptions()) {
            if (pair.getDuration().longValue() != this.kerbConfManager.getApiTokensUserMaxTimeRestriction()) continue;
            model.putIfAbsent("isCustomApiTokensUserMaxTimeRestriction", false);
            break;
        }
        model.putIfAbsent("isCustomApiTokensUserMaxTimeRestriction", true);
        String invalidGroupName = this.invalidGroupName(this.kerbConfManager.getApiTokenAllowedUserGroups());
        if (!invalidGroupName.isEmpty()) {
            model.putIfAbsent("invalidGroupName", invalidGroupName);
        }
        Try.of((CheckedFunction0 & Serializable)() -> this.userManager.getRemoteUser(req)).mapTry(UserProfile::getUsername).peek(username -> model.putIfAbsent("username", username));
        model.putIfAbsent("tokens", this.getTokensRepresentation());
        model.putIfAbsent("hasApiTokenIpUpgradeFailures", this.hasUpgradeFailures());
        if (this.hasUpgradeFailures()) {
            this.addDataFromConfigUpdate(model);
        }
        model.putIfAbsent("groupTimeRestrictions", this.kerbConfManager.getApiTokensGroupsTimeRestriction());
        return model;
    }

    private void addDataFromConfigUpdate(Map<String, Object> model) {
        io.vavr.collection.List<UpgradePluginSettingsEntryResult> updateFailures = this.kssoUpgradeManager.getUpgradeFailures();
        Option previousVersion = updateFailures.headOption().flatMap(UpgradePluginSettingsEntryResult::maybeVersion);
        previousVersion.peek(version -> {
            model.putIfAbsent("upgradedUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST : KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST));
            model.putIfAbsent("unblockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST : KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST));
            model.putIfAbsent("upgradedBlockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST : KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST));
            model.putIfAbsent("blockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, version.isHigherThanOrEqualTo(Version.of((String)"5.0.0")) ? KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST : KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST));
        }).onEmpty(() -> {
            model.putIfAbsent("upgradedUnblockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST));
            model.putIfAbsent("unblockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST));
            model.putIfAbsent("upgradedBlockedListWithErrorMessages", KssoUpgradeManager.dataWithErrorMessages(updateFailures, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST));
            model.putIfAbsent("blockedListUpgradeErrors", KssoUpgradeManager.onlyIpRestrictErrorMessagesCommaSeparated(updateFailures, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST));
        });
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getTokensRepresentation() {
        return io.vavr.collection.List.ofAll(this.apiTokenService.findAllTokens()).map(t -> new ApiTokenUtil.ApiTokenRepresentation((ApiTokenEntity)t, this.userManager, this.apiTokenService)).asJava();
    }
}

