/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONObject;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.TestRecord;
import org.kantega.atlaskerb.userlookup.UserLookupService;

public class IdpOverviewServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final UserLookupService userLookupService;
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;

    @Inject
    public IdpOverviewServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.userLookupService = bucket.getUserLookupService();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration idpConfig = this.idpConfManager.getIdentityProviderById(id);
        if (idpConfig == null) {
            resp.sendError(404);
            return;
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "overview");
        model.put("idp", idpConfig);
        String usernameAttributes = "";
        List<Pair<UsernameAttribute, String>> attributePriority = idpConfig.getUsernameAttributePriority();
        if (attributePriority != null) {
            for (int i = 0; i < attributePriority.size(); ++i) {
                usernameAttributes = usernameAttributes + (i + 1) + ". " + ((UsernameAttribute)((Object)attributePriority.get(i).getLeft())).getDisplayName();
                if (attributePriority.get(i).getLeft() == UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME) {
                    String custom = (String)attributePriority.get(i).getRight();
                    if (StringUtils.isBlank((CharSequence)custom)) {
                        custom = "<i>empty</i>";
                    }
                    usernameAttributes = usernameAttributes + ": \"" + custom + "\"";
                }
                usernameAttributes = usernameAttributes + "<br>";
            }
        }
        model.put("usernameAttributesWithHTML", usernameAttributes);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("knownDomains", idpConfig.getKnownDomains());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(idpConfig.getKind()));
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("dateTool", new DateTool());
        model.put("userTestURL", this.idpConfManager.getServiceProviderNonAdminTestUrl(req, id));
        model.put("selectedUserLookupTransform", idpConfig.getUserLookupTransform().toString());
        model.put("isSingleLogoutEnabled", idpConfig.isSingleLogoutEnabled());
        model.put("NOT_FOUND_IN_DIR_ID", -1L);
        idpConfig.ifSaml(samlConf -> {
            List<byte[]> signingCerts = samlConf.getSigningCerts();
            List validationCerts = io.vavr.collection.List.ofAll(signingCerts).map(bytes -> {
                X509Certificate cert = CertTool.parse(bytes);
                JSONObject certJson = new JSONObject();
                certJson.put("subjectDn", (Object)cert.getSubjectDN().getName());
                certJson.put("notBefore", (Object)cert.getNotBefore().toString());
                certJson.put("notAfter", (Object)cert.getNotAfter().toString());
                certJson.put("sigAlgName", (Object)cert.getSigAlgName());
                certJson.put("keySize", (Object)String.valueOf(CertTool.getKeySize(cert)));
                certJson.put("fingerPrint", (Object)CertTool.fingerPrint(bytes));
                return certJson;
            }).asJava();
            model.put("validationCerts", validationCerts);
        });
        List<TestRecord> recordedTests = this.idpConfManager.getRecordedTests(idpConfig.getId());
        if (!recordedTests.isEmpty()) {
            model.put("latestTest", recordedTests.iterator().next());
        }
        ArrayList<Directory> matchingUserDirectories = new ArrayList<Directory>();
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            if (!idpConfig.getRedirectProperties().getMatchedUserDirectoryIds().contains(directory.getId())) continue;
            matchingUserDirectories.add(directory);
        }
        model.put("matchingUserDirectories", matchingUserDirectories);
        this.getTemplateRenderer().render("templates/saml/idp-overview.vm", model, (Writer)resp.getWriter());
    }
}

