/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.HomeDirectoryResolver;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class GetIdpIconServlet
extends HttpServlet {
    private final IdpConfManager idpConfManager;
    private final HomeDirectoryResolver homeDirectoryResolver;
    private final Logger log = LoggerFactory.getLogger(GetIdpIconServlet.class);

    @Inject
    public GetIdpIconServlet(RequireAdminServletDependencyBucket bucket) {
        this.idpConfManager = bucket.getIdpConfManager();
        this.homeDirectoryResolver = bucket.getKerbConfManager().getHomeDirectoryResolver();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        try {
            this.findAndProvideIdpIcon(resp, configuration, id);
        }
        catch (IOException e) {
            try {
                resp.setContentType("text/html");
                resp.sendError(404);
            }
            catch (IOException ex) {
                this.log.error("Error while sending error response", (Throwable)ex);
            }
        }
    }

    private void findAndProvideIdpIcon(HttpServletResponse resp, IdpConfiguration configuration, String id) throws IOException {
        if (configuration == null) {
            resp.setContentType("text/html");
            resp.sendError(404);
            return;
        }
        ServletOutputStream out = resp.getOutputStream();
        File[] iconDirectory = new File(this.homeDirectoryResolver.getHomeDirectory() + "/idp-icons/").listFiles(pathname -> pathname.toString().contains(id));
        if (iconDirectory != null && iconDirectory.length > 0) {
            String iconPath = iconDirectory[0].toString();
            String fileExtension = iconPath.substring(iconPath.lastIndexOf(".") + 1);
            String imageType = "svg".equals(fileExtension) ? "svg+xml" : fileExtension;
            resp.setContentType("image/" + imageType);
            try (FileInputStream fin = new FileInputStream(iconPath);){
                this.writeInputStreamToOutputStream(out, fin);
            }
        }
        String iconPath = "/images/svg/" + (Object)((Object)configuration.getKind()) + ".svg";
        String imageType = "svg+xml";
        resp.setContentType("image/" + imageType);
        try (InputStream fin = ((Object)((Object)this)).getClass().getResourceAsStream(iconPath);){
            this.writeInputStreamToOutputStream(out, fin);
        }
    }

    private void writeInputStreamToOutputStream(ServletOutputStream out, InputStream fin) throws IOException {
        try (BufferedInputStream bin = new BufferedInputStream(fin);
             BufferedOutputStream bout = new BufferedOutputStream((OutputStream)out);){
            int ch = 0;
            while ((ch = bin.read()) != -1) {
                bout.write(ch);
            }
            bin.close();
            fin.close();
            bout.close();
            out.close();
        }
    }
}

