/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.web.context.HttpContext;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.wrapper.web.ConditionWrapper;

public class AvoidNameEmailChange
extends ConditionWrapper {
    private final HttpContext httpContext;
    private final UserManager userManager;
    private final HostApp hostApp;
    private final ScimConfManager scimConfManager;
    private final ConnectorConfManager connectorConfManager;
    private String priority;

    @Inject
    public AvoidNameEmailChange(@ComponentImport HttpContext httpContext, RequireAdminServletDependencyBucket bucket) {
        this.httpContext = httpContext;
        this.userManager = bucket.getUserManager();
        this.hostApp = bucket.getHostApp();
        this.scimConfManager = bucket.getScimConfManager();
        this.connectorConfManager = bucket.getConnectorConfManager();
    }

    public void init(Map<String, String> params) {
        this.priority = params.get("priority");
    }

    public boolean shouldDisplayInternal(Map<String, Object> parameters) {
        HttpServletRequest req = this.httpContext.getRequest();
        if (this.hostApp.isEditAccountGetRequest(req)) {
            return AvoidNameEmailChange.isUserInCloudDirectory(AvoidNameEmailChange.getLoggedInUser(this.userManager, req), this.hostApp, this.scimConfManager, this.connectorConfManager);
        }
        if (this.hostApp.isAdminEditAccountGetRequest(req)) {
            return AvoidNameEmailChange.isUserInCloudDirectory(this.hostApp.getEditAccountUser(this.userManager, req), this.hostApp, this.scimConfManager, this.connectorConfManager);
        }
        return false;
    }

    public static UserProfile getLoggedInUser(UserManager userManager, HttpServletRequest req) {
        try {
            String LOGGED_IN_USER = "KSSO_loggedInUser";
            UserProfile user = (UserProfile)req.getSession().getAttribute("KSSO_loggedInUser");
            if (user != null) {
                return user;
            }
            UserProfile userFound = userManager.getRemoteUser();
            if (userFound != null) {
                req.getSession().setAttribute("KSSO_loggedInUser", (Object)userFound);
                return userFound;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isUserInCloudDirectory(UserProfile user, HostApp hostApp, ScimConfManager scimConfManager, ConnectorConfManager connectorConfManager) {
        try {
            if (user == null) {
                return false;
            }
            com.atlassian.crowd.embedded.api.Directory usersDir = hostApp.getDirectoryForUser(user.getUsername());
            for (Object dir : scimConfManager.getScimDirectories()) {
                if (((ScimDirectory)dir).getDirectoryId() != usersDir.getId().longValue()) continue;
                return true;
            }
            for (Object dir : connectorConfManager.getDirectories()) {
                if (!StringUtils.equals((CharSequence)((Directory)dir).getId(), (CharSequence)String.valueOf(usersDir.getId()))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

