/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.restapi.access;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.Tuple;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.restapi.access.APIEndpoints;
import org.kantega.atlaskerb.restapi.access.RestrictAPIEndpoint;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.restapi.access.TokenEndpointServiceImpl;
import org.kantega.atlaskerb.restapi.access.UnblockAPIEndpoint;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictApiAccessServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final TokenEndpointService tokenEndpointService;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final String REST;
    private final Logger log = LoggerFactory.getLogger(RestrictApiAccessServlet.class);

    @Inject
    public RestrictApiAccessServlet(RequireAdminServletDependencyBucket bucket, TokenEndpointService tokenEndpointService) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.tokenEndpointService = tokenEndpointService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostApp();
        this.REST = this.hostApp.isProductMatch("fecru") ? "/rest-service-fecru" : "/rest";
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/rest-api-access.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String addRestrictedRestUrl;
        HashMap<String, Object> postModel = new HashMap<String, Object>();
        String isRestApiRestrictedToTokens = req.getParameter("isRestApiRestrictedToTokens");
        String isRestApiCompleteLockdown = req.getParameter("isRestApiCompleteLockdown");
        String setRestriction = req.getParameter("setRestriction");
        if (setRestriction != null) {
            this.kerbConfManager.setRestApiRestrictedToApiTokens("on".equals(isRestApiRestrictedToTokens), "on".equals(isRestApiCompleteLockdown));
            postModel.put("isRestApiRestrictedToTokens", "on".equals(isRestApiRestrictedToTokens));
        }
        if (StringUtils.isNotBlank((CharSequence)(addRestrictedRestUrl = req.getParameter("addRestUrl")))) {
            this.tokenEndpointService.sanitizeRelativePath(addRestrictedRestUrl).onFailure(throwable -> {
                this.log.error("Could not save REST API token restricted REST API endpoint. Illegal input.", throwable);
                postModel.put("illegalInput", "Could not save '" + addRestrictedRestUrl + "'. Illegal input.");
            }).onSuccess(sanitizedRelativePath -> {
                String entireUrl = (String)this.tokenEndpointService.tryBuildEntireUrlForRestEndpoint((String)sanitizedRelativePath).getOrElse((Object)"");
                this.tokenEndpointService.addRestApiTokenEndpoint((String)sanitizedRelativePath).mapLeft(throwable -> throwable instanceof TokenEndpointServiceImpl.DuplicateEntryException ? Tuple.of((Object)"addedEndpointError", (Object)("Duplicate entry. The url '" + entireUrl + "' has already been restriced.")) : Tuple.of((Object)"addedEndpointError", (Object)("Something went wrong adding token endpoint: " + throwable.getMessage()))).map(restrictAPIEndpoint -> "Successfully restricted " + entireUrl).peekLeft(left -> {
                    postModel.put((String)left._1(), left._2());
                    postModel.put("attemptedToSaveUrl", entireUrl);
                });
            });
        }
        String addUnblockedRestUrl = req.getParameter("addUnblockedRestUrl");
        String addUnblockedClientIP = StringUtils.trim((String)req.getParameter("addUnblockedClientIP"));
        if (StringUtils.isNotBlank((CharSequence)addUnblockedRestUrl)) {
            this.tokenEndpointService.sanitizeRelativePath(addUnblockedRestUrl).onFailure(throwable -> {
                this.log.error("Could not save ublocked REST API token restricted REST API endpoint. Illegal input.", throwable);
                postModel.put("illegalInputUnblocked", "Could not save '" + addUnblockedRestUrl + "'. Illegal input.");
            }).onSuccess(sanitizedRelativePath -> {
                String entireUnblockedUrl = (String)this.tokenEndpointService.tryBuildEntireUrlForRestEndpoint((String)sanitizedRelativePath).getOrElse((Object)"");
                this.tokenEndpointService.addUnblockedRestApiTokenEndpoint((String)sanitizedRelativePath, addUnblockedClientIP).mapLeft(throwable -> throwable instanceof TokenEndpointServiceImpl.DuplicateEntryException ? Tuple.of((Object)"addedUnblockEndpointError", (Object)("Duplicate entry. The url '" + entireUnblockedUrl + "' has already been restriced for ip '" + addUnblockedClientIP + "'")) : Tuple.of((Object)"addedUnblockEndpointError", (Object)("Something went wrong adding token endpoint: " + throwable.getMessage()))).map(restrictAPIEndpoint -> "Successfully restricted " + entireUnblockedUrl).peekLeft(left -> {
                    postModel.put((String)left._1(), left._2());
                    postModel.put("attemptedToSaveUrl", entireUnblockedUrl);
                });
            });
        }
        Option.of((Object)req.getParameter("removeRestUrl")).filter(StringUtils::isNotBlank).flatMap(this.tokenEndpointService::findRestApiTokenEndpointById).peek(this.tokenEndpointService::deleteRestApiTokenEndpoint);
        Option.of((Object)req.getParameter("removeUnblockedRestUrl")).filter(StringUtils::isNotBlank).flatMap(this.tokenEndpointService::findUnblockedRestApiTokenEndpointById).peek(this.tokenEndpointService::deleteUnblockedRestApiTokenEndpoint);
        String errorPageMessage = req.getParameter("errorPageMessage");
        if (errorPageMessage != null) {
            this.kerbConfManager.setLockedRestApiErrorPageMessage(errorPageMessage);
        }
        this.buildModelAndRenderTemplate(req, resp, postModel);
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalModelAttributes) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(additionalModelAttributes);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/rest-api-access.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        List<RestrictAPIEndpoint> restApiRestrictAPIEndpoints = this.tokenEndpointService.findAllRestApiTokenEndpoints();
        ArrayList<APIEndpoints> restrictEndpoints = new ArrayList<APIEndpoints>();
        ArrayList<APIEndpoints> unblockedEndpoints = new ArrayList<APIEndpoints>();
        for (RestrictAPIEndpoint restApiRestrictAPIEndpoint : restApiRestrictAPIEndpoints) {
            try {
                restApiRestrictAPIEndpoint.setCompleteUrl(HttpUrlUtils.urlDecode((String)restApiRestrictAPIEndpoint.getCompleteUrl()));
                restrictEndpoints.add(new APIEndpoints(restApiRestrictAPIEndpoint));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        restApiRestrictAPIEndpoints.stream().filter(endpoint -> this.pathIndicatesEntireAPIClosed(endpoint.getInternalPathRest())).filter(_endpoint -> this.kerbConfManager.isRestApiCompleteLockdown()).findFirst().ifPresent(endpoint -> {
            model.put("warningClosedDownEntireApi", true);
            model.put("submittedURIWarningClosedDownEntireApi", endpoint.getCompleteUrl());
        });
        List<UnblockAPIEndpoint> unblockedRestApiRestrictAPIEndpoints = this.tokenEndpointService.findAllUnblockedRestApiTokenEndpoints();
        for (UnblockAPIEndpoint unblockedRestApiRestrictAPIEndpoint : unblockedRestApiRestrictAPIEndpoints) {
            try {
                unblockedRestApiRestrictAPIEndpoint.setCompleteUrl(HttpUrlUtils.urlDecode((String)unblockedRestApiRestrictAPIEndpoint.getCompleteUrl()));
                unblockedEndpoints.add(new APIEndpoints(unblockedRestApiRestrictAPIEndpoint));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "rest-api-access");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("actualBaseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("isFecru", this.hostApp.isProductMatch("fecru"));
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.put("isRestApiRestrictedToToken", this.kerbConfManager.isRestApiRestrictedToApiTokens());
        model.put("isRestApiCompleteLockdown", this.kerbConfManager.isRestApiCompleteLockdown());
        model.put("restrictionFilename", KerbConfManager.getRestApiRestrictedFilename());
        model.put("restrictedRestApiUrls", restrictEndpoints);
        model.put("unblockedRestrictedRestApiUrls", unblockedEndpoints);
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("errorPageMessageDefault", this.kerbConfManager.getTemplateLockedRestApiErrorPageMessage());
        model.put("errorPageMessage", this.kerbConfManager.getLockedRestApiErrorPageMessage());
        return model;
    }

    private boolean pathIndicatesEntireAPIClosed(String restPath) {
        return (Boolean)Option.of((Object)restPath).map(HttpUrlUtils::sanitizeUrlForTrailingSlashes).map(path -> restPath.equals(this.REST) || restPath.equals(this.REST + "/api")).getOrElse((Object)false);
    }
}

