/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.GroupResult;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluator;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseEvaluator {
    protected final UserLookupService userLookupService;
    protected final HostApp hostApp;
    protected final UserManager userManager;
    private final Logger log = LoggerFactory.getLogger(SAMLResponseEvaluator.class);

    @Inject
    public ResponseEvaluator(@ComponentImport UserManager userManager, UserLookupService userLookupService, HostAppFactory hostAppFactory) {
        this.userManager = userManager;
        this.userLookupService = userLookupService;
        this.hostApp = hostAppFactory.getInstance();
    }

    private boolean isDomainAllowed(IdpConfiguration idpConfiguration, String userDomain) {
        if (idpConfiguration.getUsernamePolicy() == IdpConfiguration.UsernamePolicy.ANY) {
            return true;
        }
        return userDomain != null && idpConfiguration.getKnownDomains().contains(userDomain.toLowerCase());
    }

    public Try<? extends FederatedIdentityResponseEvaluationResult> evaluateResult(IdpConfiguration idpConfiguration, FederatedIdentityResponseEvaluationResult result, UserRecipe userRecipe, boolean addDefaultGroups) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            if (result.isConfiguredUsernameAttributeFound()) {
                String searchedUsername;
                String idpUsername = result.getConfiguredUsernameAttributeInfo().getValue();
                String userDomain = idpUsername.contains("@") ? idpUsername.substring(idpUsername.indexOf("@") + 1).toLowerCase() : null;
                result.setDomainAllowed(this.isDomainAllowed(idpConfiguration, userDomain));
                result.setUserDomain(userDomain);
                if (idpConfiguration.getUserLookupTransform() == IdpConfiguration.UserLookupTransform.NAME_PART) {
                    String namePart = idpUsername;
                    if (idpUsername.contains("@")) {
                        namePart = idpUsername.substring(0, idpUsername.indexOf("@"));
                    }
                    searchedUsername = namePart;
                } else {
                    searchedUsername = idpConfiguration.getUserLookupTransform() == IdpConfiguration.UserLookupTransform.REGEX ? UserMappingUtils.transformUsername(idpUsername, idpConfiguration.getUserTransformationRegexes()).orElse(idpUsername) : idpUsername;
                }
                result.setSearchedUsername(searchedUsername);
                List<UsernameSearchResult> searchResults = this.userLookupService.searchUserAccount(searchedUsername, idpConfiguration.getUserNotFoundPolicy(), idpConfiguration.getUserLookupAttribute(), addDefaultGroups);
                result.setSearchResult(searchResults);
                Optional<UsernameSearchResult> first = searchResults.stream().filter(r -> r.getResolvedUserPrincipalEntry() != null).findFirst();
                if (first.isPresent()) {
                    UsernameSearchResult usernameSearchResult = first.get();
                    result.setResolvedPrincipalEntry(usernameSearchResult.getResolvedUserPrincipalEntry());
                    if (usernameSearchResult.getUserProfile() == null) {
                        result.setUserProfile(this.userManager.getUserProfile(searchedUsername));
                    } else {
                        result.setUserProfile(usernameSearchResult.getUserProfile());
                    }
                    Directory directory = usernameSearchResult.getDirectory();
                    result.setReadOnlyDirectory(directory != null && !directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP));
                    result.setResolvedUserDirectory(usernameSearchResult.getDirectory());
                }
                if (idpConfiguration.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE || idpConfiguration.getUserUpdateNamePolicy() == IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME || idpConfiguration.getUserUpdateEmailPolicy() == IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL || idpConfiguration.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE) {
                    userRecipe.getUsername().setValue(searchedUsername);
                    result.setUserRecipe(userRecipe);
                }
            }
            return result;
        });
    }

    public void evaluateGroups(String username, List<ManagedGroup> managedGroups, Set<String> idpGroups, GroupEvaluation groupEvaluation) {
        groupEvaluation.setAllIdpGroupNames(idpGroups);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Evaluating Groups. Managed Groups [{}] SAML/OIDC[{}]", (Object)managedGroups.stream().map(mg -> String.format("'%s'", mg.getName())).collect(Collectors.joining(",")), (Object)idpGroups.stream().map(sg -> String.format("'%s'", sg)).collect(Collectors.joining(",")));
        }
        for (ManagedGroup group : managedGroups) {
            GroupResult groupResult = new GroupResult(group.getName(), idpGroups.contains(group.getName()), this.hostApp.isExistingGroup(group.getName()), this.hostApp.isUserInGroup(username, group.getName()));
            groupEvaluation.addManagedGroups(groupResult);
            this.log.debug("GroupResult: {}", (Object)groupResult);
        }
        HashSet<String> managedGroupNames = new HashSet<String>();
        for (ManagedGroup group : managedGroups) {
            managedGroupNames.add(group.getName());
        }
        for (String idpGroup : idpGroups) {
            if (!this.hostApp.isExistingGroup(idpGroup)) {
                groupEvaluation.addUnknownIdpGroup(idpGroup);
                continue;
            }
            if (managedGroupNames.contains(idpGroup)) continue;
            groupEvaluation.addUnmanagedIdpGroup(idpGroup);
        }
    }

    @NotNull
    public static String createUserRecipeErrorMessage(UserRecipe userRecipe) {
        if (userRecipe == null) {
            return "Account cannot be created because of missing user recipe";
        }
        if (userRecipe.getName() == null) {
            return "Account cannot be created because no name attributes were included in the user info endpoint";
        }
        if (userRecipe.getEmail() == null) {
            return "Account cannot be created because no email attribute was included in the user info endpoint";
        }
        return "Account cannot be created because of incomplete user recipe";
    }
}

