/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class UserAuthenticationAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final IdpConfManager idpConfManager;

    @Inject
    public UserAuthenticationAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String id = req.getParameter("id");
        Directory dir = this.connectorConfManager.getDirectory(id);
        if (dir == null) {
            resp.sendError(404);
            return;
        }
        model.put("currentConnector", dir);
        model.put("topMenu", "connectors");
        model.put("menuItem", "userAuthentication");
        model.put("displayName", this.applicationProperties.getDisplayName());
        ConnectorType connectorType = this.connectorConfManager.getConnectorTypes().get(dir.getKind());
        IdpConfiguration.Kind identityProviderKind = connectorType.getIdentityProviderKind();
        List<IdpConfiguration> providersOfKind = this.idpConfManager.getProvidersByKind(identityProviderKind);
        model.put("connectorType", connectorType);
        model.put("identityProviderKind", (Object)identityProviderKind);
        model.put("providersOfKind", providersOfKind);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/connector/user-authentication.vm", model, (Writer)resp.getWriter());
    }
}

