/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.upgrade.configuration;

import io.vavr.collection.List;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradeMessage;
import org.kantega.atlaskerb.utils.Version;

public class ActiveObjectsUpgrade {
    private final ApiTokenService apiTokenService;
    private final TokenEndpointService tokenEndpointService;
    private final KerbConfManager kerbConfManager;

    public ActiveObjectsUpgrade(ApiTokenService apiTokenService, TokenEndpointService tokenEndpointService, KerbConfManager kerbConfManager) {
        this.apiTokenService = apiTokenService;
        this.tokenEndpointService = tokenEndpointService;
        this.kerbConfManager = kerbConfManager;
    }

    @NotNull
    public List<UpgradeMessage> run() {
        return List.of((Object)this.updateApiTokens());
    }

    @NotNull
    private UpgradeMessage updateApiTokens() {
        return this.apiTokenService.migrateOldSettings() ? new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Successfully updated Kantega SSO Enterprise API Tokens to new format.") : new UpgradeMessage(KssoUpgradeManager.ResultCode.FAILURE, "Failed to update Kantega SSO Enterprise API Tokens to new format.");
    }

    public boolean isBreakingChanges() {
        Version versionWithNewFieldsInApiToken = new Version("5.7.0");
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.compareTo(versionWithNewFieldsInApiToken) < 0).getOrElse((Object)true);
    }
}

