/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class ConfigureKerberosKnowledgeBaseAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public ConfigureKerberosKnowledgeBaseAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("kerberosKnowledgeBaseEnabled", this.kerbConfManager.isKerberosKnowledgeBaseEnabled());
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/disable-kerberos-knowledgebase.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.kerbConfManager.setKerberosKnowledgeBaseEnabled(StringUtils.equalsIgnoreCase((CharSequence)"on", (CharSequence)req.getParameter("kerberosKnowledgeBaseEnabled")));
        resp.sendRedirect("disable-kerberos-knowledgebase");
    }
}

