/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.ExceptionTool;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.diagnostics.FailureListener;

public class ClientFailureServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final FailureListener failureListener;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public ClientFailureServlet(RequireAdminServletDependencyBucket bucket, FailureListener failureListener) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.failureListener = failureListener;
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "Kerberos");
        model.put("menuItem", "failures");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("failures", this.failureListener.failures());
        model.put("exceptionTool", new ExceptionTool());
        model.put("dateTool", new DateTool());
        model.put("enableFailureDetection", this.kerbConfManager.isClientFailureCollectionEnabled());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/failures.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("enableFailureDetection") != null) {
            this.kerbConfManager.setClientFailureCollectionEnabled(true);
        } else {
            this.kerbConfManager.setClientFailureCollectionEnabled(false);
        }
        resp.sendRedirect("failures");
    }
}

