/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import kantega.shaded.org.opensaml.core.xml.XMLObject;
import kantega.shaded.org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import kantega.shaded.org.opensaml.core.xml.io.UnmarshallingException;
import kantega.shaded.org.opensaml.core.xml.util.XMLObjectSupport;
import kantega.shaded.org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import kantega.shaded.org.opensaml.saml.saml2.metadata.EntityDescriptor;
import kantega.shaded.org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import kantega.shaded.org.opensaml.saml.saml2.metadata.KeyDescriptor;
import kantega.shaded.org.opensaml.saml.saml2.metadata.RoleDescriptor;
import kantega.shaded.org.opensaml.saml.saml2.metadata.SingleLogoutService;
import kantega.shaded.org.opensaml.saml.saml2.metadata.SingleSignOnService;
import kantega.shaded.org.opensaml.security.credential.UsageType;
import kantega.shaded.org.opensaml.xmlsec.signature.X509Certificate;
import kantega.shaded.org.opensaml.xmlsec.signature.X509Data;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.codec.binary.Base64;

public class MetadataParser {
    private final ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();

    public EntityDescriptor parse(InputStream is) {
        try {
            XMLObject xmlObject = XMLObjectSupport.unmarshallFromInputStream((ParserPool)this.parserPool, (InputStream)is);
            if (xmlObject instanceof EntityDescriptor) {
                return (EntityDescriptor)xmlObject;
            }
            if (xmlObject instanceof EntitiesDescriptor) {
                return (EntityDescriptor)((EntitiesDescriptor)xmlObject).getEntityDescriptors().get(0);
            }
            throw new IllegalArgumentException("Could not parse metadata");
        }
        catch (XMLParserException e) {
            throw new RuntimeException(e);
        }
        catch (UnmarshallingException e) {
            throw new RuntimeException(e);
        }
    }

    public IDPSSODescriptor getIDPDescriptorForSaml(EntityDescriptor entityDescriptor) {
        return entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    public IdpSsoLocation getIdpSsoLocation(IDPSSODescriptor idp) {
        String locationRedirect = null;
        String locationPost = null;
        for (SingleSignOnService ssoService : idp.getSingleSignOnServices()) {
            String binding = ssoService.getBinding();
            if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                locationRedirect = ssoService.getLocation();
            }
            if (!binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
            locationPost = ssoService.getLocation();
        }
        return new IdpSsoLocation(locationRedirect != null ? locationRedirect : locationPost, locationRedirect == null && locationPost != null);
    }

    public String getIdpSingleLogoutServiceURL(IDPSSODescriptor idp) {
        for (SingleLogoutService service : idp.getSingleLogoutServices()) {
            String binding = service.getBinding();
            if (!binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) continue;
            return service.getLocation();
        }
        return null;
    }

    public List<byte[]> getSigningCerts(IDPSSODescriptor idp) {
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        for (KeyDescriptor keyDescriptor : idp.getKeyDescriptors()) {
            if (keyDescriptor.getUse() == UsageType.ENCRYPTION) continue;
            this.addCerts(certs, keyDescriptor);
        }
        return certs;
    }

    private void addCerts(List<byte[]> certs, KeyDescriptor keyDescriptor) {
        for (X509Data x509Data : keyDescriptor.getKeyInfo().getX509Datas()) {
            for (X509Certificate certificate : x509Data.getX509Certificates()) {
                String base64 = certificate.getValue();
                certs.add(Base64.decodeBase64((String)base64));
            }
        }
    }

    public String getIdpServiceDisplayName(EntityDescriptor entityDescriptor) {
        List securityTokenServiceType = entityDescriptor.getRoleDescriptors(new QName("http://docs.oasis-open.org/wsfed/federation/200706", "SecurityTokenServiceType"));
        for (RoleDescriptor roleDescriptor : securityTokenServiceType) {
        }
        return null;
    }

    public class IdpSsoLocation {
        final String location;
        final boolean usePostBinding;

        public IdpSsoLocation(String location, boolean usePostBinding) {
            this.location = location;
            this.usePostBinding = usePostBinding;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean usePostBinding() {
            return this.usePostBinding;
        }
    }
}

