/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.apitokens;

import com.atlassian.sal.api.user.UserKey;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.apitokens.ApiTokenV570;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

public class Util {
    public static Option<String> extractApiToken(HttpServletRequest request, String body) {
        return JsonMapping.Write.stringAsJson((String)body).mapTry((CheckedFunction1 & Serializable)json -> json.optString("apiToken", "")).toOption().filter(str -> !str.isEmpty()).orElse(HttpUrlUtils.extractApiTokenFromBasicAuthHeader((HttpServletRequest)request));
    }

    public static JSONObject apiTokenObjectToJsonV1(ApiTokenV570 apiToken, UserKey userKey) {
        JSONObject apiTokenJson = new JSONObject();
        apiTokenJson.put("id", apiToken.getID());
        apiTokenJson.put("description", (Object)apiToken.getTokenName());
        long timeUntilExpiryMillis = ApiTokenUtil.Time.calculateTimeUntilExpiry(apiToken);
        apiTokenJson.put("createdAtMillis", apiToken.getCreatedAt());
        apiTokenJson.put("createdAt", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date(apiToken.getCreatedAt())));
        apiTokenJson.put("expiresAt", (Object)ApiTokenUtil.Time.getExpiryDateTime(apiToken.getCreatedAt(), apiToken.getValidFor()));
        apiTokenJson.put("username", (Object)apiToken.getUsername());
        Option.of((Object)userKey).map(UserKey::getStringValue).peek(userKeyString -> apiTokenJson.put("userKey", userKeyString));
        if (timeUntilExpiryMillis >= 0L) {
            apiTokenJson.put("timeUntilExpiryMillis", timeUntilExpiryMillis);
            apiTokenJson.put("timeUntilExpiryDays", (Object)ApiTokenUtil.Time.convertMillisToDays(timeUntilExpiryMillis));
        }
        return apiTokenJson;
    }

    public static JSONObject apiTokenObjectToJson(ApiTokenV570 apiToken) {
        JSONObject apiTokenJson = new JSONObject();
        apiTokenJson.put("id", apiToken.getID());
        apiTokenJson.put("description", (Object)apiToken.getDescription());
        apiTokenJson.put("tokenName", (Object)apiToken.getTokenName());
        long timeUntilExpiryMillis = ApiTokenUtil.Time.calculateTimeUntilExpiry(apiToken);
        apiTokenJson.put("createdAtMillis", apiToken.getCreatedAt());
        apiTokenJson.put("createdAt", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date(apiToken.getCreatedAt())));
        apiTokenJson.put("expiresAt", (Object)ApiTokenUtil.Time.getExpiryDateTime(apiToken.getCreatedAt(), apiToken.getValidFor()));
        apiTokenJson.put("username", (Object)apiToken.getUsername());
        if (timeUntilExpiryMillis >= 0L) {
            apiTokenJson.put("timeUntilExpiryMillis", timeUntilExpiryMillis);
            apiTokenJson.put("timeUntilExpiryDays", (Object)ApiTokenUtil.Time.convertMillisToDays(timeUntilExpiryMillis));
        }
        return apiTokenJson;
    }
}

