/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.msteams;

import com.atlassian.json.jsonorg.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.intercept.filter.AtlasKerberosMainAuthFilter;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.msteams.MsalAuthHelper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsTeamsLoginServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MsTeamsLoginServlet.class);
    private final UserLookupService userLookupService;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;
    public static final String MS_GRAPH_URL = "https://graph.microsoft.com/v1.0/me";
    MsalAuthHelper msalAuthHelper;

    @Inject
    public MsTeamsLoginServlet(RequireAdminServletDependencyBucket bucket, MsalAuthHelper msalAuthHelper) {
        this.msalAuthHelper = msalAuthHelper;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostApp();
        this.userLookupService = bucket.getUserLookupService();
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        String tenantId = null;
        String token = null;
        try {
            JSONObject jsonObject = this.getJsonFromRequestBody(req);
            tenantId = jsonObject.get("tid").toString();
            token = jsonObject.get("token").toString();
        }
        catch (IOException e) {
            log.error("Problem getting JSON data with tenantId and token from Teams login");
            resp.setStatus(400);
            return;
        }
        String graphResponse = this.callMicrosoftAzureAd(this.kerbConfManager.getMsTeamsClientId(), this.kerbConfManager.getMsTeamsSecret(), tenantId, token);
        String finalTenantId = tenantId;
        Optional<IdpConfiguration> maybeIdpConfiguration = this.idpConfManager.getIdentityProviders().stream().filter(idpConfiguration -> {
            if (idpConfiguration.isEnabled() && idpConfiguration instanceof OidcIdpConfiguration) {
                OidcIdpConfiguration oidcIdp = (OidcIdpConfiguration)idpConfiguration;
                return StringUtils.contains((CharSequence)oidcIdp.getDiscoveryUrl(), (CharSequence)finalTenantId);
            }
            return false;
        }).findFirst();
        IdpConfiguration idpConfiguration2 = maybeIdpConfiguration.orElseGet(() -> {
            log.error("No OIDC IdpConfiguration found for tenantId: " + finalTenantId);
            return null;
        });
        if (idpConfiguration2 != null && idpConfiguration2 instanceof OidcIdpConfiguration && !this.containsUserPrincipalName(graphResponse)) {
            OidcIdpConfiguration oidcIdp = (OidcIdpConfiguration)idpConfiguration2;
            graphResponse = this.callMicrosoftAzureAd(oidcIdp.getClientId(), oidcIdp.getClientSecret(), tenantId, token);
        }
        if (this.containsUserPrincipalName(graphResponse)) {
            String searchedUsername;
            String idpUsername = (String)new JSONObject(graphResponse).get("userPrincipalName");
            if (idpConfiguration2 != null) {
                if (idpConfiguration2.getUserLookupTransform() == IdpConfiguration.UserLookupTransform.NAME_PART) {
                    String namePart = idpUsername;
                    if (idpUsername.contains("@")) {
                        namePart = idpUsername.substring(0, idpUsername.indexOf("@"));
                    }
                    searchedUsername = namePart;
                } else {
                    searchedUsername = idpConfiguration2.getUserLookupTransform() == IdpConfiguration.UserLookupTransform.REGEX ? UserMappingUtils.transformUsername(idpUsername, idpConfiguration2.getUserTransformationRegexes()).orElse(idpUsername) : idpUsername;
                }
            } else {
                searchedUsername = idpUsername;
            }
            PrincipalEntry principalEntry = this.userLookupService.resolveUser(searchedUsername);
            if (principalEntry.getPrincipal().isPresent()) {
                Principal principal = principalEntry.getPrincipal().get();
                this.hostApp.publishUserAuthenticatedEvent(principal, req, resp);
                AtlasKerberosMainAuthFilter.authenticateWithProduct(req, resp, principal, this.kerbConfManager, this.hostApp);
                resp.setStatus(200);
                return;
            }
        }
        resp.setStatus(500);
    }

    private boolean containsUserPrincipalName(String graphResponse) {
        return StringUtils.contains((CharSequence)graphResponse, (CharSequence)"\"userPrincipalName\"");
    }

    @Nullable
    private String callMicrosoftAzureAd(String clientId, String secret, String tenantId, String token) {
        String graphResponse = null;
        try {
            if (clientId != null && secret != null) {
                String oboAccessToken = this.msalAuthHelper.getOboToken("https://graph.microsoft.com/User.Read email offline_access openid profile", tenantId, token, clientId, secret);
                graphResponse = this.callMicrosoftGraphMeEndpoint(oboAccessToken);
            }
        }
        catch (Exception e) {
            log.error("Problem calling Microsoft Graph API to get user data during Teams login", (Throwable)e);
        }
        return graphResponse;
    }

    @NotNull
    private JSONObject getJsonFromRequestBody(HttpServletRequest req) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = req.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        JSONObject jsonObject = new JSONObject(stringBuilder.toString());
        return jsonObject;
    }

    private String callMicrosoftGraphMeEndpoint(String accessToken) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(MS_GRAPH_URL);
        String authHeader = MessageFormat.format("Bearer {0}", accessToken);
        request.setHeader("Authorization", authHeader);
        request.setHeader("Content-Type", "application/json");
        log.info("callMicrosoftGraphMeEndpoint");
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }
}

