/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.CheckedFunction0;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kantega.shaded.org.opensaml.saml.saml2.core.AuthnRequest;
import kantega.shaded.org.opensaml.saml.saml2.core.Response;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcTestRecord;
import org.kantega.atlaskerb.saml.EvaluateTestServlet;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.TestRecord;
import org.kantega.atlaskerb.saml.util.XmlUtils;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugInfoServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(DebugInfoServlet.class);
    final ConnectorConfManager connectorConfManager;
    final HostApp hostApp;
    final IdpConfManager idpConfManager;
    final KerbConfManager kerbConfManager;
    final ScimConfManager scimConfManager;
    final TemplateRenderer templateRenderer;
    final UserLookupService userLookupService;
    final ApiServerConfManager apiServerConfManager;

    @Inject
    public DebugInfoServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.hostApp = bucket.getHostApp();
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.scimConfManager = bucket.getScimConfManager();
        this.templateRenderer = bucket.getTemplateRenderer();
        this.userLookupService = bucket.getUserLookupService();
        this.apiServerConfManager = bucket.getApiServerConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONObject debugInfo = new JSONObject();
        debugInfo.put("connectorConfManager", Try.of((CheckedFunction0 & Serializable)() -> this.connectorConfManager).mapTry(ConnectorConfManager::asJson).getOrElse((Object)new JSONObject()));
        debugInfo.put("connectorDirectories", (Collection)List.ofAll(this.connectorConfManager.getDirectories()).map(directory -> (JSONObject)Try.of(directory::asJson).onFailure(t -> log.debug("Failed to add connectors to KSSO debug info: ", t)).getOrElse(JSONObject::new)).toJavaList());
        debugInfo.put("scimConfManager", Try.of((CheckedFunction0 & Serializable)() -> this.scimConfManager).mapTry(ScimConfManager::asJson).onFailure(t -> log.error("Failed to add SCIM to KSSO debug info: ", t)).getOrElse((Object)new JSONObject()));
        debugInfo.put("idpConfManager", Try.of((CheckedFunction0 & Serializable)() -> this.idpConfManager).mapTry(IdpConfManager::asJson).onFailure(t -> log.error("Failed to add idp conf manager to KSSO debug info: ", t)).getOrElse((Object)new JSONObject()));
        debugInfo.put("idpConfigs", (Collection)List.ofAll(this.idpConfManager.getIdentityProviders()).map(idpConfiguration -> (JSONObject)Try.of(idpConfiguration::asJson).onFailure(t -> log.error("Failed to add identity providers to KSSO debug info: ", t)).getOrElse(JSONObject::new)).toJavaList());
        debugInfo.put("hostApp", Try.of((CheckedFunction0 & Serializable)() -> this.hostApp).mapTry(DebugInfo::asJson).onFailure(t -> log.error("Failed to add hostapp to KSSO debug info: ", t)).getOrElse((Object)new JSONObject()));
        debugInfo.put("kerbConfManager", Try.of((CheckedFunction0 & Serializable)() -> this.kerbConfManager).mapTry(KerbConfManager::asJson).onFailure(t -> log.error("Failed to add kerbConfManager to KSSO debug info: ", t)).getOrElse((Object)new JSONObject()));
        debugInfo.put("apiServerConfManager", Try.of((CheckedFunction0 & Serializable)() -> this.apiServerConfManager).mapTry(ApiServerConfManager::asJson).getOrElse((Object)new JSONObject()));
        debugInfo.put("userLookupService", Try.of((CheckedFunction0 & Serializable)() -> this.userLookupService).mapTry(UserLookupService::asJson).onFailure(t -> log.error("Failed to add userLookupService to KSSO debug info: ", t)).getOrElse((Object)new JSONObject()));
        try {
            JSONArray testResultsJsonArray = new JSONArray();
            List.ofAll(this.idpConfManager.getIdentityProviders()).filter(IdpConfiguration::isEnabled).forEach(idp -> {
                List recordedTests = List.ofAll(this.idpConfManager.getRecordedTests(idp.getId()));
                if (idp.isOidc()) {
                    JSONArray oidcTestRecords = (JSONArray)Try.of((CheckedFunction0 & Serializable)() -> recordedTests.filter(testRecord -> testRecord.getSsoProtocol() == IdpConfiguration.SSOProtocol.OIDC).map(OidcTestRecord::ofTestRecord).map(oidcRecord -> this.buildOidcTestRecordJson((IdpConfiguration)idp, (OidcTestRecord)oidcRecord)).toJavaSet()).mapTry(JSONArray::new).onFailure(t -> log.debug("Failed to add OIDC data to KSSO debug info: ", t)).getOrElse((Object)new JSONArray());
                    JSONObject oidcJsonTest = new JSONObject();
                    oidcJsonTest.put("oidc-test-results-idp-" + idp.getId(), (Object)oidcTestRecords);
                    testResultsJsonArray.put((Object)oidcJsonTest);
                } else {
                    JSONArray samlTestRecords = (JSONArray)Try.of((CheckedFunction0 & Serializable)() -> recordedTests.filter(record -> record.getSsoProtocol() != IdpConfiguration.SSOProtocol.OIDC).map(record -> this.buildSamlTestRecordJson((IdpConfiguration)idp, (TestRecord)record)).toJavaSet()).mapTry(JSONArray::new).onFailure(t -> log.debug("Failed to add SAML data to KSSO debug info: ", t)).getOrElse((Object)new JSONArray());
                    JSONObject samlJsonTest = new JSONObject();
                    samlJsonTest.put("saml-test-results-idp-" + idp.getId(), (Object)samlTestRecords);
                    testResultsJsonArray.put((Object)samlJsonTest);
                }
            });
            debugInfo.put("testResults", (Object)testResultsJsonArray);
        }
        catch (Exception e) {
            log.debug("Failed to build test records into debug info: ", (Throwable)e);
        }
        try {
            DebugInfoServlet.scrambleJson(debugInfo, "ldap.password");
            DebugInfoServlet.scrambleJson(debugInfo, "application.password");
            DebugInfoServlet.scrambleJson(debugInfo, "clientSecret");
            DebugInfoServlet.scrambleJson(debugInfo, "applicationSecret");
            DebugInfoServlet.scrambleJson(debugInfo, "privateKey");
            DebugInfoServlet.scrambleJson(debugInfo, "kc_password");
            DebugInfoServlet.scrambleJson(debugInfo, "password");
            DebugInfoServlet.scrambleJson(debugInfo, "client_secret");
            DebugInfoServlet.scrambleJson(debugInfo, "ksso.ldapPassword");
            DebugInfoServlet.scrambleJson(debugInfo, KerbConfManager.KEYS.LDAP_PASSWORD_ENCRYPTION_KEY.name());
        }
        catch (Exception e) {
            log.error("Unable to scramble debug info JSON", (Throwable)e);
        }
        resp.setContentType("text/html");
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "support");
        model.put("menuItem", "debuginfo");
        model.put("debugInfo", debugInfo.toString(4));
        this.templateRenderer.render("templates/debuginfo.vm", model, (Writer)resp.getWriter());
    }

    @NotNull
    private JSONObject buildOidcTestRecordJson(IdpConfiguration idp, OidcTestRecord oidcRecord) {
        File responseFile;
        Try<String> oidcProcedureJson;
        JSONObject testJson = new JSONObject();
        testJson.put("record", (Object)oidcRecord.asJson());
        File beforeRequestProcedureFile = this.idpConfManager.getRecordedTestOidcProcedureFileBeforeRequest(idp.getId(), oidcRecord.getId());
        File initProcedureFile = this.idpConfManager.getRecordedTestStartedOIDCProcedureFile(idp.getId(), oidcRecord.getId());
        if (beforeRequestProcedureFile.exists()) {
            oidcProcedureJson = TestUtils.readOidcProcedureJsonRepresentationFromFile(beforeRequestProcedureFile);
            oidcProcedureJson.onSuccess(jsonString -> testJson.put("oidcProcedureJsonBeforeRequest", (Object)new JSONObject(jsonString)));
        } else if (initProcedureFile.exists()) {
            oidcProcedureJson = TestUtils.readOidcProcedureJsonRepresentationFromFile(initProcedureFile);
            oidcProcedureJson.onSuccess(jsonString -> testJson.put("oidcProcedureJsonBeforeRequest", (Object)new JSONObject(jsonString)));
        }
        File afterResponseProcedureFile = this.idpConfManager.getRecordedTestOidcProcedureFileAfterResponse(idp.getId(), oidcRecord.getId());
        if (afterResponseProcedureFile.exists()) {
            Try<String> oidcProcedureJson2 = TestUtils.readOidcProcedureJsonRepresentationFromFile(afterResponseProcedureFile);
            oidcProcedureJson2.onSuccess(jsonString -> testJson.put("oidcProcedureJsonAfterResponse", (Object)new JSONObject(jsonString)));
        }
        if ((responseFile = this.idpConfManager.getRecordedOidcTestResponseFile(idp.getId(), oidcRecord.getId())).exists()) {
            JSONObject profileJson = EvaluateTestServlet.parseJsonProfile(responseFile);
            testJson.put("profile", (Object)profileJson);
        }
        return testJson;
    }

    @NotNull
    private JSONObject buildSamlTestRecordJson(IdpConfiguration idp, TestRecord testRecord) {
        File responseFile;
        JSONObject testJson = new JSONObject();
        testJson.put("record", (Object)testRecord.asJson());
        File requestFile = this.idpConfManager.getRecordedTestRequestFile(idp.getId(), testRecord.getId());
        if (requestFile.exists()) {
            AuthnRequest authnRequest = XmlUtils.parseRequestFile(requestFile);
            testJson.put("requestXML", (Object)XmlUtils.formatXml(authnRequest.getDOM()));
        }
        if ((responseFile = this.idpConfManager.getRecordedTestResponseFile(idp.getId(), testRecord.getId())).exists()) {
            Response response = XmlUtils.parseResponseFile(responseFile);
            testJson.put("responseXML", (Object)XmlUtils.formatXml(response.getDOM()));
        }
        return testJson;
    }

    private static void scrambleJson(JSONObject obj, String key) throws Exception {
        Iterator iterator = obj.keys();
        String currentKey = null;
        while (iterator.hasNext()) {
            currentKey = (String)iterator.next();
            if (obj.optJSONArray(currentKey) == null && obj.optJSONObject(currentKey) == null && currentKey.equals(key)) {
                obj.put(currentKey, (Object)"**********");
                return;
            }
            if (obj.optJSONObject(currentKey) != null) {
                DebugInfoServlet.scrambleJson(obj.getJSONObject(currentKey), key);
            }
            if (obj.optJSONArray(currentKey) == null) continue;
            JSONArray jArray = obj.getJSONArray(currentKey);
            for (int i = 0; i < jArray.length(); ++i) {
                if (jArray.optJSONObject(i) == null) continue;
                DebugInfoServlet.scrambleJson(jArray.getJSONObject(i), key);
            }
        }
    }
}

