/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.usercleanup.v2.config.model.util;

import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupAction;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.PostCleanupAction;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CronAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupRuleDTOV2;
import org.kantega.atlaskerb.usercleanup.v2.config.model.ScheduledCleanupRuleAo;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScheduledCleanupRuleMapper {
    private final JsonWrapper jsonWrapper;
    private final Logger log = LoggerFactory.getLogger(ScheduledCleanupRuleMapper.class);

    @Inject
    public ScheduledCleanupRuleMapper(JsonWrapper jsonWrapper) {
        this.jsonWrapper = jsonWrapper;
    }

    public ScheduledCleanupRuleAo mapCleanupRuleToActiveObjects(@NonNull CleanupRuleDTOV2 jsonDtoCleanupRule, @NonNull ScheduledCleanupRuleAo scheduledCleanupRuleAo) {
        scheduledCleanupRuleAo.setChangedByUsername(jsonDtoCleanupRule.getChangedByUsername());
        scheduledCleanupRuleAo.setDisplayName(jsonDtoCleanupRule.getDisplayName());
        scheduledCleanupRuleAo.setDaysInactiveThreshold(jsonDtoCleanupRule.getDaysInactiveThreshold());
        scheduledCleanupRuleAo.setDirectoriesWhitelist(ListParseUtils.arrayToCommaSeparatedString(jsonDtoCleanupRule.getDirectoriesWhitelist()));
        scheduledCleanupRuleAo.setGroupsWhitelist(ListParseUtils.arrayToCommaSeparatedString(jsonDtoCleanupRule.getGroupsWhitelist()));
        scheduledCleanupRuleAo.setUsersWhitelist(ListParseUtils.arrayToCommaSeparatedString(jsonDtoCleanupRule.getUsersWhitelist()));
        this.jsonWrapper.tryBuildJsonString(jsonDtoCleanupRule.getCronAttributes()).onSuccess(scheduledCleanupRuleAo::setCronAttributesJson).onFailure(t -> this.log.warn("Failed to parse cronattributes {} for cleanup rule with ID {}", new Object[]{jsonDtoCleanupRule.getCronAttributes(), scheduledCleanupRuleAo.getID(), t}));
        scheduledCleanupRuleAo.setCleanupMode(jsonDtoCleanupRule.getCleanupMode().toString());
        scheduledCleanupRuleAo.setCleanupAction(jsonDtoCleanupRule.getCleanupAction().toString());
        scheduledCleanupRuleAo.setGroupsToRemove(ListParseUtils.arrayToCommaSeparatedString(jsonDtoCleanupRule.getGroupsToRemove()));
        scheduledCleanupRuleAo.setCleanupEligibleGroups(ListParseUtils.arrayToCommaSeparatedString(jsonDtoCleanupRule.getCleanupEligibleGroups()));
        scheduledCleanupRuleAo.setTotalBillableUsers(jsonDtoCleanupRule.getTotalBillableUsers());
        scheduledCleanupRuleAo.setMaximumNumberOfUsers(jsonDtoCleanupRule.getMaximumNumberOfUsers());
        scheduledCleanupRuleAo.setJobRunnerKey(jsonDtoCleanupRule.getJobRunnerKey());
        scheduledCleanupRuleAo.setPostCleanupAction(jsonDtoCleanupRule.getPostCleanupAction().toString());
        scheduledCleanupRuleAo.setTargetDirectoryTemplate(jsonDtoCleanupRule.getTargetDirectoryTemplate());
        scheduledCleanupRuleAo.setGroupsToAdd(ListParseUtils.arrayToCommaSeparatedString(jsonDtoCleanupRule.getGroupsToAdd()));
        return scheduledCleanupRuleAo;
    }

    public CleanupRuleDTOV2 mapActiveObjectsToCleanupRule(ScheduledCleanupRuleAo scheduledCleanupRuleAo) {
        return new CleanupRuleDTOV2(String.valueOf(scheduledCleanupRuleAo.getID()), scheduledCleanupRuleAo.getJobRunnerKey(), scheduledCleanupRuleAo.getDisplayName(), scheduledCleanupRuleAo.getDaysInactiveThreshold(), false, scheduledCleanupRuleAo.getChangedByUsername(), (CleanupMode)((Object)CleanupMode.parse(scheduledCleanupRuleAo.getCleanupMode()).onFailure(t -> this.log.warn("Failed to parse CleanupMode from {} in cleanup rule with ID {} ", new Object[]{scheduledCleanupRuleAo.getCleanupMode(), scheduledCleanupRuleAo.getID(), t})).getOrElse((Object)CleanupMode.USERS)), (CleanupAction)((Object)CleanupAction.parse(scheduledCleanupRuleAo.getCleanupAction()).onFailure(t -> this.log.warn("Failed to parse CleanupAction from {} in cleanup rule with ID {} ", new Object[]{scheduledCleanupRuleAo.getCleanupAction(), scheduledCleanupRuleAo.getID(), t})).getOrElse((Object)CleanupAction.REMOVE_FROM_GROUP)), ListParseUtils.parseArrayFromCommaSeparated(scheduledCleanupRuleAo.getGroupsToRemove()), ListParseUtils.parseArrayFromCommaSeparated(scheduledCleanupRuleAo.getDirectoriesWhitelist()), ListParseUtils.parseArrayFromCommaSeparated(scheduledCleanupRuleAo.getGroupsWhitelist()), ListParseUtils.parseArrayFromCommaSeparated(scheduledCleanupRuleAo.getUsersWhitelist()), (CronAttributes)this.jsonWrapper.tryReadJavaObjectFromJson(scheduledCleanupRuleAo.getCronAttributesJson(), CronAttributes.class).onFailure(t -> this.log.warn("Failed to read cron attributes from saved cleanup rule json {}.", (Object)scheduledCleanupRuleAo.getCronAttributesJson(), t)).getOrNull(), ListParseUtils.parseArrayFromCommaSeparated(scheduledCleanupRuleAo.getCleanupEligibleGroups()), scheduledCleanupRuleAo.getTotalBillableUsers(), scheduledCleanupRuleAo.getMaximumNumberOfUsers(), (PostCleanupAction)((Object)PostCleanupAction.parse(scheduledCleanupRuleAo.getPostCleanupAction()).onFailure(t -> this.log.warn("Failed to parse CleanupAction from {} in cleanup rule with ID {} ", new Object[]{scheduledCleanupRuleAo.getPostCleanupAction(), scheduledCleanupRuleAo.getID(), t})).getOrElse((Object)PostCleanupAction.NONE)), scheduledCleanupRuleAo.getTargetDirectoryTemplate(), ListParseUtils.parseArrayFromCommaSeparated(scheduledCleanupRuleAo.getGroupsToAdd()));
    }
}

