/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.update;

import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.CheckedFunction1;
import io.vavr.Value;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.backup.BackupService;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV1;
import org.kantega.atlaskerb.update.ResultCode;
import org.kantega.atlaskerb.update.data.UpdateMessage;
import org.kantega.atlaskerb.update.data.UpdatePluginSettingsEntryResult;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KssoUpdateManagerCleanup {
    private static final Logger log = LoggerFactory.getLogger(KssoUpdateManagerCleanup.class);
    private final KerbConfManager kerbConfManager;
    private final BackupService backupService;
    private final GlobalConfigUpdate globalConfigUpdate;

    @Inject
    public KssoUpdateManagerCleanup(KerbConfManager kerbConfManager, BackupService backupService, CleanupHostAppFactoryV1 hostAppFactory) {
        this.kerbConfManager = kerbConfManager;
        this.globalConfigUpdate = new GlobalConfigUpdate(kerbConfManager, hostAppFactory);
        this.backupService = backupService;
    }

    public io.vavr.collection.List<UpdateMessage> doUpdate() {
        log.info("Running update routine of Kantega SSO Enterprise.");
        try {
            if (!this.isKssoConfigUpdateNeeded()) {
                log.info("Config already up to date. Skipping update.");
                return io.vavr.collection.List.of((Object)new UpdateMessage(ResultCode.SUCCESS, "Configuration is already up to date."));
            }
            log.info("Version change indicates update of Kantega SSO Enterprise needed.");
            boolean isBackupSuccess = this.saveBackupOfConfig();
            if (!isBackupSuccess) {
                return io.vavr.collection.List.of((Object)new UpdateMessage(ResultCode.FAILURE, "Failed to take a backup of config. Update was aborted."));
            }
            io.vavr.collection.List<UpdateMessage> updateMessages = this.globalConfigUpdate.run();
            if (updateMessages.forAll(UpdateMessage::isSuccess)) {
                log.info("Successful update of Kantega SSO Enterprise. Updating version in config.");
                try {
                    this.kerbConfManager.updateKssoVersionInConfig();
                    return updateMessages.append((Object)new UpdateMessage(ResultCode.SUCCESS, "Updated version in config"));
                }
                catch (Exception e) {
                    log.error("Encountered an error while updating the version of config.");
                    return updateMessages.append((Object)new UpdateMessage(ResultCode.VERSION_CHANGE_FAILURE, "Could not update the configuration version. Please re-try to confirm the update."));
                }
            }
            log.warn("Failed to update some settings during configuration update of Kantega SSO Enterprise:");
            log.info("Successful updates: " + (String)updateMessages.filter(UpdateMessage::isSuccess).map(UpdateMessage::toString).intersperse((Object)", ").foldLeft((Object)"", String::concat));
            log.warn("Failed updates: " + (String)updateMessages.filter(UpdateMessage::isFailure).map(UpdateMessage::toString).intersperse((Object)", ").foldLeft((Object)"", String::concat));
            return updateMessages;
        }
        catch (Exception e) {
            String msg = "Encountered an error during configuration update of Kantega SSO Enterprise. Please try again or refer to the logs for more information about what went wrong.";
            log.error("Encountered an error during configuration update of Kantega SSO Enterprise. Please try again or refer to the logs for more information about what went wrong.", (Throwable)e);
            return io.vavr.collection.List.of((Object)new UpdateMessage(ResultCode.FAILURE, "Encountered an error during configuration update of Kantega SSO Enterprise. Please try again or refer to the logs for more information about what went wrong."));
        }
    }

    public boolean isAnyDataConfigured() {
        return this.kerbConfManager.isAnySettingsConfigured();
    }

    public static String dataWithErrorMessages(io.vavr.collection.List<UpdatePluginSettingsEntryResult> upgradeFailures, KerbConfManager.KEYS configurationKey) {
        return (String)upgradeFailures.find(upgradeConfigEntryResult -> upgradeConfigEntryResult.getOldConfigurationKey() == configurationKey).map(UpdatePluginSettingsEntryResult::getDataWithErrorMessages).getOrNull();
    }

    public boolean isUpdateFromMajorVersion4OrUnknown() {
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().flatMap(Version::getMajor).map(major -> major < 5).getOrElse((Object)true);
    }

    public boolean isBreakingChangesInNewVersion() {
        Option<Version> maybeSavedKssoVersion;
        Option<Version> maybeRunningVersion = KerbConfManager.getRunningKssoVersion();
        boolean runningVersionIsSavedConfigVersion = maybeRunningVersion.exists(arg_0 -> KssoUpdateManagerCleanup.lambda$isBreakingChangesInNewVersion$2(maybeSavedKssoVersion = this.kerbConfManager.getSavedKssoConfigVersion(), arg_0)) || maybeRunningVersion.isEmpty() && maybeSavedKssoVersion.isEmpty();
        return !runningVersionIsSavedConfigVersion && (this.isUpdateFromMajorVersion4OrUnknown() || this.globalConfigUpdate.isBreakingCsrfCheck() || this.globalConfigUpdate.isBreakingDisableTraditionalLogin() || this.globalConfigUpdate.isBreakingBasicAuthIpRestrictions() || this.globalConfigUpdate.isBreakingIpRestrictionsVersion6_20());
    }

    public static boolean isUpdateApiTokenFromBeforeVersion43(Version savedVersion, Version runningVersion) {
        Version lastVersionBeforeBreakingApiToken = new Version("4.3.0");
        return savedVersion.compareTo(lastVersionBeforeBreakingApiToken) <= 0 && runningVersion.compareTo(lastVersionBeforeBreakingApiToken) > 0;
    }

    public static boolean isUpdateApiTokenFromBeforeVersion57(Version savedVersion, Version runningVersion) {
        Version versionWithNewApiTokens = new Version("5.7.0");
        return !KssoUpdateManagerCleanup.isUpdateApiTokenFromBeforeVersion43(savedVersion, runningVersion) && savedVersion.compareTo(versionWithNewApiTokens) < 0;
    }

    public boolean isKssoConfigUpdateNeeded() {
        return this.isBreakingChangesInNewVersion() && this.isAnyDataConfigured() && this.kerbConfManager.hasKerberosFolder();
    }

    public io.vavr.collection.List<UpdatePluginSettingsEntryResult> getUpdateFailures() {
        return this.globalConfigUpdate.getUpdateFailures();
    }

    public boolean hasUpdateFailures() {
        return this.globalConfigUpdate.hasUpdateFailures();
    }

    public void removeUpdateFailureAfterFix(KerbConfManager.KEYS oldConfigurationKey) {
        this.globalConfigUpdate.removeUpdateFailureAfterFix(oldConfigurationKey);
    }

    private boolean saveBackupOfConfig() {
        Option<Version> runningKssoVersion = KerbConfManager.getRunningKssoVersion();
        Option savedKssoVersion = this.kerbConfManager.getSavedKssoConfigVersion().peek(version -> log.info("Migrating the Kantega SSO Enterprise configuration from version " + version.stringValue + " to version " + (String)runningKssoVersion.map(Version::stringValue).getOrElse((Object)"<unknown version>"))).onEmpty(() -> log.info("Migrating the Kantega SSO Enterprise configuration from <unknown version>  to version " + (String)runningKssoVersion.map(Version::stringValue).getOrElse((Object)"<unknown version>")));
        log.info("Preparing for configutation update: Create a backup of Kantega SSO Enterprise configuration...");
        try {
            this.backupService.createBackup("Backup before update of config from version " + (String)savedKssoVersion.map(Version::stringValue).getOrElse((Object)"<unknown version>") + " to " + (String)runningKssoVersion.map(Version::stringValue).getOrElse((Object)"<unknown version>"));
            return true;
        }
        catch (Exception e) {
            log.error("We encountered an error while saving backup of Kantega SSO Enteprise configuration: ", (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ boolean lambda$isBreakingChangesInNewVersion$2(Option maybeSavedKssoVersion, Version version) {
        return maybeSavedKssoVersion.exists(version::equals);
    }

    static class GlobalConfigUpdate {
        private final KerbConfManager kerbConfManager;
        private final CleanupHostApp hostApp;

        public GlobalConfigUpdate(KerbConfManager kerbConfManager, CleanupHostAppFactoryV1 hostAppFactory) {
            this.kerbConfManager = kerbConfManager;
            this.hostApp = hostAppFactory.getInstance();
        }

        io.vavr.collection.List<UpdateMessage> run() {
            return io.vavr.collection.List.of((Object)this.updateCsrfCheck());
        }

        boolean isBreakingDisableTraditionalLogin() {
            Version versionWithRefactoredTraditionalLogin = new Version("6.3.0");
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.compareTo(versionWithRefactoredTraditionalLogin) < 0).getOrElse((Object)true);
        }

        boolean isBreakingCsrfCheck() {
            Version versionWithNewCsrfCheck = new Version("5.5.2");
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.compareTo(versionWithNewCsrfCheck) < 0).getOrElse((Object)true);
        }

        boolean isBreakingBasicAuthIpRestrictions() {
            Version firstVersionWithBasicAuthIpRestriction = Version.of("6.3.0");
            Version versionWithBreakingChangesBasicAuth = new Version("6.15.0");
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.isLowerThan(versionWithBreakingChangesBasicAuth) && version.isHigherThanOrEqualTo(firstVersionWithBasicAuthIpRestriction)).getOrElse((Object)false);
        }

        boolean isBreakingIpRestrictionsVersion6_20() {
            Version versionWithBreakingChangesBasicAuth = new Version("6.20.0");
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.isLowerThan(versionWithBreakingChangesBasicAuth)).getOrElse((Object)false);
        }

        private UpdateMessage updateCsrfCheck() {
            if (this.isBreakingCsrfCheck()) {
                return this.kerbConfManager.setCsrfOriginCheckEnabled(true) ? new UpdateMessage(ResultCode.SUCCESS, "Successfully upgraded CSRF origin header check to new format.") : new UpdateMessage(ResultCode.FAILURE, "Failed to upgrade CSRF origin header check to new format.");
            }
            return new UpdateMessage(ResultCode.SUCCESS, "No need to update CSRF origin header check.");
        }

        boolean hasUpdateFailures() {
            return !this.getUpdateFailures().isEmpty();
        }

        boolean hasSavedIpRestrictions() {
            return GlobalConfigUpdate.ipRestrictionKeys().map(key -> (String)this.kerbConfManager.get((KerbConfManager.KEYS)((Object)key))).exists(StringUtils::isNotBlank);
        }

        private void saveUpdateFailures(io.vavr.collection.List<UpdatePluginSettingsEntryResult> failedResults) {
            io.vavr.collection.List maybeJsonList = failedResults.filter(UpdatePluginSettingsEntryResult::isFailure).map(JsonMapping.Write::objectAsJson);
            if (maybeJsonList.forAll(Try::isSuccess)) {
                JSONArray resultsToSave = new JSONArray((Collection)maybeJsonList.map(Try::get).toJavaList());
                this.kerbConfManager.put(KerbConfManager.KEYS.CONFIG_UPDATE_FAILURES, resultsToSave.toString());
            } else {
                maybeJsonList.find(Try::isFailure).map(Try::getCause).peek(throwable -> log.error("Encountered an error while saving the upgrade results: ", throwable));
            }
        }

        private boolean isSavedConfigVersionPreV5() {
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(v -> v.isLowerThan(Version.of("5.0.0"))).getOrElse((Object)true);
        }

        private void blockEveryPatternInBlockedListDueToFailedUpdate(KerbConfManager.KEYS oldConfigKey, KerbConfManager.KEYS newConfigKey) {
            String blockEveryIpAddressPattern = "^.*$" + System.lineSeparator();
            List<KerbConfManager.KEYS> blockedListConfigKeys = Arrays.asList(KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST);
            if (blockedListConfigKeys.contains((Object)oldConfigKey)) {
                this.kerbConfManager.put(newConfigKey, blockEveryIpAddressPattern);
            }
        }

        io.vavr.collection.List<UpdatePluginSettingsEntryResult> getUpdateFailures() {
            return (io.vavr.collection.List)Option.of((Object)((String)this.kerbConfManager.get(KerbConfManager.KEYS.CONFIG_UPDATE_FAILURES))).filter(StringUtils::isNotBlank).toTry().mapTry((CheckedFunction1 & Serializable)source -> {
                JSONArray jsonArray = new JSONArray(source);
                ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    jsonObjects.add(jsonArray.optJSONObject(i));
                }
                return io.vavr.collection.List.ofAll(jsonObjects).map(Option::of).map(Value::toTry).map(maybeJson -> maybeJson.flatMap(json -> JsonMapping.Read.valueFromJson((JSONObject)json, UpdatePluginSettingsEntryResult.class).onFailure(error -> log.error("JSON error while reading config upgrade result: ", error)))).filter(Try::isSuccess).map(Try::get);
            }).getOrElse((Object)io.vavr.collection.List.empty());
        }

        public void removeUpdateFailureAfterFix(KerbConfManager.KEYS oldConfigurationKey) {
            io.vavr.collection.List resultsReduced = this.getUpdateFailures().removeFirst(failure -> failure.getOldConfigurationKey() == oldConfigurationKey);
            this.saveUpdateFailures((io.vavr.collection.List<UpdatePluginSettingsEntryResult>)resultsReduced);
            if (!this.hasUpdateFailures()) {
                this.kerbConfManager.updateKssoVersionInConfig();
            }
        }

        private static io.vavr.collection.List<KerbConfManager.KEYS> ipRestrictionKeys() {
            return io.vavr.collection.List.of((Object[])new KerbConfManager.KEYS[]{KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST, KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.REST_IP_BLOCKEDLIST, KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST, KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_BLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST});
        }
    }
}

