/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.usercleanup.v2.config;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.jobs.JobManager;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupRuleDTOV2;
import org.kantega.atlaskerb.usercleanup.NotFoundException;
import org.kantega.atlaskerb.usercleanup.v2.config.model.CleanupSchedulesAoService;
import org.kantega.atlaskerb.usercleanup.v2.config.model.ScheduledCleanupRuleAo;
import org.kantega.atlaskerb.usercleanup.v2.config.model.util.ScheduledCleanupRuleMapper;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CleanupSchedulesServiceImpl
implements CleanupSchedulesAoService {
    private final ActiveObjects ao;
    private final TransactionTemplate tx;
    private final KerbConfManager kerbConfManager;
    private final JsonWrapper jsonWrapper;
    private final ScheduledCleanupRuleMapper scheduledCleanupRuleMapper;
    private final Logger log = LoggerFactory.getLogger(CleanupSchedulesServiceImpl.class);
    private JobManager jobManager;

    @Inject
    public CleanupSchedulesServiceImpl(@ComponentImport ActiveObjects ao, @ComponentImport TransactionTemplate transactionTemplate, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper, ScheduledCleanupRuleMapper scheduledCleanupRuleMapper) {
        this.ao = ao;
        this.tx = transactionTemplate;
        this.kerbConfManager = kerbConfManager;
        this.jsonWrapper = jsonWrapper;
        this.scheduledCleanupRuleMapper = scheduledCleanupRuleMapper;
    }

    @Override
    public List<CleanupRuleDTOV2> getScheduledCleanupRules() {
        return (List)this.tx.execute(() -> Arrays.stream((ScheduledCleanupRuleAo[])this.ao.find(ScheduledCleanupRuleAo.class)).map(schedule -> {
            try {
                return this.scheduledCleanupRuleMapper.mapActiveObjectsToCleanupRule((ScheduledCleanupRuleAo)schedule);
            }
            catch (Exception e) {
                this.log.error("Error while fetching cleanup rules: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()));
    }

    @Override
    public CleanupRuleDTOV2 addScheduledCleanupRule(CleanupRuleDTOV2 cleanupRuleDto) {
        return (CleanupRuleDTOV2)this.tx.execute(() -> {
            try {
                ScheduledCleanupRuleAo scheduledCleanupRuleAo = this.scheduledCleanupRuleMapper.mapCleanupRuleToActiveObjects(cleanupRuleDto, (ScheduledCleanupRuleAo)this.ao.create(ScheduledCleanupRuleAo.class, new DBParam[0]));
                scheduledCleanupRuleAo.setJobRunnerKey("no.kantega.usermanagement:" + UUID.randomUUID());
                scheduledCleanupRuleAo.save();
                return this.scheduledCleanupRuleMapper.mapActiveObjectsToCleanupRule(scheduledCleanupRuleAo);
            }
            catch (Exception e) {
                this.log.error("Error while adding cleanup rule: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    @Nullable
    public CleanupRuleDTOV2 editScheduledCleanupRule(String id, CleanupRuleDTOV2 cleanupRuleDto) {
        return (CleanupRuleDTOV2)this.tx.execute(() -> {
            try {
                if (id == null) {
                    throw new RuntimeException("Cleanup rule id is required");
                }
                ScheduledCleanupRuleAo scheduledCleanupRuleAo = (ScheduledCleanupRuleAo)this.ao.get(ScheduledCleanupRuleAo.class, (Object)Integer.parseInt(id));
                if (scheduledCleanupRuleAo == null) {
                    return null;
                }
                scheduledCleanupRuleAo = this.scheduledCleanupRuleMapper.mapCleanupRuleToActiveObjects(cleanupRuleDto, scheduledCleanupRuleAo);
                scheduledCleanupRuleAo.save();
                return this.scheduledCleanupRuleMapper.mapActiveObjectsToCleanupRule(scheduledCleanupRuleAo);
            }
            catch (Exception e) {
                this.log.error("Error while editing cleanup rule: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CleanupRuleDTOV2 getScheduledCleanupRule(String id) {
        return (CleanupRuleDTOV2)this.tx.execute(() -> {
            try {
                ScheduledCleanupRuleAo scheduledCleanupRuleAo = (ScheduledCleanupRuleAo)this.ao.get(ScheduledCleanupRuleAo.class, (Object)Integer.parseInt(id));
                if (scheduledCleanupRuleAo == null) {
                    throw new NotFoundException("Scheduled cleanup rule not found");
                }
                return this.scheduledCleanupRuleMapper.mapActiveObjectsToCleanupRule(scheduledCleanupRuleAo);
            }
            catch (Exception e) {
                this.log.error("Error while fetching cleanup rule: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CleanupRuleDTOV2 findCleanupRuleByJobRunnerkey(String jobRunnerKey) {
        return (CleanupRuleDTOV2)this.tx.execute(() -> {
            ArrayList scheduledCleanupRuleAo = Lists.newArrayList((Object[])((ScheduledCleanupRuleAo[])this.ao.find(ScheduledCleanupRuleAo.class, Query.select().where("JOB_RUNNER_KEY = ?", new Object[]{jobRunnerKey}))));
            if (scheduledCleanupRuleAo.isEmpty()) {
                return null;
            }
            return this.scheduledCleanupRuleMapper.mapActiveObjectsToCleanupRule((ScheduledCleanupRuleAo)scheduledCleanupRuleAo.get(0));
        });
    }

    @Override
    public void deleteScheduledCleanupRule(String id) {
        this.tx.execute(() -> {
            ScheduledCleanupRuleAo scheduledCleanupRuleAo = (ScheduledCleanupRuleAo)this.ao.get(ScheduledCleanupRuleAo.class, (Object)Integer.parseInt(id));
            if (scheduledCleanupRuleAo == null) {
                throw new NotFoundException("Scheduled cleanup rule not found");
            }
            this.ao.delete(new RawEntity[]{scheduledCleanupRuleAo});
            this.log.info("Deleted cleanup rule with id: " + id);
            return null;
        });
    }
}

