/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.v1;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupExecuteStatus;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupExecuteStatusAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupLogAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.kantega.atlaskerb.usercleanup.v1.InactiveUserCleanerV1;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="get-cleanup-status")
@PublicApi
public class GetExecutionStatus {
    private static final Logger log = LoggerFactory.getLogger(GetExecutionStatus.class);
    UserManager userManager;
    CleanupHostApp<UserCleanupResultV1> hostApp;
    JsonWrapper jsonWrapper;
    private InactiveUserCleanerV1 inactiveUserCleaner;

    @Autowired
    public void setHostApp(CleanupHostApp<UserCleanupResultV1> cleanupHostApp) {
        this.hostApp = cleanupHostApp;
    }

    @Autowired
    @Inject
    public void setInactiveUserCleaner(InactiveUserCleanerV1 inactiveUserCleaner) {
        this.inactiveUserCleaner = inactiveUserCleaner;
    }

    @Inject
    public GetExecutionStatus(@ComponentImport UserManager userManager, JsonWrapper jsonWrapper, InactiveUserCleanerV1 inactiveUserCleaner) {
        this.userManager = userManager;
        this.jsonWrapper = jsonWrapper;
        this.inactiveUserCleaner = inactiveUserCleaner;
    }

    private Response run(UserProfile userProfile, UserManager userManager, CleanupExecuteStatusAttributes executeStatusAttributes) {
        if (!userManager.isSystemAdmin(userProfile.getUserKey())) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
        }
        boolean isJsmCleanup = executeStatusAttributes.getJsmCleanup();
        CleanupStatus cleanupExecuteStatus = isJsmCleanup ? this.hostApp.getJsmCleanupExecuteStatus() : this.hostApp.getUserCleanupExecuteStatus();
        CleanupLogAttributes cleanupLogAttributes = new CleanupLogAttributes(5, false, true, true, isJsmCleanup, false);
        UserCleanupResultV1[] userCleanupLog = this.inactiveUserCleaner.getCleanupLog(cleanupLogAttributes);
        CleanupExecuteStatus<UserCleanupResultV1> status = new CleanupExecuteStatus<UserCleanupResultV1>(cleanupExecuteStatus, userCleanupLog, isJsmCleanup ? this.hostApp.getJsmCleanupLastRunId() : this.hostApp.getUserCleanupLastRunId());
        return (Response)this.jsonWrapper.tryBuildJsonString(status).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request, CleanupExecuteStatusAttributes executeStatusAttributes) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, executeStatusAttributes)).onFailure(e -> log.error("Encountered an exception while attempting to GET cleanup execution status. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

