/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.v1;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.DeleteResultAttributes;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="delete-cleanup-result-file")
@PublicApi
public class DeleteCleanupLogFile {
    private static final Logger log = LoggerFactory.getLogger(DeleteCleanupLogFile.class);
    UserManager userManager;
    CleanupHostApp cleanupHostApp;

    @Inject
    public DeleteCleanupLogFile(@ComponentImport UserManager userManager, CleanupHostAppFactoryV1 hostAppFactory) {
        this.userManager = userManager;
        this.cleanupHostApp = hostAppFactory.getInstance();
    }

    private Response run(DeleteResultAttributes attributes) {
        if (attributes.getFilenameId() == null || attributes.getCleanupResultType() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        boolean success = this.cleanupHostApp.getInactiveUserCleaner().clearCleanupLogFile(attributes.getFilenameId(), attributes.getCleanupResultType(), attributes.isJsmCleanup() ? CleanupMode.JSM : CleanupMode.USERS);
        if (success) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to delete cleanup log file").build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response doDelete(@Context HttpServletRequest request, DeleteResultAttributes deleteResultAttributes) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run(deleteResultAttributes)).onFailure(e -> log.error("Encountered an exception while attempting to set new cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

