/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.config.ConfigurationException;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV2;
import org.kantega.atlaskerb.hostapp.JiraCleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.usercleanup.v2.BlockedResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsmCleanupJobRunnerV2
implements JobRunner {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(JsmCleanupJobRunnerV2.class + ".job"));
    private static final Logger log = LoggerFactory.getLogger(JsmCleanupJobRunnerV2.class);
    private final CleanupHostApp<UserCleanupResultV2> hostApp;

    @Inject
    public JsmCleanupJobRunnerV2(CleanupHostAppFactoryV2 hostAppFactory) {
        this.hostApp = hostAppFactory.getInstance();
    }

    public JsmCleanupJobRunnerV2(JiraCleanupHostApp<UserCleanupResultV2> hostApp) {
        this.hostApp = hostApp;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            log.info(String.format("JsmCleanup: Starting scheduled run, previous CleanupStatus is %s", this.hostApp.getJsmCleanupExecuteStatus().toString()));
            UserCleanupResultV2 result = this.hostApp.cleanupInactiveUsersV2(jobRunnerRequest.getJobConfig().getJobRunnerKey().toString(), null, new RunAttributes(false, false, true), DateTime.now(), UUID.randomUUID().toString());
            log.info("JsmCleanup: Scheduled run with run ID {} succeeded", (Object)result.getRunId());
            return JobRunnerResponse.success((String)String.format("JsmCleanup: Scheduled run with run ID %s succeeded", result.getRunId()));
        }
        catch (ConfigurationException e) {
            log.error("JsmCleanup: Scheduled run failed. Could not parse configuration.", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
        catch (BlockedResourceException e) {
            log.warn("JsmCleanup: Scheduled run did not start since a cleanup is already running");
            return JobRunnerResponse.aborted((String)"Cleanup already running. Aborted.");
        }
        catch (InterruptedException e) {
            log.error("JsmCleanup: Scheduled run failed, thread interrupted");
            return JobRunnerResponse.failed((Throwable)e);
        }
    }
}

