/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.JiraCleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupRuleDTOV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserSummaryV2;
import org.kantega.atlaskerb.usercleanup.BreakException;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.kantega.atlaskerb.usercleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class JiraCleanupHostAppV2
extends JiraCleanupHostApp<UserCleanupResultV2> {
    private final Logger log = LoggerFactory.getLogger(JiraCleanupHostAppV2.class);
    private final JiraThreadLocalUtil jiraThreadLocalUtil;

    public JiraCleanupHostAppV2(@ComponentImport TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, @ComponentImport AuthenticationListener authenticationListener, @ComponentImport EventPublisher eventPublisher, @ComponentImport AuthenticationController authenticationController, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport CrowdService crowdService, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper, @ComponentImport JiraThreadLocalUtil jiraThreadLocalUtil) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, kerbConfManager, jsonWrapper);
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
    }

    @Override
    public void preCallForThreadLocal() {
        this.jiraThreadLocalUtil.preCall();
    }

    @Override
    public void postCallForCleanupThreadLocal(org.apache.log4j.Logger log) {
        this.jiraThreadLocalUtil.postCall(log);
    }

    @Override
    public UserCleanupResultV2 jsmCleanupV2(InactiveUserCleaner<UserCleanupResultV2> inactiveUserCleaner, String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV2 cleanupRule, DateTime inactivityCutoffTimestamp, SearchRestriction searchRestriction, String dryRunString, String runId) throws ConfigurationException {
        this.inactiveUserCleaner.controlCleanupConfigurationV2(cleanupRule, runAttributes, false);
        Iterable<User> users = this.inactiveUserCleaner.searchUsersBasedOnRemoveGroup(false, null, searchRestriction, cleanupRule.getMaximumNumberOfUsers());
        List<String> directoryExclusionList = this.inactiveUserCleaner.getDirectoryExclusionListV2(cleanupRule);
        List<Long> cleanableDirectoryIds = this.inactiveUserCleaner.getCleanableDirectoryIdsV2(cleanupRule, directoryExclusionList);
        List<ApplicationUser> userList = this.getApplicationUsersV2(users, cleanupRule);
        ArrayList<UserSummaryV2> affectedUsersList = new ArrayList<UserSummaryV2>();
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        try {
            List<ApplicationUser> inactiveUsers = this.getUsersToJSMClean(currentUserName, cleanupRule.getDaysInactiveThreshold(), userList);
            for (ApplicationUser inactiveUser : inactiveUsers) {
                if (this.getJsmCleanupExecuteStatus() == CleanupStatus.NOT_RUN) {
                    throw new BreakException();
                }
                Directory inactiveUserDir = allDirectories.stream().filter(directory -> directory.getId().longValue() == inactiveUser.getDirectoryId()).findFirst().get();
                if (!this.inactiveUserCleaner.isUserEligibleForJSMCleanup(inactiveUser.getDirectoryId(), cleanableDirectoryIds, this.inactiveUserCleaner.getExcludedDirectoryIds(allDirectories, directoryExclusionList))) continue;
                this.inactiveUserCleaner.optionallyCleanupUserV2(dryRunString, runAttributes, cleanupRule, affectedUsersList, (User)this.getDirectoryManager().findUserByName(inactiveUserDir.getId().longValue(), inactiveUser.getName()), inactiveUserDir, cleanableDirectoryIds.contains(inactiveUser.getDirectoryId()));
            }
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (BreakException e) {
            this.log.warn("Jsm license cleanup: Cleanup process was cancelled mid run. " + affectedUsersList.size() + " users were affected before cancel. You can find complete list of affected users in the jsm cleanup log directory");
        }
        return (UserCleanupResultV2)this.inactiveUserCleaner.createAndSaveUserCleanupResultV2(runAttributes, affectedUsersList, inactivityCutoffTimestamp, runId, cleanupRule, CleanupMode.JSM);
    }

    public List<ApplicationUser> getApplicationUsersV2(Iterable<User> users, CleanupRuleDTOV2 cleanupRule) {
        Set<String> whitelistedUserNames = this.inactiveUserCleaner.getWhitelistedUserNamesV2(cleanupRule);
        ArrayList<ApplicationUser> userList = new ArrayList<ApplicationUser>();
        users.forEach(user -> {
            if (!whitelistedUserNames.contains(user.getName())) {
                userList.add(this.getApplicationUser(user.getName()));
            }
        });
        return userList;
    }
}

