/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.DefaultCleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.UnifiedLicenseInfo;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent
public class BitbucketCleanupHostApp<U extends UserCleanupResultV1>
extends DefaultCleanupHostApp<U> {
    private final Method clearSecurityContextHolderMethod;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object crowdControl;
    public static final String FAILED_AUTHENTICATION_ATTEMPT_COUNT = "failedAuthenticationAttemptCount";
    private final Method crowdControlSetUserAttributeMethod;

    public BitbucketCleanupHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, kerbConfManager, jsonWrapper);
        Object crowdControl = null;
        Method crowdControlSetUserAttributeMethod = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader().getParent();
            Class<?> clazz = loader.loadClass("org.springframework.security.core.context.SecurityContextHolder");
            this.clearSecurityContextHolderMethod = clazz.getMethod("clearContext", new Class[0]);
            Class<?> crowdControlClass = loader.loadClass("com.atlassian.stash.internal.crowd.CrowdControl");
            crowdControl = ComponentLocator.getComponent(crowdControlClass);
            Method[] methods = crowdControlClass.getDeclaredMethods();
            crowdControlSetUserAttributeMethod = crowdControlClass.getMethod("setUserAttribute", User.class, String.class, Object.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Could not load class", e);
        }
        this.crowdControl = crowdControl;
        this.crowdControlSetUserAttributeMethod = crowdControlSetUserAttributeMethod;
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        return user.getValue("lastAuthenticationTimestamp");
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req) {
        return this.isMainLoginPage(req) || HttpUrlUtils.getInternalPath(req).equals("/mvc/login");
    }

    @Override
    public boolean isMainLoginPage(HttpServletRequest request) {
        String internalPath = HttpUrlUtils.getInternalPath(request);
        return internalPath.equals("/login");
    }

    @Override
    public Map<String, String> mapNameToExternalId(List<User> userBatch, Map<String, String> userData) {
        if (userBatch.size() == 0) {
            return userData;
        }
        if (!userBatch.get(0).getClass().equals(InternalUser.class)) {
            userBatch.forEach(user -> userData.put(user.getName(), ((TimestampedUser)user).getExternalId()));
        } else {
            userBatch.forEach(user -> userData.put(user.getName(), ((InternalUser)user).getExternalId()));
        }
        return userData;
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"bitbucket", (CharSequence)product);
    }

    @Override
    public String getLoginPage() {
        return "/login";
    }

    @Override
    public String getLogoutPage() {
        return "/logout";
    }

    @Override
    public boolean isLogoutPage(HttpServletRequest req) {
        return this.getLogoutPage().equalsIgnoreCase(HttpUrlUtils.getInternalPath(req));
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("stash-administrators"))) {
            return "stash-administrators";
        }
        return null;
    }

    @Override
    public UnifiedLicenseInfo getLicenseSize() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Set<String> getUserApplicationRoles(Principal user) {
        HashSet<String> strings = new HashSet<String>();
        strings.add("bitbucket-user");
        return strings;
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return r.equals("/login") && req.getParameter("next") == null && req.getParameter("nextUrl") == null;
    }

    @Override
    public void invalidateSession(HttpServletResponse res, HttpServletRequest req) {
        try {
            this.clearSecurityContextHolderMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke SecurityContextHolder.clearContext", e);
        }
        super.invalidateSession(res, req);
    }

    private void resetCaptchaOnSsoLogin(Principal user) {
        try {
            this.log.debug("Resetting captcha for user {} during SSO login.", (Object)user.getName());
            Object crowdControl = ComponentLocator.getComponent(UserAdminService.class.getClassLoader().loadClass("com.atlassian.stash.internal.crowd.CrowdControl"));
            Method setUserAttribute = crowdControl.getClass().getMethod("setUserAttribute", User.class, String.class, Object.class);
            setUserAttribute.invoke(crowdControl, this.crowdService.getUser(user.getName()), FAILED_AUTHENTICATION_ATTEMPT_COUNT, 0L);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.warn("Problem resetting capthca on SSO login", (Throwable)e);
        }
    }

    Integer getUserId(Principal user) {
        try {
            Field id = user.getClass().getSuperclass().getDeclaredField("id");
            id.setAccessible(true);
            return (Integer)id.get(user);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getLastLoginParameter() {
        return "lastAuthenticationTimestamp";
    }

    @Override
    public File getHomeDirectory() {
        File localHome = new File(this.applicationProperties.getHomeDirectory(), "kerberos");
        if (localHome.exists()) {
            return localHome;
        }
        return new File(this.applicationProperties.getHomeDirectory() + "/shared/", "kerberos");
    }

    @Override
    public boolean isRestApiExcluded(String r) {
        return r.startsWith("/rest/mirroring/") || r.startsWith("/rest/ssh/") || super.isRestApiExcluded(r);
    }
}

