/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DelegatedAuthenticationDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import io.prometheus.client.Summary;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.diagnostics.metrics.KSSOPluginMetrics;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CommonHostApp;
import org.kantega.atlaskerb.hostapp.DefaultRemoteUserUpdater;
import org.kantega.atlaskerb.hostapp.RemoteUserUpdater;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupRuleDTOV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupRuleDTOV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.kantega.atlaskerb.usercleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.usercleanup.v2.BlockedResourceException;
import org.kantega.atlaskerb.utils.CryptoUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DefaultCleanupHostApp<R extends UserCleanupResultV1>
implements CleanupHostApp<R>,
CommonHostApp {
    protected static final Logger log = LoggerFactory.getLogger(DefaultCleanupHostApp.class);
    protected final DelegatedAuthenticationDirectoryInstanceLoader delegatedInstanceLoader;
    protected final DirectoryManager directoryManager;
    protected final RemoteUserUpdater remoteUserUpdater;
    final TransactionTemplate transactionTemplate;
    final KerbConfManager kerbConfManager;
    final ApplicationProperties applicationProperties;
    final AuthenticationController authenticationController;
    final EventPublisher eventPublisher;
    final CrowdDirectoryService crowdDirectoryService;
    final CrowdService crowdService;
    InactiveUserCleaner<R> inactiveUserCleaner;

    @Autowired
    @Inject
    public void setInactiveUserCleaner(InactiveUserCleaner<R> inactiveUserCleaner) {
        this.inactiveUserCleaner = inactiveUserCleaner;
    }

    public DefaultCleanupHostApp(@ComponentImport TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, @ComponentImport AuthenticationListener authenticationListener, @ComponentImport EventPublisher eventPublisher, @ComponentImport AuthenticationController authenticationController, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport CrowdService crowdService, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        this.transactionTemplate = transactionTemplate;
        this.kerbConfManager = kerbConfManager;
        this.applicationProperties = applicationProperties;
        this.authenticationController = authenticationController;
        this.eventPublisher = eventPublisher;
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdService = crowdService;
        this.directoryManager = this.findComponent(DirectoryManager.class);
        this.remoteUserUpdater = new DefaultRemoteUserUpdater(this.findComponent(DbCachingRemoteDirectoryInstanceLoader.class));
        this.delegatedInstanceLoader = this.findComponent(DelegatedAuthenticationDirectoryInstanceLoader.class);
    }

    <T> T findComponent(Class<T> type) {
        Collection component = ComponentLocator.getComponents(type);
        return component.isEmpty() ? null : (T)component.iterator().next();
    }

    @Override
    public InactiveUserCleaner<R> getInactiveUserCleaner() {
        return this.inactiveUserCleaner;
    }

    @Override
    public R cleanupInactiveUsers(String currentUserName, RunAttributes runAttributes, DateTime runTimestamp, String runId) throws ConfigurationException {
        return (R)((UserCleanupResultV1)this.inactiveUserCleaner.cleanUsers(currentUserName, runAttributes, runTimestamp, runId));
    }

    @Override
    public void preCallForThreadLocal() {
    }

    @Override
    public void postCallForCleanupThreadLocal(org.apache.log4j.Logger log) {
    }

    @Override
    public R cleanupInactiveUsersV2(String jobRunnerId, String currentUserName, RunAttributes runAttributes, DateTime runTimestamp, String runId) throws ConfigurationException, InterruptedException, BlockedResourceException {
        return (R)((UserCleanupResultV1)this.inactiveUserCleaner.cleanUsersV2(jobRunnerId, currentUserName, runAttributes, runTimestamp, runId));
    }

    @Override
    public R jsmCleanup(InactiveUserCleaner<UserCleanupResultV1> inactiveUserCleaner, String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV1 cleanupRule, DateTime inactivityCutoffTimestamp, SearchRestriction searchRestriction, String dryRunString, String runId) throws ConfigurationException {
        throw new UnsupportedOperationException("jsmCleanup can only be called within a Jira host");
    }

    @Override
    public R jsmCleanupV2(InactiveUserCleaner<UserCleanupResultV2> inactiveUserCleaner, String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV2 cleanupRule, DateTime inactivityCutoffTimestamp, SearchRestriction searchRestriction, String dryRunString, String runId) throws ConfigurationException {
        throw new UnsupportedOperationException("jsmCleanup can only be called within a Jira host");
    }

    @Override
    public String getLastLoginParameter() {
        return "login.lastLoginMillis";
    }

    @Override
    public UserWithAttributes getUserForCleanup(User user) {
        return this.crowdService.getUserWithAttributes(user.getName());
    }

    @Override
    public CleanupStatus getUserCleanupExecuteStatus() {
        return this.inactiveUserCleaner.getUserCleanupExecuteStatus();
    }

    @Override
    public CleanupStatus getJsmCleanupExecuteStatus() {
        throw new UnsupportedOperationException("jsmCleanup can only be called within a Jira host");
    }

    @Override
    public void setUserCleanupExecuteStatus(CleanupStatus status) {
        this.inactiveUserCleaner.setUserCleanupExecuteStatus(status);
    }

    @Override
    public void setJsmCleanupExecuteStatus(CleanupStatus status) {
        throw new UnsupportedOperationException("jsmCleanup can only be called within a Jira host");
    }

    @Override
    public Map<String, String> mapNameToExternalId(List<User> userBatch, Map<String, String> userData) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getUserCleanupLastRunId() {
        return this.inactiveUserCleaner.getUserCleanupLastRunId();
    }

    @Override
    public String getJsmCleanupLastRunId() {
        return this.inactiveUserCleaner.getJsmCleanupLastRunId();
    }

    @Override
    public void setUserCleanupLastRunId(String lastRunId) {
        this.inactiveUserCleaner.setUserCleanupLastRunId(lastRunId);
    }

    @Override
    public void setJsmCleanupLastRunId(String lastRunId) {
        this.inactiveUserCleaner.setJsmCleanupLastRunId(lastRunId);
    }

    @Override
    public boolean isJSMUser(String username) {
        throw new UnsupportedOperationException("Checking for JSM membership is only enabled in Jira");
    }

    @Override
    public Set<Group> getJSMGroups() {
        throw new UnsupportedOperationException("Retrieving JSM groups is only enabled in Jira");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optionallyUpdateUserFromRemoteDirectory(String username, Directory directory, boolean isNewlyCreatedUser) throws OperationFailedException, UserNotFoundException, InactiveAccountException {
        Summary.Timer timer = KSSOPluginMetrics.optionalUserUpdateLatency.startTimer();
        try {
            boolean doUpdate;
            boolean bl = doUpdate = this.isAlwaysSyncGroups(directory) || this.isSyncGroupsOnFirstCreated(directory) && isNewlyCreatedUser;
            if (doUpdate && (directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.CONNECTOR)) {
                this.remoteUserUpdater.updateUser(username, directory, this);
            }
        }
        catch (Exception e) {
            log.error("Unable to update group memberships during login. LDAP might be overloaded or unavailable.", (Throwable)e);
        }
        finally {
            timer.observeDuration();
        }
    }

    @Override
    public boolean isAlwaysSyncGroups(Directory directory) {
        return "true".equalsIgnoreCase((String)directory.getAttributes().get("crowd.sync.group.membership.after.successful.user.auth.enabled"));
    }

    public boolean isSyncGroupsOnFirstCreated(Directory directory) {
        return "only_when_first_created".equalsIgnoreCase((String)directory.getAttributes().get("crowd.sync.group.membership.after.successful.user.auth.enabled"));
    }

    @Override
    public boolean createDelegatedUser(Directory directory, String username) {
        try {
            DelegatedAuthenticationDirectory remote = (DelegatedAuthenticationDirectory)this.getDelegatedInstanceLoader().getDirectory(directory);
            this.addOrUpdateLdapUser(username, remote);
            return true;
        }
        catch (UserNotFoundException e) {
            log.debug("Delegated user not created for user/lookupname '{}'", (Object)username, (Object)e);
            return false;
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrUpdateLdapUser(String username, DelegatedAuthenticationDirectory remote) throws UserNotFoundException, OperationFailedException {
        Thread ct = Thread.currentThread();
        ClassLoader oldCcl = ct.getContextClassLoader();
        try {
            ct.setContextClassLoader(CrowdService.class.getClassLoader());
            remote.addOrUpdateLdapUser(username);
        }
        catch (UserNotFoundException u) {
            log.debug("User not found in this delegated directory which is expected if users is removed by filter", (Throwable)u);
        }
        finally {
            ct.setContextClassLoader(oldCcl);
        }
    }

    @Override
    public void optionallyUpdateDelegatedUser(Directory directory, com.atlassian.crowd.model.user.User user) {
        try {
            DelegatedAuthenticationDirectory remote = (DelegatedAuthenticationDirectory)this.getDelegatedInstanceLoader().getDirectory(directory);
            boolean updateUser = Boolean.parseBoolean((String)directory.getAttributes().get("crowd.delegated.directory.auto.update.user"));
            boolean importGroups = Boolean.parseBoolean((String)directory.getAttributes().get("crowd.delegated.directory.importGroups"));
            if (updateUser || importGroups) {
                this.addOrUpdateLdapUser(user.getName(), remote);
            }
        }
        catch (UserNotFoundException e) {
            throw new IllegalStateException("User not found", e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter) {
        return ldapPasswordParameter;
    }

    protected io.vavr.control.Option<String> decryptLdapPassword(String encryptedLdapPassword, String encryptorClassName, String componentManagerClassName) {
        try {
            ClassLoader loader = this.getClass().getClassLoader().getParent();
            Class<?> componentManagerClass = loader.loadClass(componentManagerClassName);
            Method getInstanceMethod = componentManagerClass.getMethod("getInstance", new Class[0]);
            Object componentManager = getInstanceMethod.invoke(null, new Object[0]);
            Class[] params = new Class[]{Class.class};
            Method getComponentMethod = componentManagerClass.getDeclaredMethod("getComponent", params);
            params[0] = loader.loadClass(encryptorClassName);
            Object encryptor = getComponentMethod.invoke(componentManager, (Object[])params);
            params[0] = String.class;
            Method decryptMethod = loader.loadClass(encryptorClassName).getDeclaredMethod("decrypt", params);
            Object[] encryptedPasswordParam = new String[]{encryptedLdapPassword};
            String ldapPassword = (String)decryptMethod.invoke(encryptor, encryptedPasswordParam);
            if (CryptoUtils.secretIndicatesEncryptedValue(ldapPassword)) {
                log.warn("Could not decode LDAP/AD password from database. Check that username/password logins against your LDAP User Directory works. If not, you may have to recreate the LDAP User Directory.");
            }
            return io.vavr.control.Option.of((Object)ldapPassword);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Could not load method in LDAP password fetch: ", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Failed to fetch LDAP password: ", (Throwable)e);
        }
        return io.vavr.control.Option.none();
    }

    @Override
    public RemoteDirectory getAuthorativeDirectory(DbCachingRemoteDirectory directoryInstance) {
        return directoryInstance.getAuthoritativeDirectory();
    }

    @Override
    public void optionallyAddCrowdGroups(com.atlassian.crowd.model.user.User user) {
        HashSet<String> addGroups = new HashSet<String>();
        String crowdAutoAddGroups = this.kerbConfManager.getCrowdAutoAddGroups();
        if (crowdAutoAddGroups != null) {
            for (String g : crowdAutoAddGroups.split(",")) {
                if ((g = g.trim()).isEmpty()) continue;
                addGroups.add(g);
            }
        }
        for (String addGroup : addGroups) {
            Group group = this.getCrowdService().getGroup(addGroup);
            if (group == null) continue;
            try {
                this.getCrowdService().addUserToGroup((User)user, group);
            }
            catch (OperationNotPermittedException | com.atlassian.crowd.exception.runtime.OperationFailedException throwable) {}
        }
    }

    @Override
    public boolean setDefaultGroups(Principal principal, Directory directory) {
        String autoAddGroupsDefinedInLdap = (String)directory.getAttributes().get("autoAddGroups");
        if (StringUtils.isNotBlank((CharSequence)autoAddGroupsDefinedInLdap)) {
            HashSet<String> groupItems = new HashSet<String>(Arrays.asList(autoAddGroupsDefinedInLdap.split("\\|")));
            for (String group : groupItems) {
                group = StringUtils.isNotBlank((CharSequence)group.trim()) ? group.trim() : group;
                try {
                    if (this.isUserInGroup(principal.getName(), group)) continue;
                    this.addUserToGroup(principal, group);
                }
                catch (Exception e) {
                    log.warn("Trying to add default ldap groups at login. Could not assign {} to {}. Error: {}", new Object[]{principal.getName(), group, e.getMessage()});
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isServiceDeskLogout(HttpServletRequest req) {
        return false;
    }

    @Override
    public boolean isRestApi(String internalPath) {
        return (Boolean)io.vavr.control.Option.of((Object)internalPath).map(path -> path.startsWith("/rest/")).getOrElse((Object)false);
    }

    @Override
    public boolean urlInAdditionalBuiltInApiRequest(HttpServletRequest req) {
        return false;
    }

    @Override
    public void invalidateSession(HttpServletResponse res, HttpServletRequest req) {
        io.vavr.control.Option.of((Object)req.getSession(false)).peek(HttpSession::invalidate);
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        return false;
    }

    protected void preventCaching(HttpServletResponse res) {
        res.setHeader("Cache-Control", "private, max-age=0, no-cache");
    }

    @Override
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Override
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Override
    public DelegatedAuthenticationDirectoryInstanceLoader getDelegatedInstanceLoader() {
        return this.delegatedInstanceLoader;
    }

    @Override
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Override
    public boolean isPublicAccessEnabled() {
        return false;
    }

    @Override
    public boolean isUserInGroup(String username, String group) {
        if (username == null || group == null) {
            log.debug(String.format("Checked group memberships of username %s and group %s", username, group));
            return false;
        }
        return this.getCrowdService().isUserMemberOfGroup(username, group);
    }

    @Override
    public boolean isUserMemberOfAnyGroup(CrowdService crowdService, String username, String[] groupNames) {
        User user = crowdService.getUser(username);
        if (user == null) {
            throw new IllegalArgumentException("User not found: " + username);
        }
        for (String groupName : groupNames) {
            Group group = crowdService.getGroup(groupName);
            if (group == null || !crowdService.isUserMemberOfGroup(user, group)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Group getGroup(String groupName) {
        return this.getCrowdService().getGroup(groupName);
    }

    @Override
    public boolean removeNonIdpGroupsFromUser(Principal principal, Set<String> groupsFromIdp) {
        boolean failing = false;
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(principal.getName()).startingAt(0).returningAtMost(-1);
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableAndActive(directory) || directory.getType() != DirectoryType.INTERNAL) continue;
            try {
                List userCurrentGroups = this.getDirectoryManager().searchNestedGroupRelationships(directory.getId().longValue(), membershipQuery);
                for (String userGroup : userCurrentGroups) {
                    if (groupsFromIdp.contains(userGroup)) continue;
                    this.removeUserFromGroup(principal, userGroup);
                }
            }
            catch (DirectoryNotFoundException e) {
                log.error("Directory not found during group search", (Throwable)e);
                failing = true;
            }
            catch (OperationFailedException e) {
                log.error("Operation failed during group search", (Throwable)e);
                failing = true;
            }
        }
        return failing;
    }

    @Override
    public boolean addUserToGroup(Principal principal, String groupName) {
        try {
            User user = this.crowdService.getUser(principal.getName());
            Group group = this.crowdService.getGroup(groupName);
            if (user != null && group != null) {
                this.getCrowdService().addUserToGroup(user, group);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error(String.format("Failed to add user '%s' to group '%s'. This is typically because the user and group are both in a read-only directory.", principal.getName(), groupName), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateUser(Directory directory, String username, String fullName, String email, boolean isActive) {
        try {
            UserTemplateWithAttributes template = new UserTemplateWithAttributes(username, directory.getId().longValue());
            template.setDisplayName(fullName);
            template.setEmailAddress(email);
            template.setActive(isActive);
            this.crowdService.updateUser((User)template);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean removeUserFromGroup(Principal principal, String groupName) {
        try {
            User user = this.crowdService.getUser(principal.getName());
            Group group = this.crowdService.getGroup(groupName);
            if (user != null && group != null) {
                return this.getCrowdService().removeUserFromGroup(user, group);
            }
            return false;
        }
        catch (Exception e) {
            log.error(String.format("Failed removing user '%s' to group '%s'", principal.getName(), groupName), (Throwable)e);
            return false;
        }
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return null;
    }

    @Override
    public void publishUserAuthenticatedEvent(Principal user, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        User crowdServiceUser = this.getCrowdService().getUser(user.getName());
        Directory directory = this.getCrowdDirectoryService().findDirectoryById(crowdServiceUser.getDirectoryId());
        Application application = ((ApplicationFactory)ComponentLocator.getComponent(ApplicationFactory.class)).getApplication();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            com.atlassian.crowd.model.user.User userByName = manager.findUserByName(directory.getId().longValue(), user.getName());
            this.eventPublisher.publish((Object)new UserAuthenticatedEvent((Object)this, directory, application, userByName));
        }
        catch (DirectoryNotFoundException e) {
            log.error("Directory not found", (Throwable)e);
        }
        catch (UserNotFoundException e) {
            log.error("User not found", (Throwable)e);
        }
        catch (OperationFailedException e) {
            log.error("Operation failed", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.debug("Unable to perform publishUserAuthenticatedEvent", (Throwable)e);
        }
    }

    @Override
    public boolean canLogin(Principal user, HttpServletRequest request) {
        return this.authenticationController.canLogin(user, request);
    }

    @Override
    public boolean isWritableDirectory(Directory directory) {
        return (directory.getType() == DirectoryType.INTERNAL || directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.CONNECTOR) && directory.getAllowedOperations().contains(OperationType.CREATE_USER) && directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    @Override
    public boolean isWritableAndActive(Directory directory) {
        return directory.isActive() && (directory.getType() == DirectoryType.INTERNAL || directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CROWD) && directory.getAllowedOperations().contains(OperationType.CREATE_USER);
    }

    @Override
    public Set<Directory> getWritableUserDirectories() {
        HashSet<Directory> directories = new HashSet<Directory>();
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableDirectory(directory)) continue;
            directories.add(directory);
        }
        return directories;
    }

    @Override
    public Set<Directory> getWritableAndActiveUserDirectories() {
        HashSet<Directory> directories = new HashSet<Directory>();
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableDirectory(directory) || !directory.isActive()) continue;
            directories.add(directory);
        }
        return directories;
    }

    @Override
    public Collection<Group> getAllGroups() {
        NullRestriction restriction = NullRestrictionImpl.INSTANCE;
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)restriction, 0, -1);
        Iterable source = this.crowdService.search((Query)query);
        ArrayList<Group> target = new ArrayList<Group>();
        source.forEach(target::add);
        return target;
    }

    @Override
    public File getHomeDirectory() {
        return new File(this.applicationProperties.getHomeDirectory(), "kerberos");
    }

    @Override
    public boolean isRestApiExcluded(String r) {
        String basePath = "/rest";
        if (r.startsWith(basePath)) {
            for (String path : this.kerbConfManager.getRestExcludedPaths()) {
                if (!r.startsWith(basePath + path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isProductInReadOnlyMode() {
        return false;
    }

    @Override
    public void verifyLicense() throws LicenseException {
        Option license = this.kerbConfManager.getLicenseManager().getLicense();
        if (!license.isDefined() || !((PluginLicense)license.get()).isValid()) {
            log.warn("User cleanup: License is not valid. Skipping user cleanup");
            throw new LicenseException("License is not valid. Skipping user cleanup");
        }
    }
}

