/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.diagnostics;

import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AuditLogFacade {
    private final Logger log = LoggerFactory.getLogger((String)"com.kantegasso.AuditLog");

    public void loginSuccess(String username, String authtype) {
        Object message = String.format("The user '%s' has PASSED authentication", username);
        message = authtype != null ? String.format((String)message + " using %s.", authtype) : (String)message + ".";
        SanitizedLogStatement.of((String)message).andThenLog(msg -> this.log.info(msg));
    }

    public void loginSuccess(String username, AuthMethod authMethod) {
        Object message = String.format("The user '%s' has PASSED authentication", username);
        message = authMethod != AuthMethod.UNKNOWN ? String.format((String)message + " using %s.", authMethod.getAlias()) : (String)message + ".";
        SanitizedLogStatement.of((String)message).andThenLog(msg -> this.log.info(msg));
    }

    public void loginFailed(String username, String authtype, String reason) {
        Object message = String.format("The user '%s' has FAILED authentication", username);
        Object object = message = authtype != null ? String.format((String)message + " using %s.", authtype) : (String)message + ".";
        if (reason != null) {
            message = (String)message + " Reason: " + reason;
        }
        SanitizedLogStatement.of((String)message).andThenLog(msg -> this.log.info(msg));
    }

    public void loginFailed(String username, AuthMethod authMethod, String reason) {
        Object message = String.format("The user '%s' has FAILED authentication", username);
        Object object = message = authMethod != AuthMethod.UNKNOWN ? String.format((String)message + " using %s.", authMethod.getAlias()) : (String)message + ".";
        if (reason != null) {
            message = (String)message + " Reason: " + reason;
        }
        SanitizedLogStatement.of((String)message).andThenLog(msg -> this.log.info(msg));
    }
}

