/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.usercleanup.v1;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyImpl;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectReader;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import kantega.shaded.com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupAction;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupResultType;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupLogAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupRuleDTOV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserSummary;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupRuleDTOV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserSummaryV2;
import org.kantega.atlaskerb.usercleanup.BreakException;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.kantega.atlaskerb.usercleanup.CleanupUtilsShared;
import org.kantega.atlaskerb.usercleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.utils.CleanupUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.stereotype.Component;

@DependsOn(value={"org.kantega.atlaskerb.hostapp.CleanupHostApp"})
@Component
public class InactiveUserCleanerV1
implements InactiveUserCleaner<UserCleanupResultV1> {
    private static final Logger log = LoggerFactory.getLogger(InactiveUserCleanerV1.class);
    public static final CleanupResultType[] CLEANUP_RESULT_TYPES = new CleanupResultType[]{CleanupResultType.DRY, CleanupResultType.DRY_SIMULATED_DATE, CleanupResultType.LIVE};
    final JsonWrapper jsonWrapper;
    final KerbConfManager kerbConfManager;
    final CrowdService crowdService;
    final CrowdDirectoryService crowdDirectoryService;
    private CleanupHostApp<UserCleanupResultV1> hostApp;
    private final AtomicReference<CleanupState> state;
    private final AtomicReference<String> lastUserCleanupRunId;
    private final AtomicReference<String> lastJsmCleanupRunId;
    private final ExecutorService workers;

    @Override
    public ExecutorService getWorkers() {
        return this.workers;
    }

    @Autowired
    public void setHostApp(CleanupHostApp<UserCleanupResultV1> cleanupHostApp) {
        this.hostApp = cleanupHostApp;
    }

    public InactiveUserCleanerV1(KerbConfManager kerbConfManager, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, JsonWrapper jsonWrapper) {
        this.jsonWrapper = jsonWrapper;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.kerbConfManager = kerbConfManager;
        this.state = new AtomicReference<CleanupState>(new CleanupState(CleanupStatus.NOT_RUN, CleanupStatus.NOT_RUN));
        this.lastUserCleanupRunId = new AtomicReference<String>("");
        this.lastJsmCleanupRunId = new AtomicReference<String>("");
        this.workers = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("User-Cleanup-%d").build());
    }

    @Override
    public CleanupStatus getUserCleanupExecuteStatus() {
        return this.state.get().getStatus(CleanupMode.USERS);
    }

    @Override
    public CleanupStatus getJsmCleanupExecuteStatus() {
        return this.state.get().getStatus(CleanupMode.JSM);
    }

    @Override
    public void setUserCleanupExecuteStatus(CleanupStatus status) {
        if (!this.state.get().isCurrent(status, CleanupMode.USERS)) {
            this.state.compareAndSet(this.state.get(), new CleanupState(this.state.get().jsmStatus, status));
        }
    }

    @Override
    public void setJsmCleanupExecuteStatus(CleanupStatus status) {
        if (!this.state.get().isCurrent(status, CleanupMode.JSM)) {
            this.state.compareAndSet(this.state.get(), new CleanupState(status, this.state.get().userStatus));
        }
    }

    @Override
    public String getUserCleanupLastRunId() {
        return this.lastUserCleanupRunId.get();
    }

    @Override
    public String getJsmCleanupLastRunId() {
        return this.lastJsmCleanupRunId.get();
    }

    @Override
    public void setUserCleanupLastRunId(String status) {
        this.lastUserCleanupRunId.set(status);
    }

    @Override
    public void setJsmCleanupLastRunId(String status) {
        this.lastJsmCleanupRunId.set(status);
    }

    private CleanupRuleDTOV1 getCleanupRule(CleanupMode cleanupMode) throws ConfigurationException, IOException {
        ObjectReader objectReader = this.jsonWrapper.objectReader();
        CleanupRuleDTOV1 cleanupRule = (CleanupRuleDTOV1)objectReader.readValue(this.kerbConfManager.getCleanupRuleJSONString(cleanupMode), CleanupRuleDTOV1.class);
        if (cleanupRule == null) {
            log.warn("User cleanup: Could not find CleanupRule. Skipping user cleanup");
            throw new ConfigurationException("Could not find CleanupRule. Skipping user cleanup");
        }
        return cleanupRule;
    }

    private DateTime getInactivityCutoffTimestamp(CleanupRuleDTOV1 cleanupRule, RunAttributes runAttributes, DateTime runTimestamp) throws ConfigurationException {
        DateTime inactivityCutoffTimestamp;
        int daysInactiveThreshold = cleanupRule.getDaysInactiveThreshold();
        if (daysInactiveThreshold == 0) {
            log.warn("User cleanup: Missing daysInactiveThreshold or daysInactiveThreshold equals 0");
            throw new ConfigurationException("Missing daysInactiveThreshold");
        }
        if (runAttributes != null && runAttributes.isDryRun() && runAttributes.isSimulateCronDate()) {
            if (cleanupRule.getCronAttributes() != null && cleanupRule.getCronAttributes().getCronSpringSchedule() != null) {
                CronSequenceGenerator generator = new CronSequenceGenerator(cleanupRule.getCronAttributes().getCronSpringSchedule());
                Date nextExecutionDate = generator.next(new Date());
                inactivityCutoffTimestamp = new DateTime((Object)nextExecutionDate);
            } else {
                inactivityCutoffTimestamp = runTimestamp;
            }
        } else {
            inactivityCutoffTimestamp = runTimestamp;
        }
        return inactivityCutoffTimestamp;
    }

    private SearchRestriction getSearchRestriction(boolean isJsmCleanup, DateTime expiryDate) {
        PropertyRestriction activePartialSearchRestriction = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)Boolean.TRUE);
        PropertyRestriction createdDateOlderThanThresholdRestriction = Restriction.on((Property)UserTermKeys.CREATED_DATE).lessThan((Object)expiryDate.toDate());
        BooleanRestrictionImpl lastLoginRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{Restriction.on((Property)new PropertyImpl(this.hostApp.getLastLoginParameter(), String.class)).isNull(), Restriction.on((Property)new PropertyImpl(this.hostApp.getLastLoginParameter(), String.class)).lessThan((Object)String.format("%013d", expiryDate.getMillis()))});
        if (isJsmCleanup) {
            return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{activePartialSearchRestriction, createdDateOlderThanThresholdRestriction});
        }
        return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{activePartialSearchRestriction, createdDateOlderThanThresholdRestriction, lastLoginRestriction});
    }

    @Override
    public void controlCleanupConfiguration(CleanupRuleDTOV1 cleanupRule, RunAttributes runAttributes, boolean isRemoveFromGroupAction) throws ConfigurationException {
        User user;
        String groupToRemoveConfig = cleanupRule.getGroupToRemove();
        if (isRemoveFromGroupAction && (groupToRemoveConfig == null || groupToRemoveConfig.length() == 0)) {
            log.warn("User cleanup: CleanupRule was not configured. Missing groupToRemove value. Skipping user cleanup");
            throw new ConfigurationException("CleanupRule was not configured. Missing groupToRemove value.");
        }
        if (!(cleanupRule.getChangedByUsername() == null || (user = this.crowdService.getUser(cleanupRule.getChangedByUsername())) != null && user.isActive())) {
            log.error("User cleanup rule owner user profile is no longer active or has been deleted. Skipping user cleanup");
            throw new ConfigurationException("User cleanup rule owner user profile is no longer active or has been deleted. Skipping user cleanup");
        }
        log.info("{}User cleanup: Starting user cleanup. {} users not logged in for past {} days", new Object[]{runAttributes != null && runAttributes.isDryRun() ? "Test run: " : "Real run: ", isRemoveFromGroupAction ? "Removing " + groupToRemoveConfig + " from" : "Deactivating", cleanupRule.getDaysInactiveThreshold()});
    }

    @Override
    public void controlCleanupConfigurationV2(CleanupRuleDTOV2 cleanupRule, RunAttributes runAttributes, boolean b) throws ConfigurationException {
    }

    private boolean getIsRemoveFromGroupAction(RunAttributes runAttributes, CleanupRuleDTOV1 cleanupRule) {
        return (runAttributes == null || !runAttributes.isJsmCleanup()) && cleanupRule.getCleanupAction() == CleanupAction.REMOVE_FROM_GROUP;
    }

    @Override
    public Iterable<User> searchUsersBasedOnEligibleGroupNames(boolean isRemoveFromGroupAction, String[] cleanupEligibleGroupNames, SearchRestriction searchRestriction, int userBatchSize) {
        throw new UnsupportedOperationException("Not implemented for v1");
    }

    @Override
    public Iterable<User> searchUsersBasedOnRemoveGroup(boolean isRemoveFromGroupAction, Group groupToRemoveGroup, SearchRestriction searchRestriction, int userBatchSize) {
        return this.crowdService.search((Query)(isRemoveFromGroupAction && groupToRemoveGroup != null ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).childrenOf(EntityDescriptor.group()).withName(groupToRemoveGroup.getName()).returningAtMost(-1) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).returningAtMost(-1)));
    }

    @Override
    public List<String> getDirectoryExclusionList(CleanupRuleDTOV1 cleanupRule) {
        return cleanupRule.getDirectoriesWhitelist() != null ? Arrays.stream(cleanupRule.getDirectoriesWhitelist()).filter(StringUtils::isNotBlank).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public List<String> getDirectoryExclusionListV2(CleanupRuleDTOV2 cleanupRule) {
        return Collections.emptyList();
    }

    @Override
    public List<Long> getCleanableDirectoryIds(CleanupRuleDTOV1 cleanupRule, List<String> directoryExclusionList) {
        Set<Directory> writableUserDirectories = this.hostApp.getWritableUserDirectories();
        Set<Directory> cleanableDirectories = cleanupRule.getDirectoriesWhitelist() == null ? writableUserDirectories : writableUserDirectories.stream().filter(directory -> directoryExclusionList.stream().noneMatch(directoryName -> directoryName.equals(directory.getName()))).collect(Collectors.toSet());
        return cleanableDirectories.stream().map(Directory::getId).collect(Collectors.toList());
    }

    @Override
    public List<Long> getCleanableDirectoryIdsV2(CleanupRuleDTOV2 cleanupRule, List<String> directoryExclusionList) {
        return Collections.emptyList();
    }

    @Override
    public Set<String> getWhitelistedUserNames(CleanupRuleDTOV1 cleanupRule) {
        String[] groupsWhitelistConfig = cleanupRule.getGroupsWhitelist();
        List groupWhitelist = groupsWhitelistConfig == null ? Collections.emptyList() : Arrays.stream(groupsWhitelistConfig).filter(StringUtils::isNotBlank).map(this.hostApp::getGroup).collect(Collectors.toList());
        Iterable usernamesInWhitelistedGroups = this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames((String[])groupWhitelist.stream().filter(Objects::nonNull).map(Group::getName).toArray(String[]::new)).returningAtMost(-1));
        return StreamSupport.stream(usernamesInWhitelistedGroups.spliterator(), false).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getWhitelistedUserNamesV2(CleanupRuleDTOV2 cleanupRule) {
        return Collections.emptySet();
    }

    @Override
    public Set<Long> getExcludedDirectoryIds(List<Directory> allDirectories, List<String> directoryExclusionList) {
        return allDirectories.stream().filter(directory -> directoryExclusionList.contains(directory.getName())).map(Directory::getId).collect(Collectors.toSet());
    }

    private boolean isUserEligibleForCleanup(String currentUserName, User user, CleanupRuleDTOV1 cleanupRule, boolean isNotSimulatedDateOrNotDryRun, boolean isRemoveFromGroupAction, List<Long> cleanableDirectoryIds, Set<Long> excludedDirectoryIds, Set<String> whitelistedUserNames) {
        boolean isCurrentLoggedInUser = currentUserName != null && isNotSimulatedDateOrNotDryRun && currentUserName.equals(user.getName());
        boolean isCurrentCleanupRuleOwner = cleanupRule.getChangedByUsername() != null && cleanupRule.getChangedByUsername().equals(user.getName());
        boolean isUserWhitelisted = whitelistedUserNames.contains(user.getName());
        if (isCurrentCleanupRuleOwner || isCurrentLoggedInUser || !user.isActive() || isUserWhitelisted) {
            return false;
        }
        return isRemoveFromGroupAction && !excludedDirectoryIds.contains(user.getDirectoryId()) || cleanableDirectoryIds.contains(user.getDirectoryId());
    }

    @Override
    public boolean isUserEligibleForJSMCleanup(long userId, List<Long> cleanableDirectoryIds, Set<Long> excludedDirectoryIds) {
        return !excludedDirectoryIds.contains(userId) || cleanableDirectoryIds.contains(userId);
    }

    private Directory getUserDirectory(List<Directory> allDirectories, User user) {
        return allDirectories.stream().filter(directory -> directory.getId().longValue() == user.getDirectoryId()).findFirst().get();
    }

    private ImmutablePair<DateTime, Boolean> getLoginOrCreationDateForUser(User user) {
        UserWithAttributes userWithAttributes = this.hostApp.getUserForCleanup(user);
        String lastLoginMillis = this.hostApp.getLastLoginMillisFromUserWithAttributes(userWithAttributes);
        if (NumberUtils.isCreatable((String)lastLoginMillis)) {
            return new ImmutablePair((Object)new DateTime(Long.parseLong(lastLoginMillis)), (Object)true);
        }
        if (lastLoginMillis == null) {
            return new ImmutablePair((Object)new DateTime((Object)((TimestampedUser)user).getCreatedDate()), (Object)false);
        }
        return null;
    }

    private void maybeCleanupUser(boolean hasLoggedIn, String dryRunString, User user, DateTime lastLoginOrCreationDate, DateTime expiryDate, CleanupRuleDTOV1 cleanupRule, RunAttributes runAttributes, Directory userDirectory, List<Long> cleanableDirectoryIds, ArrayList<UserSummary> affectedUsersList) {
        if (hasLoggedIn) {
            log.debug("{}Checking if user {} should be cleaned. Lastlogin: {}", new Object[]{dryRunString, user.getName(), lastLoginOrCreationDate});
        } else {
            log.debug("{}Checking if user {} should be cleaned. created: {}", new Object[]{dryRunString, user.getName(), lastLoginOrCreationDate});
        }
        if (!this.shouldCleanupUser(lastLoginOrCreationDate, expiryDate)) {
            return;
        }
        if (hasLoggedIn) {
            log.info("{}User cleanup: Cleaning user {}. Not logged in for more than {} days", new Object[]{dryRunString, user.getName(), cleanupRule.getDaysInactiveThreshold()});
        } else {
            log.info("{}User cleanup: Cleaning user {}. Created more than {} days ago but never logged in.", new Object[]{dryRunString, user.getName(), cleanupRule.getDaysInactiveThreshold()});
        }
        this.optionallyCleanupUser(dryRunString, runAttributes, cleanupRule, affectedUsersList, user, userDirectory, cleanableDirectoryIds.contains(user.getDirectoryId()));
    }

    @Override
    public UserCleanupResultV1 doUserCleanup(String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV1 cleanupRule, SearchRestriction searchRestriction, DateTime inactivityCutoffTimestamp, DateTime expiryDate, String dryRunString, String runId) throws ConfigurationException {
        boolean isRemoveFromGroupAction = this.getIsRemoveFromGroupAction(runAttributes, cleanupRule);
        this.controlCleanupConfiguration(cleanupRule, runAttributes, isRemoveFromGroupAction);
        Group groupToRemoveGroup = isRemoveFromGroupAction ? this.hostApp.getGroup(cleanupRule.getGroupToRemove()) : null;
        Iterable<User> users = this.searchUsersBasedOnRemoveGroup(isRemoveFromGroupAction, groupToRemoveGroup, searchRestriction, -1);
        List<String> directoryExclusionList = this.getDirectoryExclusionList(cleanupRule);
        List<Long> cleanableDirectoryIds = this.getCleanableDirectoryIds(cleanupRule, directoryExclusionList);
        Set<String> whitelistedUserNames = this.getWhitelistedUserNames(cleanupRule);
        int countAnalysedUsers = 0;
        log.debug("{} Starting to analyze how many users need to be cleaned.", (Object)dryRunString);
        boolean isNotSimulatedDateOrNotDryRun = runAttributes == null || !runAttributes.isSimulateCronDate();
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        Set<Long> excludedDirectoryIds = this.getExcludedDirectoryIds(allDirectories, directoryExclusionList);
        Iterator<User> usersIterator = users.iterator();
        ArrayList<UserSummary> affectedUsersList = new ArrayList<UserSummary>();
        try {
            while (usersIterator.hasNext()) {
                User user = usersIterator.next();
                if (this.hostApp.getUserCleanupExecuteStatus() == CleanupStatus.NOT_RUN) {
                    throw new BreakException();
                }
                if (this.isUserEligibleForCleanup(currentUserName, user, cleanupRule, isNotSimulatedDateOrNotDryRun, isRemoveFromGroupAction, cleanableDirectoryIds, excludedDirectoryIds, whitelistedUserNames)) {
                    Directory userDirectory = this.getUserDirectory(allDirectories, user);
                    ImmutablePair<DateTime, Boolean> loginOrCreationDate = this.getLoginOrCreationDateForUser(user);
                    if (loginOrCreationDate != null) {
                        this.maybeCleanupUser((Boolean)loginOrCreationDate.getRight(), dryRunString, user, (DateTime)loginOrCreationDate.getLeft(), expiryDate, cleanupRule, runAttributes, userDirectory, cleanableDirectoryIds, affectedUsersList);
                    }
                }
                ++countAnalysedUsers;
            }
            log.debug("{}Analysed {} users. ", (Object)dryRunString, (Object)countAnalysedUsers);
        }
        catch (BreakException e) {
            log.warn("User cleanup: Cleanup process was cancelled mid run. " + affectedUsersList.size() + " users were affected before cancel. You can find complete list of affected users in the user cleanup log directory");
        }
        return this.createAndSaveUserCleanupResult(runAttributes, (ArrayList)affectedUsersList, inactivityCutoffTimestamp, runId, cleanupRule, CleanupMode.USERS);
    }

    @Override
    public UserCleanupResultV1 doUserCleanupV2(String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV2 cleanupRule, SearchRestriction searchRestriction, DateTime inactivityCutoffTimestamp, DateTime expiryDate, String dryRunString, String runId) throws ConfigurationException {
        return null;
    }

    @Override
    public UserCleanupResultV1 doJsmLicenseCleanup(String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV1 cleanupRule, DateTime inactivityCutoffTimestamp, SearchRestriction searchRestriction, String dryRunString, String runId) throws ConfigurationException, UnsupportedOperationException {
        return this.hostApp.jsmCleanup(this, currentUserName, runAttributes, cleanupRule, inactivityCutoffTimestamp, searchRestriction, dryRunString, runId);
    }

    @Override
    public UserCleanupResultV1 doJsmLicenseCleanupV2(String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV2 cleanupRule, DateTime inactivityCutoffTimestamp, SearchRestriction searchRestriction, String dryRunString, String runId) throws ConfigurationException {
        return null;
    }

    @Override
    public UserCleanupResultV1 cleanUsers(String currentUserName, RunAttributes runAttributes, DateTime runTimestamp, String runId) throws ConfigurationException {
        try {
            String dryRunString = runAttributes != null && runAttributes.isDryRun() ? "Test run: " : "Real run: ";
            CleanupRuleDTOV1 cleanupRule = this.getCleanupRule(CleanupUtilsShared.getCleanupMode(runAttributes));
            DateTime inactivityCutoffTimestamp = this.getInactivityCutoffTimestamp(cleanupRule, runAttributes, runTimestamp);
            DateTime expiryDate = inactivityCutoffTimestamp.withTimeAtStartOfDay().minusDays(cleanupRule.getDaysInactiveThreshold());
            if (this.isJsmCleanup(runAttributes)) {
                return this.doJsmLicenseCleanup(currentUserName, runAttributes, cleanupRule, inactivityCutoffTimestamp, this.getSearchRestriction(true, expiryDate), dryRunString, runId);
            }
            return this.doUserCleanup(currentUserName, runAttributes, cleanupRule, this.getSearchRestriction(false, expiryDate), inactivityCutoffTimestamp, expiryDate, dryRunString, runId);
        }
        catch (IOException e) {
            log.error("User cleanup: Failed to parse userCleanupRule json from config", (Throwable)e);
            throw new ConfigurationException("CleanupRule was not configured properly.", (Throwable)e);
        }
    }

    @Override
    public UserCleanupResultV1 cleanUsersV2(String jobRunnerKey, String currentUserName, RunAttributes runAttributes, DateTime runTimestamp, String runId) throws ConfigurationException {
        return null;
    }

    private boolean isJsmCleanup(RunAttributes runAttributes) {
        if (runAttributes == null) {
            return false;
        }
        if (!runAttributes.isJsmCleanup()) {
            return false;
        }
        return this.hostApp.isProductMatch("jira");
    }

    @Override
    public void optionallyCleanupUser(String dryRunString, RunAttributes runAttributes, CleanupRuleDTOV1 cleanupRule, ArrayList<UserSummary> affectedUsersList, User user, Directory userDirectory, boolean userInCleanableDirectory) {
        boolean success = false;
        if (runAttributes == null || !runAttributes.isDryRun()) {
            if (this.isJsmCleanup(runAttributes)) {
                success = true;
                for (Group jsmGroup : this.hostApp.getJSMGroups()) {
                    if (!this.hostApp.isUserInGroup(user.getName(), jsmGroup.getName())) continue;
                    success = success && this.hostApp.removeUserFromGroup((Principal)user, jsmGroup.getName());
                }
            } else if (cleanupRule.getCleanupAction() == CleanupAction.REMOVE_FROM_GROUP) {
                success = this.hostApp.removeUserFromGroup((Principal)user, cleanupRule.getGroupToRemove());
            } else if (userInCleanableDirectory) {
                success = this.deactivateUser(userDirectory, user);
            } else {
                log.warn("User {} to be deactivated is in read-only directory.", (Object)user.getName());
            }
        } else {
            success = true;
        }
        if (success) {
            log.debug("{}Adding user {} to affected users", (Object)dryRunString, (Object)user.getName());
            String lastLoginMillis = this.hostApp.getLastLoginMillisFromUserWithAttributes(this.hostApp.getUserForCleanup(user));
            DateTime lastLogin = lastLoginMillis == null ? new DateTime((Object)((TimestampedUser)user).getCreatedDate()) : new DateTime(Long.parseLong(lastLoginMillis));
            affectedUsersList.add(new UserSummary(user.getName(), user.getEmailAddress(), lastLogin.toString(), false, false, false));
        } else {
            log.debug("{}Not adding user {} to affected users", (Object)dryRunString, (Object)user.getName());
        }
    }

    @Override
    public boolean optionallyCleanupUserV2(String dryRunString, RunAttributes runAttributes, CleanupRuleDTOV2 cleanupRule, List<UserSummaryV2> affectedUsersList, User user, Directory userDirectory, boolean userInCleanableDirectory) {
        throw new UnsupportedOperationException("Not implemented for v1");
    }

    @Override
    public UserCleanupResultV1 createAndSaveUserCleanupResult(RunAttributes runAttributes, ArrayList<UserSummary> affectedUsersList, DateTime now, String runId, CleanupRuleDTOV1 cleanupRule, CleanupMode cleanupMode) {
        String name = runAttributes != null && runAttributes.isDryRun() ? "dry-run" : "cleaned-users";
        DateTimeFormatter filenameDtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH-mm-ss'Z'");
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        String filenameId = now.toString(filenameDtf) + "_" + name;
        UserCleanupResultV1 result = new UserCleanupResultV1(filenameId, runId, now.toString(dtf), runAttributes != null && runAttributes.isDryRun(), runAttributes != null && runAttributes.isSimulateCronDate(), affectedUsersList.toArray(new UserSummary[0]), cleanupRule.getCleanupAction(), cleanupRule.getGroupToRemove(), cleanupRule.getDaysInactiveThreshold());
        CleanupResultType logtype = runAttributes != null && runAttributes.isDryRun() ? (runAttributes.isSimulateCronDate() ? CleanupResultType.DRY_SIMULATED_DATE : CleanupResultType.DRY) : CleanupResultType.LIVE;
        try {
            this.saveCleanupLogFile(filenameId, logtype, this.createJsonObjectFromCleanupResult(result), cleanupMode);
        }
        catch (Exception e) {
            List<String> usernamesList = Arrays.stream(result.getAffectedUsers()).map(userSummary -> userSummary.getUsername() + ": " + userSummary.getEmail()).collect(Collectors.toList());
            log.warn("User cleanup: Failed to save UserCleanupResults log to file.", (Throwable)e);
            log.warn("User cleanup: The following users where affected by the cleanup operation:");
            usernamesList.forEach(arg_0 -> ((Logger)log).warn(arg_0));
        }
        return result;
    }

    @Override
    public UserCleanupResultV1 createAndSaveUserCleanupResultV2(RunAttributes runAttributes, List<UserSummaryV2> affectedUsersList, DateTime inactivityCutoffTimestamp, String runId, CleanupRuleDTOV2 cleanupRule, CleanupMode cleanupMode) {
        throw new UnsupportedOperationException("Not implemented for v1");
    }

    public UserCleanupResultV1[] getCleanupLog(CleanupLogAttributes cleanupLogAttributes) {
        CleanupMode cleanupMode;
        CleanupMode cleanupMode2 = cleanupMode = cleanupLogAttributes.getJsmCleanup() ? CleanupMode.JSM : CleanupMode.USERS;
        CleanupResultType[] cleanupResultTypes = cleanupLogAttributes.getIncludeAllLogs() ? new CleanupResultType[]{CleanupResultType.DRY, CleanupResultType.DRY_SIMULATED_DATE, CleanupResultType.LIVE} : (cleanupLogAttributes.isDryRun() ? (cleanupLogAttributes.isSimulateCronDate() ? new CleanupResultType[]{CleanupResultType.DRY_SIMULATED_DATE} : new CleanupResultType[]{CleanupResultType.DRY}) : new CleanupResultType[]{CleanupResultType.LIVE});
        return this.getUserCleanupResultsFromFiles(cleanupResultTypes, cleanupMode);
    }

    public UserCleanupResultV1[] getUserCleanupResultsFromFiles(CleanupResultType[] cleanupResultTypes, CleanupMode cleanupMode) {
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
        ArrayList result = new ArrayList();
        ObjectReader jsonReader = this.jsonWrapper.objectReader();
        List<CleanupResultType> list = Arrays.asList(cleanupResultTypes);
        list.forEach(logType -> {
            File directory = this.getDirectoryFromResultType(baseDirectory, (CleanupResultType)((Object)logType));
            File[] filesInDir = directory.listFiles();
            List<File> files = Arrays.asList(filesInDir == null ? new File[]{} : filesInDir);
            files.forEach(file -> {
                try (FileInputStream is = new FileInputStream((File)file);){
                    String jsonText = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    if (jsonText != null && jsonText.length() > 0) {
                        UserCleanupResultV1 userCleanupResult = null;
                        try {
                            userCleanupResult = (UserCleanupResultV1)jsonReader.readValue(jsonText, UserCleanupResultV1.class);
                            result.add(userCleanupResult);
                        }
                        catch (UnrecognizedPropertyException e) {
                            UserCleanupResultV1 userCleanupResultV1 = (UserCleanupResultV1)jsonReader.readValue(jsonText, UserCleanupResultV1.class);
                            userCleanupResult = new UserCleanupResultV1(userCleanupResultV1.getFilenameId(), userCleanupResultV1.getRunId(), userCleanupResultV1.getDateTimeUTC(), userCleanupResultV1.getDryRun(), userCleanupResultV1.getSimulateCronDate(), userCleanupResultV1.getAffectedUsers(), userCleanupResultV1.getCleanupAction(), userCleanupResultV1.getGroupToRemove(), userCleanupResultV1.getDaysInactiveThreshold());
                            result.add(userCleanupResult);
                        }
                    }
                }
                catch (IOException e) {
                    log.warn("User cleanup: Failed to get cleanup result from file: " + file.getName(), (Throwable)e);
                }
            });
        });
        UserCleanupResultV1[] array = result.stream().sorted(Comparator.comparing(UserCleanupResultV1::getFilenameId)).collect(Collectors.toList()).toArray(result.toArray(new UserCleanupResultV1[0]));
        return array;
    }

    @Override
    public File getDirectoryFromResultType(File parentDir, CleanupResultType logType) {
        File directory;
        switch (logType) {
            case DRY: {
                directory = new File(parentDir, "dryRuns");
                break;
            }
            case DRY_SIMULATED_DATE: {
                directory = new File(parentDir, "dryRunsWithSimulatedDate");
                break;
            }
            default: {
                directory = new File(parentDir, "liveCleanupLogs");
            }
        }
        return directory;
    }

    @Override
    public void saveCleanupLogFile(String filenameId, CleanupResultType cleanupResultType, JSONObject jsonData, CleanupMode cleanupMode) throws IOException {
        int maxNofFiles;
        File directory;
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
        boolean isDry = true;
        switch (cleanupResultType) {
            case DRY: {
                directory = new File(baseDirectory, "dryRuns");
                break;
            }
            case DRY_SIMULATED_DATE: {
                directory = new File(baseDirectory, "dryRunsWithSimulatedDate");
                break;
            }
            default: {
                isDry = false;
                directory = new File(baseDirectory, "liveCleanupLogs");
            }
        }
        File[] filesInDir = directory.listFiles();
        int n = maxNofFiles = isDry ? 1 : 5;
        if (filesInDir != null && filesInDir.length >= maxNofFiles) {
            List sortedFiles = Arrays.stream(filesInDir).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
            while (sortedFiles.size() > maxNofFiles - 1) {
                this.clearCleanupLogFile(((File)sortedFiles.get(1)).getName(), cleanupResultType, cleanupMode);
                sortedFiles.remove(1);
            }
        }
        File file = new File(directory, filenameId);
        FileUtils.writeStringToFile((File)file, (String)jsonData.toString(), (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public boolean clearCleanupLogFile(String filenameId, CleanupResultType cleanupResultType, CleanupMode cleanupMode) {
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
        File directory = this.getDirectoryFromResultType(baseDirectory, cleanupResultType);
        File fileToDelete = new File(directory, filenameId);
        boolean success = false;
        for (int i = 0; i < 3; ++i) {
            if (fileToDelete.delete()) {
                success = true;
                break;
            }
            try {
                FileUtils.writeStringToFile((File)fileToDelete, (String)"", (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                String msg = "User cleanup: Delete of logfile failed, tried to clear file contents instead. Also failed to clear file contents: " + filenameId;
                log.error(msg, (Throwable)e);
                continue;
            }
            success = true;
        }
        if (!success) {
            String msg = "User cleanup: Failed to delete file: " + filenameId;
            IOException e = new IOException(msg);
            log.error(msg, (Throwable)e);
        }
        return success;
    }

    private JSONObject createJsonObjectFromCleanupResult(UserCleanupResultV1 result) {
        ObjectWriter objectWriter = this.jsonWrapper.objectWriter();
        try {
            String jsonStr = objectWriter.writeValueAsString((Object)result);
            return new JSONObject(jsonStr);
        }
        catch (JsonProcessingException e) {
            return new JSONObject();
        }
    }

    private boolean shouldCleanupUser(DateTime lastUsed, DateTime expiryDate) {
        return lastUsed.isBefore((ReadableInstant)expiryDate);
    }

    @Override
    public boolean deactivateUser(Directory directory, User user) {
        try {
            this.hostApp.updateUser(directory, user.getName(), user.getDisplayName(), user.getEmailAddress(), false);
            return true;
        }
        catch (Exception e) {
            log.error("User cleanup: Failed to deactivate user " + user.getName(), (Throwable)e);
            return false;
        }
    }

    private static class CleanupState {
        private final CleanupStatus jsmStatus;
        private final CleanupStatus userStatus;

        CleanupState(CleanupStatus jsmStatus, CleanupStatus userStatus) {
            this.jsmStatus = jsmStatus;
            this.userStatus = userStatus;
        }

        CleanupStatus getStatus(CleanupMode cleanupMode) {
            if (cleanupMode == CleanupMode.USERS) {
                return this.userStatus;
            }
            return this.jsmStatus;
        }

        boolean isCurrent(CleanupStatus status, CleanupMode cleanupMode) {
            CleanupStatus currentStatus = cleanupMode == CleanupMode.USERS ? this.userStatus : this.jsmStatus;
            if (status == null) {
                return currentStatus == null;
            }
            return status.equals((Object)currentStatus);
        }
    }
}

