/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.update.data;

import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.control.Option;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.update.ResultCode;
import org.kantega.atlaskerb.update.data.UpdateResult;
import org.kantega.atlaskerb.utils.Version;

@JsonMapping.KssoJsonMapper
public final class UpdatePluginSettingsEntryResult
implements UpdateResult {
    @JsonMapping.KssoJsonProperty
    private final String previousVersion;
    @JsonMapping.KssoJsonProperty(value="resultCode")
    private final ResultCode resultCode;
    @JsonMapping.KssoJsonProperty(value="message")
    private final String message;
    @JsonMapping.KssoJsonProperty(value="oldConfigurationKey")
    private final KerbConfManager.KEYS oldConfigurationKey;
    @JsonMapping.KssoJsonProperty(value="configPageUrl")
    private final String configPageUrl;
    @JsonMapping.KssoJsonProperty(value="configPageName")
    private final String configPageName;
    @JsonMapping.KssoJsonProperty(value="dataWithErrorMessages")
    private final String dataWithErrorMessages;

    public UpdatePluginSettingsEntryResult(Version previousVersion, ResultCode resultCode, String message, KerbConfManager.KEYS configurationKey, String configPageUrl, String configPageName) {
        this.previousVersion = (String)Option.of((Object)previousVersion).map(Version::stringValue).getOrNull();
        this.resultCode = resultCode;
        this.message = message;
        this.oldConfigurationKey = configurationKey;
        this.configPageUrl = configPageUrl;
        this.configPageName = configPageName;
        this.dataWithErrorMessages = null;
    }

    private UpdatePluginSettingsEntryResult() {
        this.previousVersion = null;
        this.resultCode = null;
        this.message = null;
        this.oldConfigurationKey = null;
        this.configPageUrl = null;
        this.configPageName = null;
        this.dataWithErrorMessages = null;
    }

    public UpdatePluginSettingsEntryResult(@JsonMapping.KssoJsonProperty(value="previousVersion") String previousVersion, @JsonMapping.KssoJsonProperty(value="resultCode") ResultCode resultCode, @JsonMapping.KssoJsonProperty(value="message") String message, @JsonMapping.KssoJsonProperty(value="oldConfigurationKey") KerbConfManager.KEYS oldConfigurationKey, @JsonMapping.KssoJsonProperty(value="configPageUrl") String configPageUrl, @JsonMapping.KssoJsonProperty(value="configPageName") String configPageName, @JsonMapping.KssoJsonProperty(value="dataWithErrorMessages") String dataWithErrorMessages) {
        this.previousVersion = (String)Option.of((Object)previousVersion).getOrNull();
        this.resultCode = resultCode;
        this.message = message;
        this.oldConfigurationKey = oldConfigurationKey;
        this.configPageUrl = configPageUrl;
        this.configPageName = (String)Option.of((Object)configPageName).getOrElse((Object)("Could not find the relevant configuration page. Configuration key: " + oldConfigurationKey.name() + ". Contact support to get help with this."));
        this.dataWithErrorMessages = dataWithErrorMessages;
    }

    @Override
    public boolean isSuccess() {
        return this.resultCode == ResultCode.SUCCESS;
    }

    @Override
    public boolean isFailure() {
        return this.resultCode == ResultCode.FAILURE;
    }

    @Override
    @JsonMapping.KssoJsonProperty(value="previousVersion")
    public String getpreviousVersion() {
        return this.previousVersion;
    }

    public Option<Version> maybeVersion() {
        return Option.of((Object)this.previousVersion).map(Version::new);
    }

    @Override
    @JsonMapping.KssoJsonProperty(value="resultCode")
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    @JsonMapping.KssoJsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonMapping.KssoJsonProperty(value="configPageUrl")
    public String getConfigPageUrl() {
        return this.configPageUrl;
    }

    @Override
    @JsonMapping.KssoJsonProperty(value="configPageName")
    public String getConfigPageName() {
        return this.configPageName;
    }

    @JsonMapping.KssoJsonProperty(value="oldConfigurationKey")
    public KerbConfManager.KEYS getOldConfigurationKey() {
        return this.oldConfigurationKey;
    }

    @Override
    @JsonMapping.KssoJsonProperty(value="dataWithErrorMessages")
    public String getDataWithErrorMessages() {
        return StringUtils.trim((String)this.dataWithErrorMessages);
    }
}

