/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.v2;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupExecuteStatus;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupExecuteStatusAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupLogAttributesV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.kantega.atlaskerb.usercleanup.v2.InactiveUserCleanerV2;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="cleanup-status")
@PublicApi
public class GetExecutionStatusV2 {
    private static final Logger log = LoggerFactory.getLogger(GetExecutionStatusV2.class);
    UserManager userManager;
    CleanupHostApp<UserCleanupResultV2> hostApp;
    JsonWrapper jsonWrapper;
    InactiveUserCleanerV2 inactiveUserCleaner;

    @Autowired
    @Inject
    public GetExecutionStatusV2(@ComponentImport UserManager userManager, JsonWrapper jsonWrapper, InactiveUserCleanerV2 inactiveUserCleaner) {
        this.userManager = userManager;
        this.jsonWrapper = jsonWrapper;
        this.inactiveUserCleaner = inactiveUserCleaner;
        if (inactiveUserCleaner != null) {
            this.hostApp = inactiveUserCleaner.getHostApp();
        }
    }

    @Autowired
    public void setInactiveUserCleaner(InactiveUserCleanerV2 inactiveUserCleaner) {
        if (inactiveUserCleaner != null) {
            this.inactiveUserCleaner = inactiveUserCleaner;
            this.hostApp = inactiveUserCleaner.getHostApp();
        }
    }

    @Autowired
    public void setHostApp(CleanupHostApp<UserCleanupResultV2> hostApp) {
        if (this.hostApp == null) {
            this.hostApp = hostApp;
        }
    }

    private Response run(CleanupExecuteStatusAttributes executeStatusAttributes) {
        boolean isJsmCleanup = executeStatusAttributes.getJsmCleanup();
        CleanupStatus cleanupExecuteStatus = isJsmCleanup ? this.hostApp.getJsmCleanupExecuteStatus() : this.hostApp.getUserCleanupExecuteStatus();
        CleanupLogAttributesV2 cleanupLogAttributes = new CleanupLogAttributesV2(5, false, true, true, isJsmCleanup, false);
        UserCleanupResultV2[] userCleanupLog = this.inactiveUserCleaner.getCleanupLog(cleanupLogAttributes);
        CleanupExecuteStatus<UserCleanupResultV2> status = new CleanupExecuteStatus<UserCleanupResultV2>(cleanupExecuteStatus, userCleanupLog, isJsmCleanup ? this.hostApp.getJsmCleanupLastRunId() : this.hostApp.getUserCleanupLastRunId());
        return (Response)this.jsonWrapper.tryBuildJsonString(status).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request, CleanupExecuteStatusAttributes executeStatusAttributes) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run(executeStatusAttributes)).onFailure(e -> log.error("Encountered an exception while attempting to GET cleanup execution status. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

