/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.v2;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.scheduler.config.JobRunnerKey;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONObject;
import org.kantega.atlaskerb.jobs.JobManager;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CronAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupRuleDTOV2;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.usercleanup.v2.config.model.CleanupSchedulesAoService;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronSequenceGenerator;

@Path(value="cleanup-schedules")
public class CleanupRulesV2 {
    private static final Logger log = LoggerFactory.getLogger(CleanupRulesV2.class);
    private final UserManager userManager;
    private final JobManager jobManager;
    private final JsonWrapper jsonWrapper;
    private final CleanupSchedulesAoService cleanupSchedulesAoService;

    @Inject
    public CleanupRulesV2(@ComponentImport UserManager userManager, CleanupSchedulesAoService cleanupSchedulesAoService, JobManager jobManager, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.jobManager = jobManager;
        this.jsonWrapper = jsonWrapper;
        this.cleanupSchedulesAoService = cleanupSchedulesAoService;
    }

    private void scheduleJob(CleanupMode cleanupMode, String cron, String jobRunnerKey, String displayName) {
        this.jobManager.destroyJobsWithRunnerKey(JobRunnerKey.of((String)jobRunnerKey));
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("displayName", (Serializable)((Object)displayName));
        this.jobManager.scheduleCleanupJobV2(cleanupMode, cron, JobRunnerKey.of((String)jobRunnerKey), params);
    }

    private void destroyJob(String jobRunnerKey) {
        if (jobRunnerKey != null) {
            this.jobManager.destroyJobsWithRunnerKey(JobRunnerKey.of((String)jobRunnerKey));
        } else {
            log.warn("Tried to destroy cleanup job with empty jobrunner key");
        }
    }

    private Response addCleanupRule(UserProfile userProfile, CleanupRuleDTOV2 cleanupRule) {
        if (cleanupRule != null) {
            cleanupRule.setChangedByUsername(userProfile.getUsername());
            try {
                boolean shouldScheduleJob;
                CleanupRuleDTOV2 created = this.cleanupSchedulesAoService.addScheduledCleanupRule(cleanupRule);
                SanitizedLogStatement.of("Added cleanup rule: " + cleanupRule).andThenLog(arg_0 -> ((Logger)log).debug(arg_0));
                String cronSchedule = created.getCronAttributes() != null ? cleanupRule.getCronAttributes().getCronSpringSchedule() : null;
                boolean scheduleEnabled = created.getCronAttributes() != null && created.getCronAttributes().getScheduleEnabled();
                boolean bl = shouldScheduleJob = cronSchedule != null && !cronSchedule.isEmpty() && scheduleEnabled;
                if (shouldScheduleJob) {
                    this.scheduleJob(created.getCleanupMode(), cronSchedule, created.getJobRunnerKey(), created.getDisplayName());
                    log.info("Cleanup rule with id: {} scheduled by user {}", (Object)created.getId(), (Object)userProfile.getUsername());
                }
                return Response.ok().entity((Object)("Successfully added cleanup rule with ID " + created.getId())).build();
            }
            catch (Exception e) {
                log.error("Failed to add scheduled cleanup rule", (Throwable)e);
                return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to add cleanup rule. Check the logs for more information. " + cleanupRule);
            }
        }
        return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Cleanup rule data missing in request");
    }

    private Response editCleanupRule(String id, UserProfile userProfile, CleanupRuleDTOV2 cleanupRuleNewValues) {
        if (id == null) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Cleanup rule id missing in request for edit");
        }
        if (cleanupRuleNewValues != null) {
            try {
                boolean shouldScheduleJob;
                CleanupRuleDTOV2 edited;
                cleanupRuleNewValues.setChangedByUsername(userProfile.getUsername());
                if (cleanupRuleNewValues.getId() == null) {
                    cleanupRuleNewValues.setId(id);
                }
                if ((edited = this.cleanupSchedulesAoService.editScheduledCleanupRule(id, cleanupRuleNewValues)) == null) {
                    return ResponseUtils.errorWithMessageInJson(Response.Status.NOT_FOUND, "Failed to edit cleanup rule: " + cleanupRuleNewValues);
                }
                SanitizedLogStatement.of("Edited cleanup rule: " + cleanupRuleNewValues + " to " + edited).andThenLog(arg_0 -> ((Logger)log).debug(arg_0));
                String cronSchedule = cleanupRuleNewValues.getCronAttributes() != null ? cleanupRuleNewValues.getCronAttributes().getCronSpringSchedule() : null;
                boolean scheduleEnabled = cleanupRuleNewValues.getCronAttributes() != null && cleanupRuleNewValues.getCronAttributes().getScheduleEnabled();
                boolean bl = shouldScheduleJob = cronSchedule != null && !cronSchedule.isEmpty() && scheduleEnabled;
                if (shouldScheduleJob) {
                    this.scheduleJob(edited.getCleanupMode(), cronSchedule, edited.getJobRunnerKey(), edited.getDisplayName());
                } else {
                    this.destroyJob(edited.getJobRunnerKey());
                }
                return Response.ok().entity((Object)("Successfully edited cleanup rule with JobRunnerKey " + edited.getJobRunnerKey())).build();
            }
            catch (Exception e) {
                log.error("Failed to edit scheduled cleanup rule", (Throwable)e);
                return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to edit cleanup rule");
            }
        }
        return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Cleanup rule data missing in request");
    }

    private Response deleteCleanupRule(String id, UserProfile userProfile) {
        if (id == null) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Cleanup rule id missing in request for delete");
        }
        try {
            CleanupRuleDTOV2 toDelete = this.cleanupSchedulesAoService.getScheduledCleanupRule(id);
            if (toDelete == null) {
                return ResponseUtils.errorWithMessageInJson(Response.Status.NOT_FOUND, "Failed to delete cleanup rule. There is no cleanup rule with ID: " + id);
            }
            this.destroyJob(toDelete.getJobRunnerKey());
            this.cleanupSchedulesAoService.deleteScheduledCleanupRule(id);
            log.info("Cleanup rule with id: " + id + " deleted by user " + userProfile.getUsername());
            return Response.ok().entity((Object)("Successfully deleted cleanup rule with ID " + id)).build();
        }
        catch (Exception e) {
            SanitizedLogStatement.of(id).andThenLog(sanitizedId -> log.error("Failed to delete cleanup rule: " + sanitizedId, (Throwable)e));
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to delete cleanup rule: " + id);
        }
    }

    private Response getCleanupRules(String cleanupMode) {
        try {
            CleanupRuleDTOV2[] parsedCleanupRules = (CleanupRuleDTOV2[])this.cleanupSchedulesAoService.getScheduledCleanupRules().stream().filter(cleanupRule -> StringUtils.isBlank((CharSequence)cleanupMode) || cleanupRule.getCleanupMode().isEqualTo(cleanupMode)).map(cleanupRuleDTOV2 -> cleanupRuleDTOV2.setNextRunDateTimeUtc(this.dateTimeUtcNextRun(cleanupRuleDTOV2.getCronAttributes()))).sorted(Comparator.comparing(CleanupRuleDTOV2::getId)).toArray(CleanupRuleDTOV2[]::new);
            return Response.ok().entity((Object)parsedCleanupRules).build();
        }
        catch (Exception e) {
            log.error("Failed to get scheduled cleanup rules", (Throwable)e);
            return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to get cleanup rules");
        }
    }

    private String dateTimeUtcNextRun(CronAttributes cronAttributes) {
        try {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            df.setTimeZone(tz);
            String cron = cronAttributes.getCronSpringSchedule();
            if (!StringUtils.equals((CharSequence)"", (CharSequence)cron) && cron != null) {
                CronSequenceGenerator generator = new CronSequenceGenerator(cron);
                DateTime next = new DateTime((Object)generator.next(new Date())).toDateTime(DateTimeZone.UTC);
                return next.toString();
            }
        }
        catch (Exception e) {
            log.warn("Failed to get next run date for cron: " + (String)Option.of((Object)cronAttributes).map(CronAttributes::getCronSpringSchedule).getOrElse((Object)""), (Throwable)e);
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.getCleanupRules(request.getParameter("cleanupMode"))).onFailure(e -> log.error("Encountered an exception while attempting to GET cleanup rules. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, CleanupRuleDTOV2 cleanupRule) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.addCleanupRule((UserProfile)userProfile, cleanupRule)).onFailure(e -> log.error("Encountered an exception while attempting to set new cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    @Path(value="/initialize")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response initializeCleanupRules(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> {
            this.jobManager.initializeJobs();
            String responseBody = new JSONObject().put("message", (Object)"Successfully initialized cleanup rules").toString();
            return Response.ok().entity((Object)responseBody).build();
        }).onFailure(e -> log.error("Encountered an exception while attempting to set new cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/edit/{id}")
    public Response doPut(@Context HttpServletRequest request, @PathParam(value="id") String id, CleanupRuleDTOV2 cleanupRule) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.editCleanupRule(id, (UserProfile)userProfile, cleanupRule)).onFailure(e -> log.error("Encountered an exception while attempting to set new cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/delete/{id}")
    public Response doDelete(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.deleteCleanupRule(id, (UserProfile)userProfile)).onFailure(e -> log.error("Encountered an exception while attempting to set new cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

