/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.inject.Inject;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectReader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.jobs.JsmCleanupJobRunner;
import org.kantega.atlaskerb.jobs.JsmCleanupJobRunnerV2;
import org.kantega.atlaskerb.jobs.UserCleanupJobRunner;
import org.kantega.atlaskerb.jobs.UserCleanupJobRunnerV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupRuleDTOV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupRuleDTOV2;
import org.kantega.atlaskerb.usercleanup.v2.config.model.CleanupSchedulesAoService;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class JobManager
implements LifecycleAware {
    private final SchedulerService schedulerService;
    private final UserCleanupJobRunner userCleanupJobRunner;
    private final UserCleanupJobRunnerV2 userCleanupJobRunnerV2;
    private final JsmCleanupJobRunner jsmCleanupJobRunner;
    private final JsmCleanupJobRunnerV2 jsmCleanupJobRunnerV2;
    private final List<JobId> scheduledJobIds = new CopyOnWriteArrayList<JobId>();
    private final List<JobRunnerKey> registeredJobRunnerKeys = new CopyOnWriteArrayList<JobRunnerKey>();
    private final Map<JobRunnerKey, List<JobId>> jobIdsPerRunnerKey = new HashMap<JobRunnerKey, List<JobId>>();
    private final KerbConfManager kerbConfManager;
    private final Logger log = LoggerFactory.getLogger(JobManager.class);
    private final JsonWrapper jsonWrapper;
    private final CleanupSchedulesAoService cleanupSchedulesAoService;

    @Inject
    public JobManager(UserCleanupJobRunner userCleanupJobRunner, UserCleanupJobRunnerV2 userCleanupJobRunnerV2, JsmCleanupJobRunner jsmCleanupJobRunner, JsmCleanupJobRunnerV2 jsmCleanupJobRunnerV2, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper, CleanupSchedulesAoService cleanupSchedulesAoService) {
        this.schedulerService = (SchedulerService)ComponentLocator.getComponent(SchedulerService.class);
        this.userCleanupJobRunner = userCleanupJobRunner;
        this.userCleanupJobRunnerV2 = userCleanupJobRunnerV2;
        this.jsmCleanupJobRunner = jsmCleanupJobRunner;
        this.jsmCleanupJobRunnerV2 = jsmCleanupJobRunnerV2;
        this.kerbConfManager = kerbConfManager;
        this.jsonWrapper = jsonWrapper;
        this.cleanupSchedulesAoService = cleanupSchedulesAoService;
    }

    public void onStart() {
        this.log.info("Plugin started. Reinitializing background tasks.");
        this.initializeJobs();
    }

    public void onStop() {
        this.log.info("Plugin stopped. Destroying background tasks.");
        this.destroy();
    }

    public void removeExistingUserCleanupJobs() {
        Set<JobRunnerKey> filteredJobRunnerKeys = this.schedulerService.getJobRunnerKeysForAllScheduledJobs().stream().filter(key -> key.toString().startsWith("no.kantega.usermanagement")).collect(Collectors.toSet());
        filteredJobRunnerKeys.forEach(key -> {
            List allJobs = this.schedulerService.getJobsByJobRunnerKey(key);
            for (JobDetails jobId : allJobs) {
                JobDetails jobDetails = this.schedulerService.getJobDetails(jobId.getJobId());
                if (!jobDetails.getJobRunnerKey().toString().startsWith("no.kantega.usermanagement")) continue;
                this.log.info("Found existing job, unscheduling: " + jobDetails.getJobId());
                this.schedulerService.unscheduleJob(jobDetails.getJobId());
                break;
            }
            this.schedulerService.unregisterJobRunner(key);
        });
        this.schedulerService.getJobRunnerKeysForAllScheduledJobs().stream().filter(key -> key.toString().startsWith("no.kantega.usermanagement")).forEach(jobRunnerKey -> this.log.warn("JobRunner was not removed: " + jobRunnerKey));
    }

    public void initializeJobs() {
        String platform = this.kerbConfManager.getApplicationProperties().getPlatformId();
        this.removeExistingUserCleanupJobs();
        this.conditionallyScheduleCleanupsOnStartupV2();
    }

    public void scheduleUserCleanupJobV1(String cron, JobRunnerKey runnerKey) {
        Schedule schedule = Schedule.forCronExpression((String)cron);
        if (runnerKey.equals((Object)UserCleanupJobRunner.JOB_RUNNER_KEY)) {
            this.scheduleJob(UserCleanupJobRunner.JOB_RUNNER_KEY, schedule, this.userCleanupJobRunner, null);
        }
    }

    public void scheduleJsmCleanupJobV1(String cron, JobRunnerKey runnerKey) {
        Schedule schedule = Schedule.forCronExpression((String)cron);
        if (runnerKey.equals((Object)JsmCleanupJobRunner.JOB_RUNNER_KEY)) {
            this.scheduleJob(JsmCleanupJobRunner.JOB_RUNNER_KEY, schedule, this.jsmCleanupJobRunner, null);
        }
    }

    private void conditionallyScheduleCleanupV1(CleanupMode cleanupMode) {
        String cleanupRuleJson = this.kerbConfManager.getCleanupRuleJSONString(cleanupMode);
        JobRunnerKey runnerKey = this.getRunnerKey(cleanupMode);
        if (cleanupRuleJson != null) {
            ObjectReader om = this.jsonWrapper.objectReader();
            try {
                CleanupRuleDTOV1 cleanupRule = (CleanupRuleDTOV1)om.readValue(cleanupRuleJson, CleanupRuleDTOV1.class);
                if (cleanupRule == null || cleanupRule.getCronAttributes() == null) {
                    this.log.warn("Failed to restart user cleanup job after app restart. CronAttributes was missing in cleanup rule: " + cleanupRuleJson);
                    return;
                }
                if (cleanupRule.getCronAttributes().getScheduleEnabled() && cleanupRule.getCronAttributes().getCronSchedule() != null) {
                    String cron = cleanupRule.getCronAttributes().getCronSpringSchedule();
                    if (cleanupMode.equals((Object)CleanupMode.USERS)) {
                        this.scheduleUserCleanupJobV1(cron, runnerKey);
                    } else {
                        this.scheduleJsmCleanupJobV1(cron, runnerKey);
                    }
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to restart user cleanup job after app restart", (Throwable)e);
            }
        }
    }

    private JobRunnerKey getRunnerKey(CleanupMode cleanupMode) {
        if (cleanupMode.equals((Object)CleanupMode.JSM)) {
            return JsmCleanupJobRunner.JOB_RUNNER_KEY;
        }
        return UserCleanupJobRunner.JOB_RUNNER_KEY;
    }

    private void conditionallyScheduleCleanupsOnStartupV2() {
        try {
            List<CleanupRuleDTOV2> cleanupRules = this.cleanupSchedulesAoService.getScheduledCleanupRules();
            for (CleanupRuleDTOV2 cleanupRule : cleanupRules) {
                if (cleanupRule.getCronAttributes() == null || !cleanupRule.getCronAttributes().getScheduleEnabled() || cleanupRule.getCronAttributes().getCronSchedule() == null) continue;
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put("displayName", (Serializable)((Object)cleanupRule.getDisplayName()));
                String cron = cleanupRule.getCronAttributes().getCronSpringSchedule();
                if (cleanupRule.getCleanupMode().equals((Object)CleanupMode.JSM)) {
                    String platformId = this.kerbConfManager.getApplicationProperties().getPlatformId();
                    if (!platformId.equals("jira")) continue;
                    this.scheduleCleanupJobV2(cleanupRule.getCleanupMode(), cron, JobRunnerKey.of((String)cleanupRule.getJobRunnerKey()), params);
                    continue;
                }
                this.scheduleCleanupJobV2(cleanupRule.getCleanupMode(), cron, JobRunnerKey.of((String)cleanupRule.getJobRunnerKey()), params);
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to restart user cleanup job after app restart", (Throwable)e);
        }
    }

    public void scheduleCleanupJob(CleanupMode cleanupMode, String cron, JobRunnerKey runnerKey) {
        Schedule schedule = Schedule.forCronExpression((String)cron);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        if (cleanupMode == CleanupMode.JSM) {
            this.scheduleJob(runnerKey, schedule, this.jsmCleanupJobRunner, params);
        } else {
            this.scheduleJob(runnerKey, schedule, this.userCleanupJobRunner, params);
        }
    }

    public void scheduleCleanupJobV2(CleanupMode cleanupMode, String cron, JobRunnerKey runnerKey, Map<String, Serializable> params) {
        Schedule schedule = Schedule.forCronExpression((String)cron);
        if (cleanupMode == CleanupMode.JSM) {
            this.scheduleJob(runnerKey, schedule, this.jsmCleanupJobRunnerV2, params);
        } else {
            this.scheduleJob(runnerKey, schedule, this.userCleanupJobRunnerV2, params);
        }
    }

    public void destroyJobsWithRunnerKey(JobRunnerKey runnerKey) {
        if (!this.registeredJobRunnerKeys.contains(runnerKey) && !this.jobIdsPerRunnerKey.containsKey(runnerKey)) {
            return;
        }
        if (this.jobIdsPerRunnerKey.containsKey(runnerKey)) {
            for (JobId scheduledJobId : this.jobIdsPerRunnerKey.get(runnerKey)) {
                this.schedulerService.unscheduleJob(scheduledJobId);
            }
        }
        this.schedulerService.unregisterJobRunner(runnerKey);
        this.jobIdsPerRunnerKey.remove(runnerKey);
        this.registeredJobRunnerKeys.remove(runnerKey);
    }

    private void scheduleJob(JobRunnerKey jobRunnerKey, Schedule schedule, JobRunner runner, Map<String, @Nullable Serializable> params) {
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withSchedule(schedule).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters(params);
        this.schedulerService.registerJobRunner(jobRunnerKey, runner);
        this.registeredJobRunnerKeys.add(jobRunnerKey);
        try {
            JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            if (this.jobIdsPerRunnerKey.containsKey(jobRunnerKey)) {
                this.jobIdsPerRunnerKey.get(jobRunnerKey).add(jobId);
            } else {
                ArrayList<JobId> newList = new ArrayList<JobId>();
                newList.add(jobId);
                this.jobIdsPerRunnerKey.put(jobRunnerKey, newList);
            }
            this.scheduledJobIds.add(jobId);
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        for (JobId scheduledJobId : this.scheduledJobIds) {
            this.schedulerService.unscheduleJob(scheduledJobId);
        }
        for (JobRunnerKey registeredJobRunnerKey : this.registeredJobRunnerKeys) {
            this.schedulerService.unregisterJobRunner(registeredJobRunnerKey);
            this.jobIdsPerRunnerKey.remove(registeredJobRunnerKey);
            this.registeredJobRunnerKeys.remove(registeredJobRunnerKey);
        }
        this.removeExistingUserCleanupJobs();
    }
}

