/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.PluginKey;

public abstract class RequireLoggedInUserServlet
extends HttpServlet {
    public static final String KRB_CSRF_TOKEN_ATTR = "krb_csrf_token";
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;

    public RequireLoggedInUserServlet(UserManager userManager, LoginUriProvider loginUriProvider) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        UserProfile remoteUser = this.userManager.getRemoteUser(request);
        if (remoteUser == null) {
            this.redirectToLogin(request, response);
            return;
        }
        super.service(request, response);
    }

    protected void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Object url = request.getRequestURI().substring(request.getContextPath().length());
            if (request.getQueryString() != null) {
                url = (String)url + "?" + request.getQueryString();
            }
            URI returnUri = new URI((String)url);
            String location = this.loginUriProvider.getLoginUri(returnUri).toString();
            response.sendRedirect(location);
            return;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> newModel(HttpServletRequest req) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("krb_token", req.getSession().getAttribute(KRB_CSRF_TOKEN_ATTR));
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":entrypoint-atlaskerb");
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        return model;
    }
}

