/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import io.vavr.CheckedFunction0;
import io.vavr.Function1;
import io.vavr.Predicates;
import io.vavr.collection.CharSeq;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class KssoStringUtils {
    public static final Predicate<CharSeq> isCompilingRegex = cs -> Try.of((CheckedFunction0 & Serializable)() -> Pattern.compile(cs.mkString())).isSuccess();
    public static final Predicate<CharSeq> isPrefixedRegex = cs -> cs.startsWith(StringLiteral.REGEX_PREFIX.charSeq());
    public static final Predicate<CharSeq> isSuffixedRegex = cs -> cs.endsWith(StringLiteral.REGEX_SUFFIX.charSeq());
    public static final Predicate<CharSeq> isValidPrefixAndSuffixRegex = Predicates.allOf((Predicate[])new Predicate[]{isCompilingRegex, isPrefixedRegex, isSuffixedRegex});
    public static final Function1<CharSeq, CharSeq> removeAllSpaces = (Function1 & Serializable)charSeq -> charSeq.replaceAll(StringLiteral.MULTIPLE_WHITESPACE_LOOKUP.value, StringLiteral.EMPTY_STRING.value);
    public static final Function1<String, String> removeAllSpacesFromString = (Function1 & Serializable)string -> ((CharSeq)removeAllSpaces.apply((Object)CharSeq.of((CharSequence)string))).mkString();

    public static CharSeq removeAllSpaces(CharSeq charSeq) {
        return (CharSeq)removeAllSpaces.apply((Object)charSeq);
    }

    public static String removeAllSpaces(String str) {
        return (String)removeAllSpacesFromString.apply((Object)str);
    }

    public static enum StringLiteral {
        EMPTY_STRING(""),
        MULTIPLE_WHITESPACE_LOOKUP("\\s+"),
        COMMA(","),
        LINE_SEPARATOR_LOOKUP("\\R+"),
        NEW_LINE_SEPARATOR(System.lineSeparator()),
        SINGLE_SPACE(" "),
        COMMA_AND_SPACE(StringLiteral.COMMA.value + StringLiteral.SINGLE_SPACE.value),
        REGEX_PREFIX("^"),
        REGEX_SUFFIX("$"),
        PUNCTUATION("."),
        LDAP_ESCAPE_CHARACTER("\\");

        public final String value;

        private StringLiteral(String value) {
            this.value = value;
        }

        CharSeq charSeq() {
            return CharSeq.of((CharSequence)this.value);
        }

        Character character() {
            return (Character)CharSeq.of((CharSequence)this.value).get();
        }
    }
}

