/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.event.events.security.LoginDetails;
import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.security.login.HistoricalLoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.security.persistence.dao.hibernate.HibernateUserLoginInfoDao;
import com.atlassian.confluence.user.LoginDetailsHelper;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import io.vavr.control.Option;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import kantega.shaded.com.fasterxml.jackson.databind.JsonNode;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.DefaultCleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.UnifiedLicenseInfo;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
class ConfluenceCleanupHostApp<U extends UserCleanupResultV1>
extends DefaultCleanupHostApp<U> {
    private final Method onSuccessfulLoginAttemptMethod;
    private final LoginManager loginManager;
    private final ConfluenceAccessManager confluenceAccessManager;
    private final UserDetailsManager userDetailsManager;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Class<?> confluenceLoginManagerClass = null;
    private Method getLoginInfoMethod;
    private Method getLastSuccessfulLoginDateMethod;
    HibernateUserLoginInfoDao hibernateUserLoginInfoDao;
    UserAccessor userAccessor;
    private final AccessModeService accessModeService;
    private final LicenseService licenseService;
    private final UserChecker userChecker;

    public ConfluenceCleanupHostApp(@ComponentImport TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, @ComponentImport AuthenticationListener authenticationListener, @ComponentImport EventPublisher eventPublisher, @ComponentImport AuthenticationController authenticationController, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport CrowdService crowdService, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper, @ComponentImport AccessModeService accessModeService) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, kerbConfManager, jsonWrapper);
        this.accessModeService = accessModeService;
        Method onSuccessfulLoginAttemptMethod = null;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader().getParent();
            if (classLoader != null) {
                this.confluenceLoginManagerClass = LoginManager.class;
                onSuccessfulLoginAttemptMethod = this.confluenceLoginManagerClass.getMethod("onSuccessfulLoginAttempt", String.class, HttpServletRequest.class);
            }
        }
        catch (Exception e) {
            this.log.warn("Could not load Confluence LoginManager. Login count / time update disabled", (Throwable)e);
        }
        this.onSuccessfulLoginAttemptMethod = onSuccessfulLoginAttemptMethod;
        this.loginManager = (LoginManager)ComponentLocator.getComponent(LoginManager.class);
        try {
            this.getLoginInfoMethod = this.loginManager.getClass().getMethod("getLoginInfo", String.class);
        }
        catch (NoSuchMethodException e) {
            this.log.error("Couldn't find method getLoginInfo for class loginManager");
        }
        try {
            this.getLastSuccessfulLoginDateMethod = HistoricalLoginInfo.class.getMethod("getLastSuccessfulLoginDate", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.log.error("Couldn't find method getLastSuccessfulLoginDateMethod for class HistoricalLoginInfo");
        }
        this.confluenceAccessManager = this.tryToGetConfluenceAccessManager();
        this.permissionManager = (PermissionManager)ComponentLocator.getComponent(PermissionManager.class);
        this.userDetailsManager = (UserDetailsManager)ComponentLocator.getComponent(UserDetailsManager.class);
        this.userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        this.userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        this.hibernateUserLoginInfoDao = (HibernateUserLoginInfoDao)ComponentLocator.getComponent(HibernateUserLoginInfoDao.class);
        this.licenseService = (LicenseService)ComponentLocator.getComponent(LicenseService.class);
        this.userChecker = (UserChecker)ComponentLocator.getComponent(UserChecker.class);
    }

    @Override
    public void publishUserAuthenticatedEvent(Principal user, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String remoteIP = httpServletRequest.getRemoteAddr();
        String remoteHost = httpServletRequest.getRemoteHost();
        Boolean ssoLoginObj = (Boolean)httpServletRequest.getSession().getAttribute("com.atlassian.plugins.authentication.userLoggedInWithSso");
        LoginDetails.CaptchaState captchaState = httpServletRequest.getParameterValues("captchaId") != null ? LoginDetails.CaptchaState.PASSED : LoginDetails.CaptchaState.NOT_SHOWN;
        LoginDetails loginDetails = new LoginDetails(LoginDetailsHelper.isDirectLogin((HttpServletRequest)httpServletRequest) ? LoginDetails.LoginSource.DIRECT : LoginDetails.LoginSource.SSO, captchaState);
        this.log.debug(String.format("Confluence LoginEvent: %s, isSso: %s", user.getName(), ssoLoginObj));
        this.eventPublisher.publish((Object)new LoginEvent((Object)this, user.getName(), httpServletRequest.getSession().getId(), remoteHost, remoteIP, loginDetails));
        super.publishUserAuthenticatedEvent(user, httpServletRequest, httpServletResponse);
    }

    private ConfluenceAccessManager tryToGetConfluenceAccessManager() {
        try {
            Class<?> camClass = Thread.currentThread().getContextClassLoader().loadClass("com.atlassian.confluence.security.access.ConfluenceAccessManager");
            return (ConfluenceAccessManager)ComponentLocator.getComponent(camClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"confluence", (CharSequence)product);
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req) {
        String requestUri = HttpUrlUtils.getInternalPath(req);
        String qs = req.getQueryString();
        return (this.isMainLoginPage(req) || requestUri.startsWith("/m/login/login.action")) && this.avoidSSOForUserAvatar(qs);
    }

    @Override
    public boolean isMainLoginPage(HttpServletRequest request) {
        String internalPath = HttpUrlUtils.getInternalPath(request);
        return internalPath.startsWith("/login.action");
    }

    private boolean avoidSSOForUserAvatar(String qs) {
        return this.kerbConfManager.isSSOEnabledForUserAvatar() || !this.isUserAvatar(qs);
    }

    private boolean isUserAvatar(String qs) {
        return StringUtils.isNotBlank((CharSequence)qs) && qs.matches(".*%2Fdownload%2Fattachments%2F.*%2Fuser-avatar.*");
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        Boolean logout = (Boolean)Option.of((Object)req.getParameter("logout")).map(Boolean::parseBoolean).getOrElse((Object)false);
        Boolean webdavRequestButDisabled = this.isWebdavRequest(req) && !this.kerbConfManager.isWebdavEnabled();
        return logout != false || webdavRequestButDisabled != false;
    }

    private boolean isWebdavRequest(HttpServletRequest req) {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        return requestPath.startsWith("/plugins/servlet/confluence");
    }

    private void recordSuccessfulLoginEventWithLoginManager(Principal user, HttpServletRequest req) {
        try {
            this.loginManager.onSuccessfulLoginAttempt(user.getName(), req);
        }
        catch (Exception e) {
            this.log.warn("Failing registering successful login in Confluence", (Throwable)e);
        }
    }

    @Override
    public boolean isPublicAccessEnabled() {
        if (this.confluenceAccessManager == null) {
            this.log.warn("No ConfluenceAccessManager available, unable to determine public access");
            return super.isPublicAccessEnabled();
        }
        AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus(null);
        return userAccessStatus.hasAnonymousAccess() || userAccessStatus.hasUnlicensedAuthenticatedAccess();
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.confluence.user.ConfluenceAuthenticator";
    }

    @Override
    public boolean canLogin(Principal user, HttpServletRequest request) {
        UserAccessor accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        User confluenceUser = accessor.getUser(user.getName());
        if (this.confluenceAccessManager != null) {
            AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus(confluenceUser);
            return userAccessStatus.canUseConfluence();
        }
        if (this.permissionManager != null) {
            return this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, PermissionManager.TARGET_APPLICATION);
        }
        return false;
    }

    @Override
    public UserWithAttributes getUserForCleanup(com.atlassian.crowd.embedded.api.User user) {
        return UserTemplateWithAttributes.toUserWithNoAttributes((com.atlassian.crowd.embedded.api.User)user);
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        try {
            Date lastLogin;
            this.log.debug("Calling getLastSuccessfulLoginDate");
            if (this.getLoginInfoMethod == null) {
                throw new RuntimeException("getLoginInfo method is null");
            }
            Object loginInfo = this.getLoginInfoMethod.invoke((Object)this.loginManager, user.getName());
            if (this.getLastSuccessfulLoginDateMethod != null) {
                lastLogin = (Date)this.getLastSuccessfulLoginDateMethod.invoke(loginInfo, new Object[0]);
            } else {
                Method getLastSuccessfulLoginDate = loginInfo.getClass().getMethod("getLastSuccessfulLoginDate", new Class[0]);
                getLastSuccessfulLoginDate.setAccessible(true);
                lastLogin = (Date)getLastSuccessfulLoginDate.invoke(loginInfo, new Object[0]);
            }
            this.log.debug("getLastSuccessfulLoginDate for user {} was {}", (Object)user.getName(), (Object)lastLogin);
            if (lastLogin != null) {
                return String.format("%d", lastLogin.getTime());
            }
            return null;
        }
        catch (Exception e) {
            this.log.error("Problems calling getLastSuccessfulLoginDate", (Throwable)e);
            return String.format("%d", new Date().getTime());
        }
    }

    @Override
    public String getLastLoginParameter() {
        return "lastAuthenticated";
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("confluence-administrators"))) {
            return "confluence-administrators";
        }
        return null;
    }

    @Override
    public String getLoginPage() {
        return "/login.action";
    }

    @Override
    public String getLogoutPage() {
        return "/login.action?logout=true";
    }

    @Override
    public boolean isLogoutPage(HttpServletRequest req) {
        return this.getLogoutPage().equalsIgnoreCase(HttpUrlUtils.getInternalPath(req));
    }

    @Override
    public Map<String, String> mapNameToExternalId(List<com.atlassian.crowd.embedded.api.User> userBatch, Map<String, String> userData) {
        if (userBatch.size() == 0) {
            return userData;
        }
        if (!userBatch.get(0).getClass().equals(InternalUser.class)) {
            userBatch.forEach(user -> userData.put(user.getName(), ((TimestampedUser)user).getExternalId()));
        } else {
            userBatch.forEach(user -> userData.put(user.getName(), ((InternalUser)user).getExternalId()));
        }
        return userData;
    }

    @Override
    public UnifiedLicenseInfo getLicenseSize() {
        UnifiedLicenseInfo unifiedLicenseInfo = new UnifiedLicenseInfo();
        ConfluenceLicense license = this.licenseService.retrieve();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String jsonString = objectMapper.writeValueAsString((Object)license);
            JsonNode jsonNode = objectMapper.readTree(jsonString);
            JsonNode numberOfUsers = jsonNode.get("maximumNumberOfUsers");
            JsonNode unlimitedNumberOfUsers = jsonNode.get("unlimitedNumberOfUsers");
            int numberOfUsersInt = numberOfUsers.asInt();
            unifiedLicenseInfo.setMaximumNumberOfUsers(numberOfUsersInt);
            unifiedLicenseInfo.setUnlimitedNumberOfUsers(unlimitedNumberOfUsers.asBoolean());
        }
        catch (JsonProcessingException e) {
            this.log.error("Error while obtaining license size");
            throw new RuntimeException("Error while obtaining license size");
        }
        int numberOfRegisteredUsers = this.userChecker.getNumberOfRegisteredUsers();
        unifiedLicenseInfo.setTotalBillableUsers(numberOfRegisteredUsers);
        return unifiedLicenseInfo;
    }

    @Override
    public Set<String> getUserApplicationRoles(Principal user) {
        User confluenceUser = this.userAccessor.getUser(user.getName());
        if (confluenceUser == null) {
            return new HashSet<String>();
        }
        HashSet<String> roles = new HashSet<String>();
        if (this.canLogin(user, null)) {
            roles.add("confluence-user");
        }
        return roles;
    }

    @Override
    public boolean isProductInReadOnlyMode() {
        return this.accessModeService.isReadOnlyAccessModeEnabled();
    }
}

