/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.util.Option;
import com.kantegasso.runtimetrust.Fingerprint;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucketCleanup;
import org.kantega.atlaskerb.RequireLoggedInUserServlet;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.update.KssoUpdateManagerCleanup;
import org.kantega.atlaskerb.update.data.UpdateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class RequireAdminServletCleanup
extends RequireLoggedInUserServlet {
    private static final Logger log = LoggerFactory.getLogger(RequireAdminServletCleanup.class);
    public final UserManager userManager;
    public final TemplateRenderer templateRenderer;
    public final WebSudoManager webSudoManager;
    public final PluginLicenseManager pluginLicenseManager;
    public CleanupHostApp<UserCleanupResultV2> hostApp;
    public final ApplicationProperties applicationProperties;
    public final PluginAccessor pluginAccessor;
    public final KerbConfManager kerbConfManager;
    private final SecureRandom random = new SecureRandom();
    public final KssoUpdateManagerCleanup kssoUpdateManager;

    @Autowired
    public void setHostApp(CleanupHostApp<UserCleanupResultV2> cleanupHostApp) {
        this.hostApp = cleanupHostApp;
    }

    public RequireAdminServletCleanup(RequireAdminServletDependencyBucketCleanup bucket) {
        super(bucket.getUserManager(), bucket.getLoginUriProvider());
        this.userManager = bucket.getUserManager();
        this.templateRenderer = bucket.getTemplateRenderer();
        this.webSudoManager = bucket.getWebSudoManager();
        this.pluginLicenseManager = bucket.getPluginLicenseManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.pluginAccessor = bucket.getPluginAccessor();
        this.kssoUpdateManager = bucket.getKssoUpdateManager();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            if (this.kssoUpdateManager.isKssoConfigUpdateNeeded() && !this.kssoUpdateManager.hasUpdateFailures()) {
                List<UpdateMessage> list = this.kssoUpdateManager.doUpdate();
            } else if (this.kerbConfManager.getSavedKssoConfigVersion().isEmpty()) {
                this.kerbConfManager.updateKssoVersionInConfig();
            }
        }
        catch (Exception e) {
            log.error("Encountered an error during upgrade.", (Throwable)e);
        }
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        UserKey remoteUserKey = this.userManager.getRemoteUserKey(request);
        if (remoteUserKey == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.userManager.isSystemAdmin(remoteUserKey)) {
            response.setContentType("text/html");
            response.sendError(401, "Page requires system administrator access");
            return;
        }
        this.ensureCsrfTokenInSession(request);
        try {
            if (!this.expectsMultipart() && !this.checkCsrf(request)) {
                this.renderCsrfFailed(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            super.service(request, response);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
        catch (CsrfException e) {
            this.renderCsrfFailed(request, response);
        }
        catch (Exception e) {
            log.error("Error in RequireAdminServlet", (Throwable)e);
            response.setContentType("text/html");
            response.sendError(500, "Error in RequireAdminServlet: " + e.getMessage());
        }
    }

    private boolean isPageThatShouldUpdateConfigAutomatically(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        return !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/dark-features") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/support") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/debuginfo") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/backup") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/config-status") && !requestUri.equals(this.kerbConfManager.getPluginRootUri() + "/dashboard");
    }

    private void renderCsrfFailed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setStatus(400);
        this.templateRenderer.render("templates/atlaskerb/csrf-failed.vm", this.newModel(request), (Writer)response.getWriter());
    }

    private boolean checkCsrf(HttpServletRequest request) {
        boolean tokenIsValid;
        HttpSession httpSession = request.getSession();
        if (this.isSafeHttpMethod(request)) {
            return true;
        }
        this.ensureCsrfTokenInSession(request);
        String token_param = request.getParameter("krb_token");
        String token = (String)httpSession.getAttribute("krb_csrf_token");
        boolean bl = tokenIsValid = token != null && token.equals(token_param);
        if (this.kerbConfManager.isCsrfOriginCheckEnabled()) {
            return tokenIsValid && this.isSameOriginOrReferer(request);
        }
        return tokenIsValid;
    }

    private boolean isSameOriginOrReferer(HttpServletRequest request) {
        Try expectedOrigin = Try.of((CheckedFunction0 & Serializable)() -> new URI(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getAuthority());
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> (String)List.of((Object[])new String[]{"Origin", "Referer"}).map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).filter(Objects::nonNull).peek()).mapTry((CheckedFunction1 & Serializable)requestOrigin -> new URI((String)requestOrigin).getAuthority().equals(expectedOrigin.get())).onFailure(throwable -> log.warn("[KSSO CSRF] NOT OK | " + String.format("Origin: %s | Referer: %s | Expected: %s | Application Base URL: %s", request.getHeader("Origin"), request.getHeader("Referer"), expectedOrigin.getOrElse((Object)"Not able to parse."), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)))).getOrElse((Object)true);
    }

    private boolean isSafeHttpMethod(HttpServletRequest request) {
        return List.of((Object[])new String[]{"GET", "HEAD", "OPTIONS", "TRACE"}).contains((Object)request.getMethod());
    }

    private void ensureCsrfTokenInSession(HttpServletRequest request) {
        if (request.getSession().getAttribute("krb_csrf_token") == null) {
            byte[] passwordBytes = new byte[32];
            this.random.nextBytes(passwordBytes);
            String token = Fingerprint.sha1Fingerprint((byte[])passwordBytes);
            request.getSession().setAttribute("krb_csrf_token", (Object)token);
        }
    }

    @Override
    protected Map<String, Object> newModel(HttpServletRequest req) {
        Map<String, Object> model = super.newModel(req);
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("pluginAdminPath", contextPath + this.kerbConfManager.getPluginRootUri());
        model.put("pluginKey", PluginKey.getPluginKey());
        model.put("pluginKeyBasePart", PluginKey.getPluginKeyBasepart());
        model.put("pluginResource", PluginKey.getPluginKey() + ":entrypoint-atlaskerb");
        String basePath = (String)Try.of((CheckedFunction0 & Serializable)() -> new URL(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getPath()).getOrElse((Object)"");
        model.put("basePath", basePath);
        Option maybeLicense = this.pluginLicenseManager.getLicense();
        if (maybeLicense.isDefined()) {
            model.put("pluginLicense", maybeLicense.get());
        }
        String installedPluginVersion = (String)io.vavr.control.Option.of((Object)this.pluginAccessor).map(pluginAccessor -> pluginAccessor.getPlugin(this.pluginLicenseManager.getPluginKey())).map(Plugin::getPluginInformation).map(PluginInformation::getVersion).getOrElse((Object)"UNKNOWN");
        model.put("installedPluginVersion", installedPluginVersion);
        String requestURI = req.getRequestURI();
        if (requestURI.contains("/saml/")) {
            model.put("topMenu", "SAML");
        } else {
            model.put("topMenu", "Kerberos");
            model.put("kerberosEnabled", false);
        }
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("displaySingleLogout", !this.hostApp.isProductMatch("fecru"));
        model.put("applicationProperties", this.kerbConfManager.getApplicationProperties());
        model.put("isKerberosConfigured", false);
        model.put("isApiTokensEnabled", false);
        String page = requestURI.substring(requestURI.lastIndexOf("/") + 1);
        if (!page.isEmpty()) {
            model.put("menuItem", page);
        }
        model.put("backUrl", this.validateURLInput(req.getParameter("backUrl")));
        model.put("backLinkDescription", req.getParameter("backLinkDescription"));
        model.put("isJsdInstalled", this.kerbConfManager.isJsmInstalled());
        return model;
    }

    private String validateURLInput(String backUrl) {
        if (backUrl != null) {
            try {
                URI uri = new URI(backUrl);
                return uri.getQuery() != null ? uri.getPath() + "?" + uri.getQuery() : uri.getPath();
            }
            catch (URISyntaxException e) {
                log.error("Not valid backlink url", (Throwable)e);
            }
        }
        return null;
    }

    protected TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    protected boolean expectsMultipart() {
        return false;
    }

    protected io.vavr.control.Option<String> getSafeParameter(String parameter, HttpServletRequest request) {
        return io.vavr.control.Option.of((Object)request.getParameter(parameter)).map(StringUtils::trim).filter(StringUtils::isNotBlank);
    }

    private static class CsrfException
    extends SecurityException {
        private CsrfException() {
        }
    }
}

