/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Organization;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.HomeDirectoryResolver;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.kerberos.Stats;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KerbConfManager
implements DebugInfo {
    private static final String KEYTAB_INFO_KEY = "keytabInfo";
    private static final String key = "atlaskerb";
    private static final String oldDisableLoginFileName = "disable_username_password_login.txt";
    private static final String disableTraditionalLoginFileName = "prevent_username_password_login.txt";
    private static final String disableJsmLoginFileName = "prevent_jsm_username_password_login.txt";
    private static final String disableBasicAuthFileName = "disable_basic_auth_rest.txt";
    private static final String enableCsrfOriginCheckFileName = "enable_csrf_origin_check.txt";
    public static final String[] defaultDisabledUserAgents = Arrays.asList("HttpClient", "Java/", "JIRA-", "JIRA/", "Bitbucket-", "Confluence-", "Confluence/", "FishEye-", "Bamboo-", "Axis/", "Monitoring Agent", "BB10", "BlackBerry", "AtlassianMobileApp", "AtlassianCompanion", "GoEdit").toArray(new String[0]);
    public final String restApiRestrictedFilename = "restrict_rest_api_to_api_tokens.txt";
    final String oldTraditionalLoginEnabledJsdContent = "isTraditionalLoginEnabledJSD=true";
    final String traditionalLoginDisabledJsmContent = "The existence of this file disables traditional username / password login for the Jira Service Management portal. If you need to enable traditional login for JSM, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    final String oldBasicAuthDisabledContent = "isBasicAuthDisabled=true";
    final String basicAuthDisabledContent = "The existence of this file disables Basic Auth with username and password on the REST interface. Now only Kerberos, OAuth, Personal access tokens or Kantega SSO API tokens are valid options for authenticating with the REST API.If you need to enable basic auth, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    final String completeLockdownContent = "completeLockdown=true";
    final String traditionalLoginDisabledFileContent = "The existence of this file disables traditional username / password login. If you need to enable traditional login, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    final String csrfOriginCheckFileContent = "The existence of this file enables CSRF origin checks and it is recommended to keep it due to security concerns. If you need to disable CSRF origin checks, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    final String restApiRestrictedToApiTokenFileContent = "The existence of this file disables certain REST endpoints to only work with API token authentication. This may affect login mechanisms or other Atlassian functionality if not configured carefully. If you need to restore the original functionality, delete this file. No server restart is required. It may take up to one minute for the change to take effect.";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;
    private final PluginLicenseManager licenseManager;
    private final Stats stats;
    private final Cache<String, Object> oneMinuteCache;
    private final Cache<String, Subject> subjectCache;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HomeDirectoryResolver homeDirectoryResolver;

    @Inject
    public KerbConfManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginMetadataManager pluginMetadataManager) {
        this.applicationProperties = applicationProperties;
        this.licenseManager = licenseManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.stats = new Stats();
        this.pluginAccessor = pluginAccessor;
        this.pluginMetadataManager = pluginMetadataManager;
        this.oneMinuteCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        this.subjectCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    private static String nullsafe(Object param) {
        return param == null ? null : param.toString();
    }

    public String getHostProductBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String getPluginRootAbsoluteUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart();
    }

    public String getPluginRootUri() {
        return "/plugins/servlet/" + PluginKey.getPluginKeyBasepart();
    }

    public static Properties getBuildInfo() {
        Properties buildInfo = new Properties();
        try (InputStream is = KerbConfManager.class.getResourceAsStream("/build-info.properties");){
            buildInfo.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buildInfo;
    }

    public boolean isLicenseDefined() {
        return this.licenseManager.getLicense().isDefined();
    }

    public Stats getStats() {
        return this.stats;
    }

    public synchronized void flushKeytabCaches() {
        this.oneMinuteCache.invalidate((Object)KEYTAB_INFO_KEY);
        this.subjectCache.invalidateAll();
    }

    @Deprecated
    public boolean oldIsTraditionalLoginDisabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginDisabled", () -> {
                File disableLoginFile = new File(this.homeDirectoryResolver.getHomeDirectory(), oldDisableLoginFileName);
                return disableLoginFile.exists() && disableLoginFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking username password disable status", e.getCause());
            return false;
        }
    }

    @Deprecated
    public boolean oldIsTraditionalLoginDisabledJSD() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginDisabledJSD", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), oldDisableLoginFileName);
                if (file.exists() && file.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)file);
                    return !fileContents.contains("isTraditionalLoginEnabledJSD=true");
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isTraditionalLoginDisabled status", e.getCause());
            return true;
        }
    }

    @Deprecated
    public boolean oldIsBasicAuthDisabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isBasicAuthDisabled", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), oldDisableLoginFileName);
                if (file.exists() && file.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    return fileContents.contains("isBasicAuthDisabled=true");
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking old isBasicAuthDisabled status", e.getCause());
            return false;
        }
    }

    public boolean isTraditionalLoginPrevented() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginPrevented", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableTraditionalLoginFileName);
                return file.exists() && file.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isTraditionalLoginDisabled status", e.getCause());
            return true;
        }
    }

    public boolean isTraditionalLoginJsmPrevented() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginJsmPrevented", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableJsmLoginFileName);
                return file.exists() && file.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking disable traditional login jsm status", e.getCause());
            return true;
        }
    }

    public boolean isBasicAuthPrevented() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isBasicAuthPrevented", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableBasicAuthFileName);
                return file.exists() && file.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isBasicAuthPrevented status", e.getCause());
            return false;
        }
    }

    private boolean addOrDeleteFile(boolean shouldFileExist, String fileName, String fileContent, String method) {
        String action;
        String string = action = !shouldFileExist ? "create" : "delete";
        if (StringUtils.isBlank((CharSequence)fileName)) {
            this.log.error("No file to write to. Abort " + action + " file for " + method);
        }
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), fileName);
            if (shouldFileExist) {
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])((String)Option.of((Object)fileContent).getOrElse((Object)"")).getBytes(StandardCharsets.UTF_8));
            } else {
                Files.deleteIfExists(Paths.get(file.getPath(), new String[0]));
            }
            this.oneMinuteCache.invalidateAll();
            return true;
        }
        catch (IOException e) {
            this.log.error("Unable to " + action + " file: " + fileName, (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Something failed when trying to" + action + " file: " + fileName, (Throwable)e);
        }
        return false;
    }

    public boolean isCsrfOriginCheckEnabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isCsrfOriginCheckDisabled", () -> {
                File enableCsrfOriginCheckFile = new File(this.homeDirectoryResolver.getHomeDirectory(), enableCsrfOriginCheckFileName);
                return enableCsrfOriginCheckFile.exists() && enableCsrfOriginCheckFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking CSRF origin check status", e.getCause());
            return false;
        }
    }

    public boolean setCsrfOriginCheckEnabled(boolean csrfOriginCheckEnabled) {
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), enableCsrfOriginCheckFileName);
            if (csrfOriginCheckEnabled) {
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])"The existence of this file enables CSRF origin checks and it is recommended to keep it due to security concerns. If you need to disable CSRF origin checks, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.".getBytes(StandardCharsets.UTF_8));
            } else {
                Files.deleteIfExists(Paths.get(file.getPath(), new String[0]));
            }
            this.oneMinuteCache.invalidateAll();
            return true;
        }
        catch (IOException e) {
            String action = csrfOriginCheckEnabled ? "create" : "delete";
            this.log.error("Unable to " + action + " file: enable_csrf_origin_check.txt", (Throwable)e);
        }
        catch (Exception e) {
            String action = csrfOriginCheckEnabled ? "create" : "delete";
            this.log.error("Something failed when trying to" + action + " file: enable_csrf_origin_check.txt", (Throwable)e);
        }
        return false;
    }

    public void flushOneMinuteCache() {
        this.oneMinuteCache.invalidateAll();
    }

    public String getErrorPageMessage() {
        if (this.settings().get(KEYS.ERROR_PAGE_MESSAGE.key) != null) {
            return (String)this.settings().get(KEYS.ERROR_PAGE_MESSAGE.key);
        }
        return this.getDefaultErrorPageMessage();
    }

    public void setErrorPageMessage(String message) {
        this.settings().put(KEYS.ERROR_PAGE_MESSAGE.key, (Object)message);
    }

    public void setNextButtonText(String nextButtonText) {
        this.settings().put(KEYS.NEXT_BUTTON_TEXT.key, (Object)nextButtonText);
    }

    public String getDefaultNextButtonText() {
        return "Next";
    }

    public String getDefaultErrorPageMessage() {
        return "This can occur for a variety of reasons, but most likely you just need to try logging in again. If this fails, please try closing your browser completely before trying again. If the issue persists, please contact your administrator.";
    }

    public Set<String> getRequireLoginExcludedPaths() {
        return ListParseUtils.parseSetFromCommaSeparated((String)this.settings().get(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key));
    }

    public Set<String> getRestExcludedPaths() {
        String excludedPaths = (String)this.settings().get(KEYS.REST_EXCLUDED_PATHS.key);
        if (excludedPaths == null || excludedPaths.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(excludedPaths.split(",")));
    }

    public boolean isWebdavEnabled() {
        return "true".equals(this.settings().get(KEYS.WEBDAV_ENABLED.key));
    }

    public String getCleanupRuleJSONString(CleanupMode cleanupMode) {
        if (cleanupMode.equals((Object)CleanupMode.USERS)) {
            return (String)this.settings().get(KEYS.USER_CLEANUP_RULE.key);
        }
        return (String)this.settings().get(KEYS.JSM_CLEANUP_RULE.key);
    }

    public void setCleanupRuleJSONString(String cleanupRuleJson, CleanupMode cleanupMode) {
        if (cleanupMode.equals((Object)CleanupMode.USERS)) {
            this.settings().put(KEYS.USER_CLEANUP_RULE.key, (Object)cleanupRuleJson);
        } else {
            this.settings().put(KEYS.JSM_CLEANUP_RULE.key, (Object)cleanupRuleJson);
        }
    }

    public void setHomeDirectoryResolver(HomeDirectoryResolver homeDirectoryResolver) {
        this.homeDirectoryResolver = homeDirectoryResolver;
    }

    public boolean isKeytabUploaded() {
        return "true".equals(this.settings().get(KEYS.KEYTAB_UPLOADED.key));
    }

    public File getKeytabFile() {
        if (this.isKeytabUploaded()) {
            return this.getUploadedKeytabFile();
        }
        String keytabFile = KerbConfManager.nullsafe(this.settings().get(KEYS.KEYTAB_FILE.key));
        return keytabFile == null ? null : new File(keytabFile);
    }

    public String getCrowdAutoAddGroups() {
        return (String)this.settings().get(KEYS.CROWD_AUTO_ADD_GROUPS.key);
    }

    public Map<String, String> getSettings() {
        PluginSettings settings = this.settings();
        HashMap<String, String> result = new HashMap<String, String>();
        for (KEYS keys : KEYS.values()) {
            Object value = settings.get(keys.key);
            if (!(value instanceof String)) continue;
            result.put(keys.key, (String)value);
        }
        return result;
    }

    public void restoreSettings(Properties props) {
        PluginSettings settings = this.settings();
        for (KEYS keys : KEYS.values()) {
            settings.remove(keys.key);
        }
        for (KEYS keys : KEYS.values()) {
            String value = props.getProperty(keys.key);
            if (value == null) continue;
            settings.put(keys.key, (Object)value);
        }
    }

    public synchronized void flushCaches() {
        this.oneMinuteCache.invalidateAll();
        this.flushKeytabCaches();
    }

    PluginSettings settings() {
        PluginSettings settingsForKey;
        String dn = this.applicationProperties.getDisplayName().toLowerCase();
        if ((dn.contains("jira") || dn.contains("confluence")) && KerbConfManager.settingsForKeyHasProperties(settingsForKey = this.pluginSettingsFactory.createSettingsForKey(key))) {
            return settingsForKey;
        }
        return this.pluginSettingsFactory.createGlobalSettings();
    }

    public static boolean settingsForKeyHasProperties(PluginSettings settingsForKey) {
        return settingsForKey.get(KEYS.KEYTAB_UPLOADED.key) != null || settingsForKey.get(KEYS.KEYTAB_FILE.key) != null;
    }

    public PluginLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public String getRemoteIpAddress(HttpServletRequest req) {
        String remoteAddr = req.getRemoteAddr();
        String forwardedFor = req.getHeader("x-forwarded-for");
        if (forwardedFor != null && !forwardedFor.equals(remoteAddr) && this.getPreferredProxyHeader() != null) {
            this.log.trace("Using x-forwarded-for IP address");
            String[] forwardedIps = forwardedFor.split(",");
            return forwardedIps[0].trim();
        }
        return remoteAddr;
    }

    public Object get(KEYS key) {
        return this.settings().get(key.key);
    }

    public void putAndInvalidateCache(KEYS key, Object value) {
        this.settings().put(key.key, value);
        this.oneMinuteCache.invalidateAll();
    }

    public void put(KEYS key, Object value) {
        this.settings().put(key.key, value);
    }

    public void removeUpdateFailures() {
        this.settings().remove(KEYS.CONFIG_UPDATE_FAILURES.key);
    }

    public PluginSettingsFactory getPluginSettingsFactory() {
        return this.pluginSettingsFactory;
    }

    public String getPreferredProxyHeader() {
        return (String)this.settings().get(KEYS.PREFERRED_PROXY_HEADER.key);
    }

    public boolean isSSOEnabledForUserAvatar() {
        return "true".equals(this.settings().get(KEYS.SSO_ENABLED_FOR_USER_AVATAR.key));
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public void resetConfiguration() {
        PluginSettings settings = this.settings();
        for (KEYS key : KEYS.values()) {
            settings.remove(key.key);
        }
    }

    private File getUploadedKeytabFile() {
        return new File(this.homeDirectoryResolver.getHomeDirectory(), "kerberos.keytab");
    }

    public boolean isJsmInstalled() {
        if ("JIRA".equals(this.applicationProperties.getDisplayName())) {
            for (Plugin plugin : this.pluginAccessor.getPlugins()) {
                String key = plugin.getKey();
                if (key == null || !key.startsWith("com.atlassian.servicedesk")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isKerberosJsmEnabled() {
        Object kerberosJsmEnabled = this.settings().get(KEYS.KERBEROS_JSM_ENABLED.key);
        return "true".equals(kerberosJsmEnabled) || kerberosJsmEnabled == null;
    }

    public boolean isLicenseExpiryNotificationsSnoozed() {
        try {
            String snoozeTimestamp = (String)this.settings().get(KEYS.LICENSE_EXPIRY_NOTIFICATIONS_SNOOZE.key);
            if (snoozeTimestamp != null) {
                return DateTime.now().isBefore((ReadableInstant)new DateTime((Object)snoozeTimestamp));
            }
        }
        catch (Exception e) {
            this.log.warn("Exception while checking if license expiry notifications are snoozed:", (Throwable)e);
        }
        return false;
    }

    public void setLicenseExpiryNotificationsSnooze(DateTime timestamp) {
        if (!this.isLicenseExpiryNotificationsSnoozed()) {
            this.settings().put(KEYS.LICENSE_EXPIRY_NOTIFICATIONS_SNOOZE.key, (Object)timestamp.toString());
        }
    }

    public Option<Version> getSavedKssoConfigVersion() {
        return Option.of((Object)((String)this.settings().get(KEYS.KSSO_CONFIG_VERSION.key))).map(Version::new);
    }

    public static Option<Version> getRunningKssoVersion() {
        return Option.of((Object)KerbConfManager.getBuildInfo()).map(buildInfo -> buildInfo.getProperty("build.version")).map(Version::new);
    }

    public void setKssoConfigVersion(Version version) {
        if (version != null && StringUtils.isNotBlank((CharSequence)version.stringValue)) {
            this.log.debug("Setting KSSO config version from {} to {}", this.getSavedKssoConfigVersion().map(Version::stringValue).getOrElse((Object)"<unknown>"), (Object)version.stringValue);
            this.settings().put(KEYS.KSSO_CONFIG_VERSION.key, (Object)version.stringValue);
        }
    }

    public void darkFeatureRemoveKssoConfigVersion() {
        this.log.debug("Dark feature: remove the KSSO config version {} ", this.getSavedKssoConfigVersion().map(Version::stringValue).getOrElse((Object)"<unknown>"));
        this.settings().remove(KEYS.KSSO_CONFIG_VERSION.key);
    }

    public void updateKssoVersionInConfig() {
        KerbConfManager.getRunningKssoVersion().peek(this::setKssoConfigVersion);
    }

    public boolean isAnySettingsConfigured() {
        return List.of((Object[])KEYS.values()).exists(key -> Option.of((Object)this.settings().get(key.key)).isDefined());
    }

    public boolean hasKerberosFolder() {
        return Files.exists(this.getHomeDirectoryResolver().getHomeDirectory().toPath(), new LinkOption[0]);
    }

    public boolean isUserdetailsInCommentsEnabled() {
        Object kerberosKnowledgeBaseEnabled = this.settings().get(KEYS.USER_DETAILS_IN_COMMENTS_ENABLED.key);
        return "true".equals(kerberosKnowledgeBaseEnabled);
    }

    public HomeDirectoryResolver getHomeDirectoryResolver() {
        return this.homeDirectoryResolver;
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        JSONArray installedPlugins = new JSONArray((Collection)this.pluginAccessor.getPlugins().stream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).filter(plugin -> !List.of((Object[])new String[]{"Atlassian", "Atlassian Community", "Atlassian Software Systems", "Atlassian Software Systems Pty Ltd", "OSGi Alliance", "The Apache Software Foundation"}).contains((Object)plugin.getPluginInformation().getVendorName())).map(plugin -> new JSONObject((Map)io.vavr.collection.HashMap.of((Object)"key", (Object)plugin.getKey(), (Object)"name", (Object)plugin.getName(), (Object)"version", (Object)plugin.getPluginInformation().getVersion(), (Object)"vendor", (Object)plugin.getPluginInformation().getVendorName(), (Object)"pluginState", (Object)plugin.getPluginState()).toJavaMap())).collect(Collectors.toList()));
        JSONObject licenseJson = new JSONObject();
        licenseJson.put("isActive", this.licenseManager.getLicense().map(PluginLicense::isActive).getOrElse((Object)false));
        licenseJson.put("isAutoRenewal", this.licenseManager.getLicense().map(PluginLicense::isAutoRenewal).getOrElse((Object)false));
        licenseJson.put("isEmbeddedWithinHostLicense", this.licenseManager.getLicense().map(PluginLicense::isEmbeddedWithinHostLicense).getOrElse((Object)false));
        licenseJson.put("isEnterprise", this.licenseManager.getLicense().map(PluginLicense::isEnterprise).getOrElse((Object)false));
        licenseJson.put("isEvaluation", this.licenseManager.getLicense().map(PluginLicense::isEvaluation).getOrElse((Object)false));
        licenseJson.put("isMaintenanceExpired", this.licenseManager.getLicense().map(PluginLicense::isMaintenanceExpired).getOrElse((Object)false));
        licenseJson.put("isSubscription", this.licenseManager.getLicense().map(PluginLicense::isSubscription).getOrElse((Object)false));
        licenseJson.put("isUnlimitedEdition", this.licenseManager.getLicense().map(PluginLicense::isUnlimitedEdition).getOrElse((Object)false));
        licenseJson.put("isValid", this.licenseManager.getLicense().map(PluginLicense::isValid).getOrElse((Object)false));
        licenseJson.put("isUnlimitedNumberOfUsers", this.licenseManager.getLicense().map(PluginLicense::isUnlimitedNumberOfUsers).getOrElse((Object)false));
        licenseJson.put("error", this.licenseManager.getLicense().flatMap(PluginLicense::getError).map(Enum::name).getOrElse((Object)""));
        licenseJson.put("organization", this.licenseManager.getLicense().map(PluginLicense::getOrganization).map(Organization::getName).getOrElse((Object)""));
        licenseJson.put("partner", this.licenseManager.getLicense().flatMap(PluginLicense::getPartner).map(Organization::getName).getOrElse((Object)""));
        licenseJson.put("maxNumberOfUsers", this.licenseManager.getLicense().flatMap(PluginLicense::getMaximumNumberOfUsers).getOrElse((Object)0));
        JSONObject statsJson = new JSONObject();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        statsJson.put("attempts", this.stats.getAttempts());
        statsJson.put("authFailed", this.stats.getAuthFailed());
        statsJson.put("failedDecodingToken", this.stats.getFailedDecodingToken());
        statsJson.put("failedParsingToken", this.stats.getFailedParsingToken());
        statsJson.put("kerberosLockout", (Object)this.stats.getKerberosLockout());
        statsJson.put("lacksPermission", this.stats.getLacksPermission());
        statsJson.put("lacksRequiredGroup", this.stats.getLacksRequiredGroup());
        statsJson.put("missingUsers", this.stats.getMissingUsers());
        statsJson.put("since", (Object)dateFormat.format(this.stats.getSince().getTime()));
        statsJson.put("successes", this.stats.getSuccesses());
        statsJson.put("wrongTokenBasic", this.stats.getWrongTokenBasic());
        statsJson.put("wrongTokenNotKerberos", this.stats.getWrongTokenNotKerberos());
        statsJson.put("wrongTokenNotNegotiate", this.stats.getWrongTokenNotNegotiate());
        statsJson.put("wrongTokenNtlm", this.stats.getWrongTokenNtlm());
        JSONObject settingsJson = new JSONObject();
        Try.run(() -> List.of((Object[])KEYS.values()).forEach(key -> settingsJson.put(key.name(), this.settings().get(key.key)))).onFailure(throwable -> this.log.debug("Could not provide settings for json: ", throwable));
        settingsJson.put("isTraditionalLoginPrevented", this.isTraditionalLoginPrevented());
        settingsJson.put("isTraditionalLoginJsmPrevented", this.isTraditionalLoginJsmPrevented());
        settingsJson.put("isBasicAuthPrevented", this.isBasicAuthPrevented());
        settingsJson.put("isCsrfOriginCheckEnabled", this.isCsrfOriginCheckEnabled());
        json.put("stats", (Object)statsJson);
        json.put("license", (Object)licenseJson);
        json.put("installedPlugins", (Object)installedPlugins);
        json.put("settings", (Object)settingsJson);
        return json;
    }

    public static enum KEYS {
        ADDITIONAL_USER_SUFFIX("additionalUserSuffix"),
        REGEX_LOOKUP("regexLookup"),
        REGEX_REPLACEMENT("regexReplacement"),
        REGEX_LOOKUP_ENABLED("regexLookupEnabled"),
        ONLY_REGEX_TRANSFORMATION_LOOKUP("onlyRegexTransformationLookup"),
        CROWD_AUTO_ADD_GROUPS("crowdAutoAddGroups"),
        LEGACY_GLOBAL_IP_BLOCKEDLIST("ipblacklist"),
        LEGACY_GLOBAL_IP_UNBLOCKEDLIST("ipwhitelist"),
        GLOBAL_IP_BLOCKEDLIST("version5ipBlockedlist"),
        GLOBAL_IP_UNBLOCKEDLIST("version5ipUnblockedlist"),
        GLOBAL_IP_RESTRICTION_TYPE("iprestrictiontype"),
        LEGACY_REST_IP_BLOCKEDLIST("restipblacklist"),
        LEGACY_REST_IP_UNBLOCKEDLIST("restipwhitelist"),
        REST_IP_BLOCKEDLIST("version5restIpBlockedlist"),
        REST_IP_UNBLOCKEDLIST("version5restIpUnblockedlist"),
        REST_IP_RESTRICTION_TYPE("restiprestrictiontype"),
        CUSTOM_DISABLED_USER_AGENTS("customDisabledUserAgents"),
        IDP_DISABLED_USER_AGENTS("idpDisabledUserAgents"),
        KEYTAB_FILE("keytabFile"),
        PREEMPTIVE_AUTH_EXCLUDED_PATHS("preemptiveAuthExcludedPaths"),
        REST_EXCLUDED_PATHS("RestExcludedPaths"),
        VALID_USER_GROUPS("ValidUserGroups"),
        PREFERRED_PROXY_HEADER("preferredproxyheader"),
        PRINCIPAL("principal"),
        REQUIRED_GROUP("requiredGroup"),
        BITBUCKET_SCM_URLS_DEFAULT("bitbucketScmUrlsDefault"),
        BITBUCKET_SCM_URLS_ENABLED("bitbucketScmUrlsEnabled"),
        BITBUCKET_KERBEROS_SCM_URLS_ENABLED("bitbucketKerberosScmUrlsEnabled"),
        BITBUCKET_SCM_URL_TYPES("bitbucketScmUrlTypes"),
        FAILURE_COLLECTION("failurecollection"),
        KERBEROS_ENABLED("kerberosEnabled"),
        KEYTAB_UPLOADED("uploaded"),
        MANUAL_LOGIN_LOG_ENABLED("manualLoginLogEnabled"),
        REQUIRE_LOGIN_ENABLED("preemptiveAuthEnabled"),
        SEND_TO_LOGIN_ENABLED("sendToLoginEnabled"),
        JIRA_REST_AUTH_ENABLED("jiraRestAuthEnabled"),
        KERBEROS_JSM_ENABLED("jiraKerberosJsmEnabled"),
        KERBEROS_KNOWLEDGEBASE_ENABLED("jiraKerberosKnowledgeBaseEnabled"),
        REST_AUTH_ENABLED("restAuthEnabled"),
        KERBEROS_REST_FROM_BROWSER_ENABLED("kerberosRestRequestFromBrowserEnabled"),
        USERNAME_ATTR_LOOKUP_ENABLED("userNameAttributeLookupEnabled"),
        USER_PRINCIPAL_ATTR_LOOKUP_ENABLED("userPrincipalNameLookupEnabled"),
        WEBDAV_ENABLED("webdavEnabled"),
        SHOW_WELCOME_MESSAGE("showWelcomeMessage"),
        ERROR_PAGE_MESSAGE("errorPageMessage"),
        TRADITIONALLOGINDISABLEDMESSAGE("traditionalLoginDisabledMessage"),
        ALLTRADITIONALLOGINDISABLEDMESSAGE("allTraditionalLoginDisabledMessage"),
        BASIC_AUTH_IP_RESTRICTION_TYPE("basicAuthIpRestrictionType"),
        BASIC_AUTH_IP_BLOCKEDLIST("version5BasicAuthIpBlockedList"),
        BASIC_AUTH_IP_UNBLOCKEDLIST("version5BasicAuthnIpUnblockedList"),
        ALLOW_TRADITIONAL_LOGIN_GROUPS("allowTraditionalLoginGroups"),
        DISALLOW_TRADITIONAL_LOGIN_GROUPS("disallowTraditionalLoginGroups"),
        ALLOW_BASIC_AUTH_GROUPS("allowBasicAuthGroups"),
        DISALLOW_BASIC_AUTH_GROUPS("disallowBasicAuthGroups"),
        SAML_LOGIN_USERNAME_PLACEHOLDER("samlLoginUsernamePlaceholder"),
        USERNAME_FIELD_TEXT("usernameFieldText"),
        NEXT_BUTTON_TEXT("nextButtonText"),
        IDP_LIST_TITLE_TEXT("idpListTitleText"),
        LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST("headerUsernameIpWhitelist"),
        HEADER_USERNAME_IP_UNBLOCKEDLIST("version5headerUsernameIpWhitelist"),
        HEADER_USERNAME_ATTRIBUTE("headerUsernameAttribute"),
        HEADERAUTH_USE_X_FORWARDED_FOR("headerauthUseXForwardedFor"),
        HEADER_EMAIL_ATTRIBUTE("headerEmailAttribute"),
        JSM_SIGNUP_EMAIL_UNBLOCKEDLIST("jsmSignupEmailUnblockedlist"),
        JSM_SIGNUP_FORM_URLPARTS("jsmSignupFormUrlparts"),
        REMEMBERME_COOKIE_ENABLED("remembermeCookieEnabled"),
        API_TOKENS_ENABLED("apiTokensEnabled"),
        USER_API_TOKEN_ENABLED("userApiTokenEnabled"),
        API_TOKEN_USER_PERMISSION("apiTokenUserPermission"),
        API_TOKEN_ALLOWED_USER_GROUPS("apiTokenAllowedUserGroups"),
        LEGACY_API_TOKEN_IP_BLOCKEDLIST("apiTokenIpBlacklist"),
        LEGACY_API_TOKEN_IP_UNBLOCKEDLIST("apiTokenIpWhitelist"),
        API_TOKEN_IP_BLOCKEDLIST("version5ApiTokenIpBlockedList"),
        API_TOKEN_IP_UNBLOCKEDLIST("version5ApiTokenIpUnblockedList"),
        API_TOKEN_IP_RESTRICTION_TYPE("apiTokenIpRestrictionType"),
        API_TOKEN_USER_MAX_TIME_RESTRICTION("apiTokensUserMaxTimeRestriction"),
        SSO_ENABLED_FOR_USER_AVATAR("SSOEnabledForUserAvatar"),
        KSSO_CONFIG_VERSION("kssoVersion"),
        LOCKED_REST_API_ERROR_PAGE_MESSAGE("lockedRestApiErrorPageMessage"),
        USER_DETAILS_IN_COMMENTS_ENABLED("userdetailsInComments"),
        ALLOW_KERBEROS_LOGIN_GROUPS("allowKerberosLoginGroups"),
        DISALLOW_KERBEROS_LOGIN_GROUPS("disallowKerberosLoginGroups"),
        API_TOKEN_ACCESS_URLS("apiTokenAccessUrls"),
        FORCED_SSO_URLS("forcedSsoUrls"),
        CONFIG_UPDATE_FAILURES("upgradeFailures"),
        MS_TEAMS_AUTHENTICATION_ENABLED("msTeamsAuthenticationEnabled"),
        MS_TEAMS_SECURITY_HEADERS_ENABLED("msTeamsSecurityHeadersEnabled"),
        SECURITY_HEADER_ALLOWED_HOST_NAMES("securityHeaderAllowedHostNames"),
        MS_TEAMS_CLIENT_ID("msTeamsClientId"),
        MS_TEAMS_SECRET("msTeamsSecret"),
        USER_CLEANUP_RULE("userCleanupRule"),
        JSM_CLEANUP_RULE("jsmCleanupRule"),
        LDAP_FILTER_ENCODING("ldapFilterEncoding"),
        LICENSE_EXPIRY_NOTIFICATIONS_SNOOZE("licenseExpiryNotificationsSnooze"),
        SEND_TO_DASHBOARD_AFTER_LOGIN("sendToDashboardAfterLogin"),
        SHOULD_HIDE_USERNAME_FIELD("shouldHideUsernameField");

        public final String key;

        private KEYS(String key) {
            this.key = key;
        }
    }

    public static enum IpRestrictionType {
        UNRESTRICTED("UNRESTRICTED"),
        UNBLOCKEDLIST("WHITELIST"),
        BLOCKEDLIST("BLACKLIST");

        private final String alias;

        private IpRestrictionType(String alias) {
            this.alias = alias;
        }

        public static IpRestrictionType getValueByNameOrAlias(String name) {
            return Arrays.stream(IpRestrictionType.values()).filter(m -> m.name().equals(name) || m.alias.equals(name)).findAny().orElseThrow(IllegalArgumentException::new);
        }

        public String stringValue() {
            switch (this) {
                case UNBLOCKEDLIST: {
                    return "Unblocked list";
                }
                case BLOCKEDLIST: {
                    return "Blocked list";
                }
                case UNRESTRICTED: {
                    return "Unrestricted";
                }
            }
            throw new IllegalArgumentException("Bad type");
        }
    }
}

