/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.v1;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupModeJson;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="reset-execute-status")
@PublicApi
public class ResetExecuteStatus {
    private static final Logger log = LoggerFactory.getLogger(ResetExecuteStatus.class);
    UserManager userManager;
    CleanupHostApp<UserCleanupResultV1> hostApp;
    JsonWrapper jsonWrapper;

    @Inject
    public ResetExecuteStatus(@ComponentImport UserManager userManager, CleanupHostAppFactoryV1 hostAppFactory, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.jsonWrapper = jsonWrapper;
    }

    private CleanupStatus getExecuteStatus(CleanupMode cleanupMode) {
        if (cleanupMode.equals((Object)CleanupMode.USERS)) {
            return this.hostApp.getUserCleanupExecuteStatus();
        }
        return this.hostApp.getJsmCleanupExecuteStatus();
    }

    private void resetExecuteStatus(CleanupMode cleanupMode) {
        if (cleanupMode.equals((Object)CleanupMode.USERS)) {
            this.hostApp.setUserCleanupExecuteStatus(CleanupStatus.NOT_RUN);
        } else {
            this.hostApp.setJsmCleanupExecuteStatus(CleanupStatus.NOT_RUN);
        }
    }

    private Response run(UserProfile userProfile, UserManager userManager, CleanupModeJson cleanupModeJson) {
        CleanupMode cleanupMode = cleanupModeJson.getCleanupMode();
        if (!userManager.isSystemAdmin(userProfile.getUserKey())) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
        }
        CleanupStatus cleanupExecuteStatus = this.getExecuteStatus(cleanupMode);
        if (cleanupExecuteStatus != CleanupStatus.NOT_RUN) {
            this.resetExecuteStatus(cleanupMode);
        }
        return Response.ok().build();
    }

    @POST
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, CleanupModeJson cleanupModeJson) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, cleanupModeJson)).onFailure(e -> log.error("Encountered an exception while attempting to reset cleanup execution status. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

