/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup.v1;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupMeta;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="get-cleanup-meta")
@PublicApi
public class GetCleanupMeta {
    private static final Logger log = LoggerFactory.getLogger(GetCleanupMeta.class);
    UserManager userManager;
    CleanupHostApp hostApp;
    JsonWrapper jsonWrapper;

    @Inject
    public GetCleanupMeta(@ComponentImport UserManager userManager, CleanupHostAppFactoryV1 hostAppFactory, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.jsonWrapper = jsonWrapper;
    }

    private Response run(UserProfile userProfile, UserManager userManager) {
        if (userManager.isSystemAdmin(userProfile.getUserKey())) {
            String[] groupsList = (String[])this.hostApp.getAllGroups().stream().map(Group::getName).toArray(String[]::new);
            String[] writableDirectoriesList = (String[])this.hostApp.getWritableUserDirectories().stream().map(Directory::getName).toArray(String[]::new);
            String[] allDirectoriesList = (String[])this.hostApp.getCrowdDirectoryService().findAllDirectories().stream().map(Directory::getName).toArray(String[]::new);
            CleanupMeta meta = new CleanupMeta(groupsList, allDirectoriesList, writableDirectoriesList);
            return (Response)this.jsonWrapper.tryBuildJsonString(meta).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
        }
        return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager)).onFailure(e -> log.error("Encountered an exception while attempting to GET cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

