/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.backup;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.backup.BackupInfo;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.CleanupHostAppFactoryV1;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackupService {
    public static final String BACKUP_DIR = "SNAPSHOT/";
    public static final String PLUGIN_SETTINGS_PROPERTIES = "SNAPSHOT/plugin-settings.properties";
    public static final String BACKUP_PROPERTIES = "SNAPSHOT/snapshot.properties";
    public static final String SCIM_DIR = "SNAPSHOT/scim/";
    public static final String SCIM_DIRECTORIES_FILE = "SNAPSHOT/scim/scim-directories.json";
    private final Logger log = LoggerFactory.getLogger(BackupService.class);
    private final CleanupHostApp hostApp;
    private final KerbConfManager kerbConfManager;
    private final ApplicationProperties applicationProperties;
    private final JsonWrapper jsonWrapper;

    @Inject
    public BackupService(@ComponentImport ApplicationProperties applicationProperties, CleanupHostAppFactoryV1 hostAppFactory, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        this.hostApp = hostAppFactory.getInstance();
        this.kerbConfManager = kerbConfManager;
        this.applicationProperties = applicationProperties;
        this.jsonWrapper = jsonWrapper;
    }

    public void restoreFromFile(File backupFile, boolean makeBackup) {
        if (makeBackup) {
            File file = this.createBackup("Before restore of " + backupFile.getName());
        }
        File homeDirectory = this.hostApp.getHomeDirectory();
        File unpackDir = new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_restore");
        File oldHomeDir = new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_oldhome");
        try (ZipInputStream in = new ZipInputStream(Files.newInputStream(backupFile.toPath(), new OpenOption[0]));){
            ZipEntry entry = null;
            Properties props = new Properties();
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                if (entry.getName().equals(PLUGIN_SETTINGS_PROPERTIES)) {
                    props.load(in);
                    continue;
                }
                if (entry.getName().startsWith(BACKUP_DIR)) continue;
                File file = new File(unpackDir, entry.getName());
                file.getParentFile().mkdirs();
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            if (oldHomeDir.exists() && oldHomeDir.isDirectory()) {
                FileUtils.deleteDirectory((File)oldHomeDir);
            }
            if (unpackDir.exists() && unpackDir.isDirectory()) {
                if (homeDirectory.exists() && homeDirectory.isDirectory()) {
                    FileUtils.moveDirectory((File)homeDirectory, (File)oldHomeDir);
                }
                FileUtils.moveDirectory((File)unpackDir, (File)homeDirectory);
                if (oldHomeDir.exists() && oldHomeDir.isDirectory()) {
                    FileUtils.deleteDirectory((File)oldHomeDir);
                }
            }
            this.kerbConfManager.restoreSettings(props);
            this.kerbConfManager.flushCaches();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)unpackDir);
            }
            catch (IOException iOException) {}
        }
    }

    public File createBackup(String description) {
        BackupInfo backupInfo = this.getBackupInfo(description);
        final File homeDirectory = this.hostApp.getHomeDirectory();
        File backupsDirectory = this.getBackupsDirectory();
        File tempFile = new File(backupsDirectory, "_backup_zip.tmp");
        tempFile.getParentFile().mkdirs();
        try (final ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));){
            this.writeMetadata(out, backupInfo);
            this.writeDbSettings(out);
            if (homeDirectory.exists()) {
                Files.walkFileTree(homeDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        ZipEntry entry = new ZipEntry(homeDirectory.toPath().relativize(path).toString());
                        out.putNextEntry(entry);
                        Files.copy(path, out);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            this.log.error("Failed to create KSSO backup tempfile: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            File backupFile = new File(tempFile.getParentFile(), this.filename());
            Path backupFilePath = Paths.get(backupFile.getAbsolutePath(), new String[0]);
            Path tempFilePath = Paths.get(tempFile.getAbsolutePath(), new String[0]);
            Files.move(tempFilePath, backupFilePath, StandardCopyOption.REPLACE_EXISTING);
            return backupFile;
        }
        catch (IOException e) {
            this.log.error("Failed to finalize the creation of KSSO backup .zip file: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private BackupInfo getBackupInfo(String description) {
        new PluginKey();
        return new BackupInfo(this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), PluginKey.getVersion(), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE), System.currentTimeMillis(), description, this.filename());
    }

    public String filename() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH_mm_ss");
        return "sso-backup-" + df.format(new Date()) + ".zip";
    }

    private void writeDbSettings(ZipOutputStream out) throws IOException {
        ZipEntry propsFile = new ZipEntry(PLUGIN_SETTINGS_PROPERTIES);
        out.putNextEntry(propsFile);
        Properties props = this.getDbSettings();
        props.store(out, null);
    }

    private void writeMetadata(ZipOutputStream out, BackupInfo backupInfo) throws IOException {
        ZipEntry propsFile = new ZipEntry(BACKUP_PROPERTIES);
        out.putNextEntry(propsFile);
        Properties settings = backupInfo.getProperties();
        settings.store(out, null);
    }

    private Properties getDbSettings() {
        Properties props = new Properties();
        props.putAll(this.kerbConfManager.getSettings());
        return props;
    }

    public File getBackupsDirectory() {
        File homeDirectory = this.hostApp.getHomeDirectory();
        return new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_snapshots");
    }

    public List<BackupInfo> getBackups() {
        File[] files = this.getBackupsDirectory().listFiles(pathname -> pathname.getName().endsWith(".zip"));
        if (files == null) {
            return Collections.emptyList();
        }
        Arrays.sort(files, (o1, o2) -> Long.compare(o2.lastModified(), o1.lastModified()));
        ArrayList<BackupInfo> result = new ArrayList<BackupInfo>();
        for (File file : files) {
            if (!file.canRead()) {
                result.add(new BackupInfo(file.getName(), false));
                continue;
            }
            try (ZipFile zip = new ZipFile(file);){
                ZipEntry metaEntry = zip.getEntry(BACKUP_PROPERTIES);
                ZipEntry settingsEntry = zip.getEntry(PLUGIN_SETTINGS_PROPERTIES);
                if (metaEntry == null || settingsEntry == null) continue;
                Properties props = new Properties();
                props.load(zip.getInputStream(metaEntry));
                BackupInfo info = BackupInfo.fromProperties(props, file.getName());
                result.add(info);
                Properties settings = new Properties();
                settings.load(zip.getInputStream(settingsEntry));
                info.setSettings(settings);
                TreeSet<String> paths = new TreeSet<String>();
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || entry.getName().startsWith(BACKUP_DIR)) continue;
                    paths.add(entry.getName());
                }
                info.getPaths().addAll(paths);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public boolean isBackup(String filename) {
        return io.vavr.collection.List.ofAll(this.getBackups()).find(backupInfo -> backupInfo.getFilename().equals(filename)).isDefined();
    }

    public BackupInfo findBackup(String filename) {
        return (BackupInfo)io.vavr.collection.List.ofAll(this.getBackups()).find(backupInfo -> backupInfo.getFilename().equals(filename)).getOrNull();
    }

    public Option<File> getBackupFile(String filename) {
        return io.vavr.collection.List.ofAll(this.getBackups()).find(backupInfo -> backupInfo.getFilename().equals(filename)).map(backupInfo -> new File(this.getBackupsDirectory(), backupInfo.getFilename()));
    }
}

