/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.usercleanup.v2;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyImpl;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.vavr.Tuple;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectReader;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.CleanupHostApp;
import org.kantega.atlaskerb.hostapp.DefaultCleanupHostApp;
import org.kantega.atlaskerb.hostapp.JiraCleanupHostAppV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupAction;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupResultType;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.PostCleanupAction;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.UnifiedLicenseInfo;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.CleanupRuleDTOV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.RunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserCleanupResultV1;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v1.jsoncreatorclasses.UserSummary;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupLogAttributesV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.CleanupRuleDTOV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserCleanupResultV2;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.v2.jsoncreatorclasses.UserSummaryV2;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.usercleanup.BreakException;
import org.kantega.atlaskerb.usercleanup.CleanupStatus;
import org.kantega.atlaskerb.usercleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.usercleanup.v2.BlockedResourceException;
import org.kantega.atlaskerb.usercleanup.v2.config.model.CleanupSchedulesAoService;
import org.kantega.atlaskerb.utils.CleanupUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.stereotype.Component;

@DependsOn(value={"org.kantega.atlaskerb.hostapp.CleanupHostApp"})
@Component
public class InactiveUserCleanerV2
implements InactiveUserCleaner<UserCleanupResultV2> {
    private static final String USER_CLEANUP_LOCK = "no.kantega.usermanagement.UserCleanupLock";
    private static final String JSM_CLEANUP_LOCK = "no.kantega.usermanagement.JsmCleanupLock";
    private static final long LOCK_ACQUIRE_TIMEOUT = TimeUnit.HOURS.toMillis(2L);
    private final Cache<String, List<UserCleanupResultV2>> userCleanupResultsCache;
    private final Cache<String, UserCleanupResultV2> cleanupLogCache;
    private static final Logger log = LoggerFactory.getLogger(InactiveUserCleanerV2.class);
    public static final CleanupResultType[] CLEANUP_RESULT_TYPES = new CleanupResultType[]{CleanupResultType.DRY, CleanupResultType.DRY_SIMULATED_DATE, CleanupResultType.LIVE};
    final JsonWrapper jsonWrapper;
    final KerbConfManager kerbConfManager;
    final ClusterLockService clusterLockService;
    final CrowdService crowdService;
    final CrowdDirectoryService crowdDirectoryService;
    private CleanupHostApp<UserCleanupResultV2> hostApp;
    private final AtomicReference<String> lastUserCleanupRunId;
    private final AtomicReference<String> lastJsmCleanupRunId;
    private final ExecutorService workers;
    private final CleanupSchedulesAoService cleanupSchedulesAoService;
    private DirectoryManager directoryManager;
    private final TransactionTemplate transactionTemplate;

    public CleanupHostApp<UserCleanupResultV2> getHostApp() {
        return this.hostApp;
    }

    @Inject
    public InactiveUserCleanerV2(@ComponentImport ClusterLockService clusterLockService, @ComponentImport CrowdService crowdService, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport CacheManager cacheManager, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper, CleanupSchedulesAoService cleanupSchedulesAoService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.clusterLockService = clusterLockService;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.kerbConfManager = kerbConfManager;
        this.jsonWrapper = jsonWrapper;
        this.cleanupSchedulesAoService = cleanupSchedulesAoService;
        this.lastUserCleanupRunId = new AtomicReference<String>("");
        this.lastJsmCleanupRunId = new AtomicReference<String>("");
        this.workers = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("User-Cleanup-%d").build());
        this.userCleanupResultsCache = cacheManager.getCache("userCleanupResultsCache");
        this.cleanupLogCache = cacheManager.getCache("KSSOcleanupLogCache");
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public ExecutorService getWorkers() {
        return this.workers;
    }

    @Autowired
    public void setHostApp(CleanupHostApp<UserCleanupResultV2> cleanupHostApp) {
        this.hostApp = cleanupHostApp;
        this.directoryManager = this.hostApp.getDirectoryManager();
    }

    @Override
    @Deprecated
    public CleanupStatus getUserCleanupExecuteStatus() {
        return CleanupStatus.NOT_RUN;
    }

    @Override
    @Deprecated
    public CleanupStatus getJsmCleanupExecuteStatus() {
        return CleanupStatus.NOT_RUN;
    }

    @Override
    @Deprecated
    public void setUserCleanupExecuteStatus(CleanupStatus status) {
    }

    @Override
    @Deprecated
    public void setJsmCleanupExecuteStatus(CleanupStatus status) {
    }

    @Override
    public String getUserCleanupLastRunId() {
        return this.lastUserCleanupRunId.get();
    }

    @Override
    public String getJsmCleanupLastRunId() {
        return this.lastJsmCleanupRunId.get();
    }

    @Override
    public void setUserCleanupLastRunId(String status) {
        this.lastUserCleanupRunId.set(status);
    }

    @Override
    public void setJsmCleanupLastRunId(String status) {
        this.lastJsmCleanupRunId.set(status);
    }

    @Override
    public UserCleanupResultV2 doUserCleanup(String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV1 cleanupRule, SearchRestriction searchRestriction, DateTime inactivityCutoffTimestamp, DateTime expiryDate, String dryRunString, String runId) {
        throw new UnsupportedOperationException("Method not implemented, only for version 1");
    }

    @Override
    public UserCleanupResultV2 doJsmLicenseCleanup(String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV1 cleanupRule, DateTime inactivityCutoffTimestamp, SearchRestriction searchRestriction, String dryRunString, String runId) throws ConfigurationException {
        throw new UnsupportedOperationException("Method not implemented, only for version 1");
    }

    @Override
    public UserCleanupResultV2 cleanUsers(String currentUserName, RunAttributes runAttributes, DateTime runTimestamp, String runId) {
        throw new UnsupportedOperationException("Method not implemented, only for version 1");
    }

    private List<CleanupRuleDTOV2> getCleanupRules() throws ConfigurationException, IOException {
        List<CleanupRuleDTOV2> cleanupRules = this.cleanupSchedulesAoService.getScheduledCleanupRules();
        if (cleanupRules == null) {
            log.warn("User cleanup: Could not find CleanupRule. Skipping user cleanup");
            throw new ConfigurationException("Could not find CleanupRule. Skipping user cleanup");
        }
        return cleanupRules;
    }

    private DateTime getInactivityCutoffTimestamp(CleanupRuleDTOV2 cleanupRule, RunAttributes runAttributes, DateTime runTimestamp) throws ConfigurationException {
        DateTime inactivityCutoffTimestamp;
        int daysInactiveThreshold = cleanupRule.getDaysInactiveThreshold();
        if (daysInactiveThreshold < 0) {
            log.warn("User cleanup: Invalid daysInactiveThreshold value");
            throw new ConfigurationException("Invalid daysInactiveThreshold value");
        }
        if (!(daysInactiveThreshold != 0 || CleanupAction.LIST.equals((Object)cleanupRule.getCleanupAction()) || PostCleanupAction.COPY_TO_DIR.equals((Object)cleanupRule.getPostCleanupAction()) || PostCleanupAction.ADD_TO_GROUP.equals((Object)cleanupRule.getPostCleanupAction()))) {
            log.warn("User cleanup: Invalid daysInactiveThreshold value");
            throw new ConfigurationException("Invalid daysInactiveThreshold value, 0 can only be used for listing users or copying to directory or adding to group");
        }
        if (runAttributes != null && runAttributes.isDryRun() && runAttributes.isSimulateCronDate()) {
            if (cleanupRule.getCronAttributes() != null && cleanupRule.getCronAttributes().getCronSpringSchedule() != null) {
                CronSequenceGenerator generator = new CronSequenceGenerator(cleanupRule.getCronAttributes().getCronSpringSchedule());
                Date nextExecutionDate = generator.next(new Date());
                inactivityCutoffTimestamp = new DateTime((Object)nextExecutionDate);
            } else {
                inactivityCutoffTimestamp = runTimestamp;
            }
        } else {
            inactivityCutoffTimestamp = runTimestamp;
        }
        return inactivityCutoffTimestamp;
    }

    private SearchRestriction getUserActivitySearchRestriction(CleanupMode cleanupMode, DateTime expiryDate) {
        PropertyRestriction activePartialSearchRestriction = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)Boolean.TRUE);
        PropertyRestriction createdDateOlderThanThresholdRestriction = Restriction.on((Property)UserTermKeys.CREATED_DATE).lessThan((Object)expiryDate.toDate());
        PropertyRestriction jsmEmailRestriction = Restriction.on((Property)new PropertyImpl("local.servicedesk.external.email", String.class)).exactlyMatching((Object)"true");
        PropertyRestriction jsmSignuplRestriction = Restriction.on((Property)new PropertyImpl("local.servicedesk.external.signup", String.class)).exactlyMatching((Object)"true");
        PropertyRestriction jsmExternalRestriction = Restriction.on((Property)new PropertyImpl("local.servicedesk.external", String.class)).exactlyMatching((Object)"true");
        BooleanRestrictionImpl lastLoginRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{Restriction.on((Property)new PropertyImpl(this.hostApp.getLastLoginParameter(), String.class)).isNull(), Restriction.on((Property)new PropertyImpl(this.hostApp.getLastLoginParameter(), String.class)).lessThan((Object)String.format("%013d", expiryDate.getMillis()))});
        switch (cleanupMode) {
            case JSM: {
                return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{activePartialSearchRestriction, createdDateOlderThanThresholdRestriction});
            }
            case JSMEMAIL: {
                return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{activePartialSearchRestriction, createdDateOlderThanThresholdRestriction, jsmEmailRestriction});
            }
            case JSMSIGNUP: {
                return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{activePartialSearchRestriction, createdDateOlderThanThresholdRestriction, jsmSignuplRestriction});
            }
            case JSMEXTERNAL: {
                return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{activePartialSearchRestriction, createdDateOlderThanThresholdRestriction, jsmExternalRestriction});
            }
        }
        return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{activePartialSearchRestriction, createdDateOlderThanThresholdRestriction, lastLoginRestriction});
    }

    public void controlCleanupConfiguration(CleanupRuleDTOV2 cleanupRule, RunAttributes runAttributes, boolean isRemoveFromGroupAction) throws ConfigurationException {
        User user;
        String groupsToRemove = String.join((CharSequence)",", cleanupRule.getGroupsToRemove());
        if (isRemoveFromGroupAction && groupsToRemove.isEmpty()) {
            log.warn("User cleanup: CleanupRule was not configured. Missing groupToRemove value. Skipping user cleanup");
            throw new ConfigurationException("CleanupRule was not configured. Missing groupToRemove value.");
        }
        if (!(cleanupRule.getChangedByUsername() == null || (user = this.crowdService.getUser(cleanupRule.getChangedByUsername())) != null && user.isActive())) {
            log.error("User cleanup rule owner user profile is no longer active or has been deleted. Skipping user cleanup");
            throw new ConfigurationException("User cleanup rule owner user profile is no longer active or has been deleted. Skipping user cleanup");
        }
        log.info("{}User cleanup: Starting user cleanup. {} users not logged in for past {} days", new Object[]{runAttributes != null && runAttributes.isDryRun() ? "Test run: " : "Real run: ", isRemoveFromGroupAction ? "Removing " + groupsToRemove + " from" : "Deactivating", cleanupRule.getDaysInactiveThreshold()});
    }

    @Override
    public List<String> getDirectoryExclusionList(CleanupRuleDTOV1 cleanupRule) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getDirectoryExclusionListV2(CleanupRuleDTOV2 cleanupRule) {
        return cleanupRule.getDirectoriesWhitelist() != null ? Arrays.stream(cleanupRule.getDirectoriesWhitelist()).filter(StringUtils::isNotBlank).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public List<Long> getCleanableDirectoryIds(CleanupRuleDTOV1 cleanupRule, List<String> directoryExclusionList) {
        return Collections.emptyList();
    }

    private boolean getIsRemoveFromGroupAction(RunAttributes runAttributes, CleanupRuleDTOV2 cleanupRule) {
        return (runAttributes == null || !runAttributes.isJsmCleanup()) && cleanupRule.getCleanupAction() == CleanupAction.REMOVE_FROM_GROUP;
    }

    @Override
    public Iterable<User> searchUsersBasedOnEligibleGroupNames(boolean isRemoveFromGroupAction, String[] cleanupEligibleGroupNames, SearchRestriction searchRestriction, int userBatchSize) {
        int batchSize;
        HashSet<User> users = new HashSet<User>();
        int n = batchSize = userBatchSize <= 0 ? -1 : userBatchSize;
        if (cleanupEligibleGroupNames == null || cleanupEligibleGroupNames.length == 0) {
            Iterable usersFromSearch = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).returningAtMost(batchSize));
            usersFromSearch.forEach(users::add);
            return users;
        }
        for (String groupName : cleanupEligibleGroupNames) {
            Iterable usersFromSearch = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(batchSize));
            usersFromSearch.forEach(users::add);
        }
        return users;
    }

    @Override
    public Iterable<User> searchUsersBasedOnRemoveGroup(boolean isRemoveFromGroupAction, Group groupToRemoveGroup, SearchRestriction searchRestriction, int userBatchSize) {
        int batchSize = userBatchSize <= 0 ? -1 : userBatchSize;
        return this.crowdService.search((Query)(isRemoveFromGroupAction && groupToRemoveGroup != null ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).childrenOf(EntityDescriptor.group()).withName(groupToRemoveGroup.getName()).returningAtMost(batchSize) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).returningAtMost(batchSize)));
    }

    public List<String> getDirectoryExclusionList(CleanupRuleDTOV2 cleanupRule) {
        return cleanupRule.getDirectoriesWhitelist() != null ? Arrays.stream(cleanupRule.getDirectoriesWhitelist()).filter(StringUtils::isNotBlank).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public List<Long> getCleanableDirectoryIdsV2(CleanupRuleDTOV2 cleanupRule, List<String> directoryExclusionList) {
        Set<Directory> writableUserDirectories = this.hostApp.getWritableUserDirectories();
        Set<Directory> cleanableDirectories = cleanupRule.getDirectoriesWhitelist() == null ? writableUserDirectories : writableUserDirectories.stream().filter(directory -> directoryExclusionList.stream().noneMatch(directoryName -> directoryName.equals(directory.getName()))).collect(Collectors.toSet());
        return cleanableDirectories.stream().map(Directory::getId).collect(Collectors.toList());
    }

    @Override
    public Set<String> getWhitelistedUserNamesV2(CleanupRuleDTOV2 cleanupRule) {
        String[] groupsWhitelistConfig = cleanupRule.getGroupsWhitelist();
        List groupWhitelist = groupsWhitelistConfig == null ? Collections.emptyList() : Arrays.stream(groupsWhitelistConfig).filter(StringUtils::isNotBlank).map(this.hostApp::getGroup).collect(Collectors.toList());
        Iterable usernamesInWhitelistedGroups = this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames((String[])groupWhitelist.stream().filter(Objects::nonNull).map(Group::getName).toArray(String[]::new)).returningAtMost(-1));
        return StreamSupport.stream(usernamesInWhitelistedGroups.spliterator(), false).collect(Collectors.toSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserCleanupResultV2 getCleanupLogByFilenameId(String filenameId) {
        CleanupResultType[] cleanupResultTypes;
        UserCleanupResultV2 result = null;
        try {
            result = (UserCleanupResultV2)this.cleanupLogCache.get((Object)filenameId);
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            log.error("User cleanup: Failed to get cleanup result from cache: " + filenameId, (Throwable)e);
        }
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(CleanupMode.USERS));
        ObjectReader jsonReader = this.jsonWrapper.objectReader();
        CleanupResultType[] cleanupResultTypeArray = cleanupResultTypes = CLEANUP_RESULT_TYPES;
        int n = cleanupResultTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CleanupResultType logType = cleanupResultTypeArray[n2];
            File directory = this.getDirectoryFromResultType(baseDirectory, logType);
            File[] filesInDir = directory.listFiles();
            List<File> files = Arrays.asList(filesInDir == null ? new File[]{} : filesInDir);
            for (File file : files) {
                if (!file.getName().startsWith(filenameId)) continue;
                try {
                    InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    try {
                        String jsonText = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                        if (jsonText == null || jsonText.length() <= 0) continue;
                        result = (UserCleanupResultV2)jsonReader.readValue(jsonText, UserCleanupResultV2.class);
                        try {
                            this.cleanupLogCache.put((Object)filenameId, (Object)result);
                        }
                        catch (Exception e) {
                            log.error("User cleanup: Failed to put cleanup result in cache: " + filenameId, (Throwable)e);
                        }
                        UserCleanupResultV2 userCleanupResultV2 = result;
                        return userCleanupResultV2;
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    log.warn("User cleanup: Failed to get cleanup result from file: " + file.getName(), (Throwable)e);
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<Long> getExcludedDirectoryIds(List<Directory> allDirectories, List<String> directoryExclusionList) {
        return allDirectories.stream().filter(directory -> directoryExclusionList.contains(directory.getName())).map(Directory::getId).collect(Collectors.toSet());
    }

    @Override
    public void optionallyCleanupUser(String dryRunString, RunAttributes runAttributes, CleanupRuleDTOV1 cleanupRule, ArrayList<UserSummary> affectedUsersList, User user, Directory userDirectory, boolean userInCleanableDirectory) {
    }

    @Override
    public UserCleanupResultV2 createAndSaveUserCleanupResult(RunAttributes runAttributes, ArrayList<UserSummary> affectedUsersList, DateTime inactivityCutoffTimestamp, String runId, CleanupRuleDTOV1 cleanupRule, CleanupMode cleanupMode) {
        return null;
    }

    @Override
    public Set<String> getWhitelistedUserNames(CleanupRuleDTOV1 cleanupRule) {
        return Collections.emptySet();
    }

    private boolean isUserEligibleForCleanup(String currentUserName, User user, CleanupRuleDTOV2 cleanupRule, boolean isNotSimulatedDateOrNotDryRun, boolean isRemoveFromGroupAction, List<Long> cleanableDirectoryIds, Set<Long> excludedDirectoryIds, Set<String> whitelistedUserNames) {
        boolean isCurrentLoggedInUser = currentUserName != null && isNotSimulatedDateOrNotDryRun && currentUserName.equals(user.getName());
        boolean isCurrentCleanupRuleOwner = cleanupRule.getChangedByUsername() != null && cleanupRule.getChangedByUsername().equals(user.getName());
        boolean isUserWhitelisted = whitelistedUserNames.contains(user.getName());
        if (isCurrentCleanupRuleOwner || isCurrentLoggedInUser || !user.isActive() || isUserWhitelisted) {
            return false;
        }
        return isRemoveFromGroupAction && !excludedDirectoryIds.contains(user.getDirectoryId()) || cleanableDirectoryIds.contains(user.getDirectoryId());
    }

    @Override
    public boolean isUserEligibleForJSMCleanup(long userId, List<Long> cleanableDirectoryIds, Set<Long> excludedDirectoryIds) {
        return !excludedDirectoryIds.contains(userId) || cleanableDirectoryIds.contains(userId);
    }

    private Directory getUserDirectory(List<Directory> allDirectories, User user) {
        return allDirectories.stream().filter(directory -> directory.getId().longValue() == user.getDirectoryId()).findFirst().get();
    }

    private ImmutablePair<DateTime, Boolean> getLoginOrCreationDateForUser(User user) {
        UserWithAttributes userWithAttributes = this.hostApp.getUserForCleanup(user);
        String lastLoginMillis = this.hostApp.getLastLoginMillisFromUserWithAttributes(userWithAttributes);
        if (NumberUtils.isCreatable((String)lastLoginMillis)) {
            return new ImmutablePair((Object)new DateTime(Long.parseLong(lastLoginMillis)), (Object)true);
        }
        if (lastLoginMillis == null) {
            return new ImmutablePair((Object)new DateTime((Object)((TimestampedUser)user).getCreatedDate()), (Object)false);
        }
        return null;
    }

    private boolean maybeCleanupUserV2(boolean hasLoggedIn, String dryRunString, User user, DateTime lastLoginOrCreationDate, DateTime expiryDate, CleanupRuleDTOV2 cleanupRule, RunAttributes runAttributes, Directory userDirectory, List<Long> cleanableDirectoryIds, List<UserSummaryV2> affectedUsersList) {
        if (hasLoggedIn) {
            log.debug("{}Checking if user {} should be cleaned. Lastlogin: {}", new Object[]{dryRunString, user.getName(), lastLoginOrCreationDate});
        } else {
            log.debug("{}Checking if user {} should be cleaned. created: {}", new Object[]{dryRunString, user.getName(), lastLoginOrCreationDate});
        }
        if (!this.shouldCleanupUser(lastLoginOrCreationDate, expiryDate)) {
            return false;
        }
        if (hasLoggedIn) {
            log.info("{}User cleanup: Cleaning user {}. Not logged in for more than {} days", new Object[]{dryRunString, user.getName(), cleanupRule.getDaysInactiveThreshold()});
        } else {
            log.info("{}User cleanup: Cleaning user {}. Created more than {} days ago but never logged in.", new Object[]{dryRunString, user.getName(), cleanupRule.getDaysInactiveThreshold()});
        }
        return this.optionallyCleanupUserV2(dryRunString, runAttributes, cleanupRule, affectedUsersList, user, userDirectory, cleanableDirectoryIds.contains(user.getDirectoryId()));
    }

    public void processUsers(Iterable<User> users, String currentUserName, CleanupRuleDTOV2 cleanupRule, DateTime inactivityCutoffTimestamp, boolean isNotSimulatedDateOrNotDryRun, boolean isRemoveFromGroupAction, List<Long> cleanableDirectoryIds, Set<Long> excludedDirectoryIds, Set<String> whitelistedUserNames, List<Directory> allDirectories, String dryRunString, DateTime expiryDate, RunAttributes runAttributes, List<UserSummaryV2> affectedUsersList, String directoryNamePrefix, List<String> directoryExclusionList) {
        Directory[] internalDirectoryToMoveUsersTo = new Directory[]{null};
        boolean isMoveToDirAction = InactiveUserCleanerV2.getIsMoveOrCopyToDirectoryAction(cleanupRule);
        if (isMoveToDirAction && !runAttributes.isDryRun()) {
            try {
                String targetDirectoryTemplate = cleanupRule.getTargetDirectoryTemplate();
                String formattedNameOfDirectory = StringUtils.isEmpty((CharSequence)targetDirectoryTemplate) ? directoryNamePrefix : targetDirectoryTemplate;
                Optional<Directory> existingDirectory = allDirectories.stream().filter(directory -> Objects.equals(directory.getName(), formattedNameOfDirectory)).findFirst();
                internalDirectoryToMoveUsersTo[0] = existingDirectory.isPresent() ? existingDirectory.get() : this.createInternalDirectory(formattedNameOfDirectory);
                this.crowdDirectoryService.setDirectoryPosition(internalDirectoryToMoveUsersTo[0].getId().longValue(), 0);
            }
            catch (DirectoryInstantiationException e) {
                log.error("Failed to create internal directory", (Throwable)e);
            }
        }
        Iterator<User> userIterator = users.iterator();
        int countAnalysedUsers = 0;
        try {
            while (userIterator.hasNext()) {
                User user = userIterator.next();
                long cleanedUserDirectoryId = user.getDirectoryId();
                if (this.isUserEligibleForCleanup(currentUserName, user, cleanupRule, isNotSimulatedDateOrNotDryRun, isRemoveFromGroupAction, cleanableDirectoryIds, excludedDirectoryIds, whitelistedUserNames)) {
                    Directory userDirectory = this.getUserDirectory(allDirectories, user);
                    ImmutablePair<DateTime, Boolean> loginOrCreationDate = this.getLoginOrCreationDateForUser(user);
                    if (loginOrCreationDate != null) {
                        boolean userCleanuedUp = this.maybeCleanupUserV2((Boolean)loginOrCreationDate.getRight(), dryRunString, user, (DateTime)loginOrCreationDate.getLeft(), expiryDate, cleanupRule, runAttributes, userDirectory, cleanableDirectoryIds, affectedUsersList);
                        boolean addToGroupSuccess = false;
                        if (cleanupRule.getPostCleanupAction().equals((Object)PostCleanupAction.ADD_TO_GROUP) && !runAttributes.isDryRun() && userCleanuedUp) {
                            String[] groupsToAdd;
                            for (String group : groupsToAdd = cleanupRule.getGroupsToAdd()) {
                                addToGroupSuccess = this.hostApp.addUserToGroup((Principal)user, group);
                                if (addToGroupSuccess) {
                                    log.debug("User cleanup rule #{}: User {} was added to group {}", new Object[]{cleanupRule.getId(), user.getName(), group});
                                    continue;
                                }
                                log.debug("User cleanup rule #{}: User {} was not added to group {}", new Object[]{cleanupRule.getId(), user.getName(), group});
                            }
                        }
                        if (internalDirectoryToMoveUsersTo[0] != null && !runAttributes.isDryRun() && isMoveToDirAction && userCleanuedUp) {
                            this.copyToNewDirectoryAndDeleteInOld(internalDirectoryToMoveUsersTo[0], "Copying the active user {} to internal directory {}", user, currentUserName, cleanedUserDirectoryId, directoryExclusionList, cleanupRule.getCleanupAction(), cleanupRule);
                        }
                    }
                } else {
                    log.debug("User {} is not eligible for cleanup", (Object)user.getName());
                }
                ++countAnalysedUsers;
            }
            if (internalDirectoryToMoveUsersTo[0] != null) {
                DirectoryImpl directoryForDeactivation;
                if (cleanupRule.getPostCleanupAction().equals((Object)PostCleanupAction.MOVE_TO_DIR_AND_DEACTIVATE)) {
                    directoryForDeactivation = new DirectoryImpl(internalDirectoryToMoveUsersTo[0]);
                    directoryForDeactivation.setActive(false);
                    this.crowdDirectoryService.updateDirectory((Directory)directoryForDeactivation);
                }
                if (cleanupRule.getPostCleanupAction().equals((Object)PostCleanupAction.MOVE_TO_DIR_AND_DELETE)) {
                    directoryForDeactivation = new DirectoryImpl(internalDirectoryToMoveUsersTo[0]);
                    directoryForDeactivation.setActive(false);
                    this.crowdDirectoryService.updateDirectory((Directory)directoryForDeactivation);
                    this.crowdDirectoryService.removeDirectory(internalDirectoryToMoveUsersTo[0].getId().longValue());
                }
            }
            log.debug("{}Analysed {} users. ", (Object)dryRunString, (Object)countAnalysedUsers);
        }
        catch (BreakException e) {
            log.warn("User cleanup: Cleanup process was cancelled mid run. " + affectedUsersList.size() + " users were affected before cancel. You can find complete list of affected users in the user cleanup log directory");
        }
        catch (DirectoryCurrentlySynchronisingException | DirectoryNotFoundException | OperationFailedException | UserNotFoundException | DirectoryPermissionException ex) {
            log.error("User cleanup: Failed to cleanup users", ex);
        }
    }

    @Override
    public UserCleanupResultV2 doUserCleanupV2(String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV2 cleanupRule, SearchRestriction searchRestriction, DateTime inactivityCutoffTimestamp, DateTime expiryDate, String dryRunString, String runId) throws InterruptedException, BlockedResourceException, ConfigurationException {
        ClusterLock userCleanupLock = this.clusterLockService.getLockForName(USER_CLEANUP_LOCK);
        if (userCleanupLock.tryLock(LOCK_ACQUIRE_TIMEOUT, TimeUnit.MILLISECONDS)) {
            Object object;
            try {
                log.info("User cleanup started for runID {}, job {}, jobRunnerKey {}", new Object[]{runId, cleanupRule.getDisplayName(), cleanupRule.getJobRunnerKey()});
                log.debug("Lock {} acquired for runID {}, jobRunnerKey {}. ", new Object[]{USER_CLEANUP_LOCK, runId, cleanupRule.getJobRunnerKey()});
                boolean isRemoveFromGroupAction = this.getIsRemoveFromGroupAction(runAttributes, cleanupRule);
                this.controlCleanupConfiguration(cleanupRule, runAttributes, isRemoveFromGroupAction);
                Iterable<User> users = this.searchUsersBasedOnEligibleGroupNames(true, cleanupRule.getCleanupEligibleGroups(), searchRestriction, cleanupRule.getMaximumNumberOfUsers());
                List<String> directoryExclusionList = this.getDirectoryExclusionList(cleanupRule);
                List<Long> cleanableDirectoryIds = this.getCleanableDirectoryIdsV2(cleanupRule, directoryExclusionList);
                Set<String> whitelistedUserNames = this.getWhitelistedUserNamesV2(cleanupRule);
                boolean countAnalysedUsers = false;
                log.debug("{} Starting to analyze how many users need to be cleaned.", (Object)dryRunString);
                boolean isNotSimulatedDateOrNotDryRun = runAttributes == null || !runAttributes.isSimulateCronDate();
                List allDirectories = (List)this.transactionTemplate.execute(() -> ((CrowdDirectoryService)this.crowdDirectoryService).findAllDirectories());
                Set<Long> excludedDirectoryIds = this.getExcludedDirectoryIds(allDirectories, directoryExclusionList);
                ArrayList<UserSummaryV2> affectedUsersList = new ArrayList<UserSummaryV2>();
                if (this.hostApp instanceof JiraCleanupHostAppV2 && (cleanupRule.getCleanupMode() == CleanupMode.JSMEMAIL || cleanupRule.getCleanupMode() == CleanupMode.JSMSIGNUP || cleanupRule.getCleanupMode() == CleanupMode.JSMEXTERNAL)) {
                    Iterable<User> usersWithJsmActivity = ((JiraCleanupHostAppV2)this.hostApp).getUsersToJSMCleanNoRoles(currentUserName, cleanupRule.getDaysInactiveThreshold(), users, cleanupRule.getCleanupMode());
                    this.processUsers(usersWithJsmActivity, currentUserName, cleanupRule, inactivityCutoffTimestamp, isNotSimulatedDateOrNotDryRun, isRemoveFromGroupAction, cleanableDirectoryIds, excludedDirectoryIds, whitelistedUserNames, allDirectories, dryRunString, expiryDate, runAttributes, affectedUsersList, "KANTEGA USER CLEANUP for JSM", directoryExclusionList);
                } else {
                    this.processUsers(users, currentUserName, cleanupRule, inactivityCutoffTimestamp, isNotSimulatedDateOrNotDryRun, isRemoveFromGroupAction, cleanableDirectoryIds, excludedDirectoryIds, whitelistedUserNames, allDirectories, dryRunString, expiryDate, runAttributes, affectedUsersList, "KANTEGA USER CLEANUP", directoryExclusionList);
                }
                object = this.createAndSaveUserCleanupResultV2(runAttributes, affectedUsersList, inactivityCutoffTimestamp, runId, cleanupRule, CleanupMode.USERS);
            }
            catch (Exception e) {
                try {
                    log.error("User cleanup: Failed to cleanup users", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    log.info("Done user cleanup for runID {}, job {}, jobRunnerKey {}", new Object[]{runId, cleanupRule.getDisplayName(), cleanupRule.getJobRunnerKey()});
                    log.debug("Lock {} released for runID {}, jobRunnerKey {}", new Object[]{userCleanupLock, runId, cleanupRule.getJobRunnerKey()});
                    userCleanupLock.unlock();
                    throw throwable;
                }
            }
            log.info("Done user cleanup for runID {}, job {}, jobRunnerKey {}", new Object[]{runId, cleanupRule.getDisplayName(), cleanupRule.getJobRunnerKey()});
            log.debug("Lock {} released for runID {}, jobRunnerKey {}", new Object[]{userCleanupLock, runId, cleanupRule.getJobRunnerKey()});
            userCleanupLock.unlock();
            return object;
        }
        log.info("User cleanup: Could not acquire lock {}. Skipping user cleanup", (Object)USER_CLEANUP_LOCK);
        throw new BlockedResourceException(String.format("Could not acquire lock %s for cleanup. Skipping user cleanup", USER_CLEANUP_LOCK));
    }

    private static boolean getIsMoveOrCopyToDirectoryAction(CleanupRuleDTOV2 cleanupRule) {
        return EnumSet.of(PostCleanupAction.MOVE_TO_DIR, PostCleanupAction.MOVE_TO_DIR_AND_DEACTIVATE, PostCleanupAction.MOVE_TO_DIR_AND_DELETE, PostCleanupAction.COPY_TO_DIR).contains((Object)cleanupRule.getPostCleanupAction());
    }

    private void copyToNewDirectoryAndDeleteInOld(Directory internalDirectory, String s, User user, String currentUserName, long cleanedUserDirectoryId, List<String> directoryExclusionList, CleanupAction cleanupAction, CleanupRuleDTOV2 cleanupRule) throws DirectoryNotFoundException, UserNotFoundException, DirectoryPermissionException, OperationFailedException {
        if (internalDirectory != null) {
            log.debug(s, (Object)user.getName(), (Object)internalDirectory.getName());
            try {
                this.migrateUser(cleanedUserDirectoryId, internalDirectory.getId(), currentUserName, user, new AtomicLong(), directoryExclusionList, cleanupAction, cleanupRule);
            }
            catch (Exception e) {
                log.error("Failed to migrate user", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserCleanupResultV2 doJsmLicenseCleanupV2(String currentUserName, RunAttributes runAttributes, CleanupRuleDTOV2 cleanupRule, DateTime inactivityCutoffTimestamp, SearchRestriction searchRestriction, String dryRunString, String runId) throws InterruptedException, BlockedResourceException, ConfigurationException {
        ClusterLock jsmCleanupLock = this.clusterLockService.getLockForName(JSM_CLEANUP_LOCK);
        if (jsmCleanupLock.tryLock(LOCK_ACQUIRE_TIMEOUT, TimeUnit.MILLISECONDS)) {
            try {
                UserCleanupResultV2 userCleanupResultV2 = this.hostApp.jsmCleanupV2(this, currentUserName, runAttributes, cleanupRule, inactivityCutoffTimestamp, searchRestriction, dryRunString, runId);
                return userCleanupResultV2;
            }
            finally {
                jsmCleanupLock.unlock();
            }
        }
        throw new BlockedResourceException("Could not acquire lock for cleanup. Skipping JSM cleanup");
    }

    @Override
    public UserCleanupResultV2 cleanUsersV2(String jobRunnerKey, String currentUserName, RunAttributes runAttributes, DateTime runTimestamp, String runId) throws ConfigurationException, InterruptedException, BlockedResourceException, LicenseException {
        this.hostApp.verifyLicense();
        String dryRunString = runAttributes != null && runAttributes.isDryRun() ? "Test run: " : "Real run: ";
        CleanupRuleDTOV2 cleanupRule = this.cleanupSchedulesAoService.findCleanupRuleByJobRunnerkey(jobRunnerKey);
        DateTime inactivityCutoffTimestamp = this.getInactivityCutoffTimestamp(cleanupRule, runAttributes, runTimestamp);
        DateTime expiryDate = cleanupRule.getDaysInactiveThreshold() == 0 ? inactivityCutoffTimestamp : inactivityCutoffTimestamp.withTimeAtStartOfDay().minusDays(cleanupRule.getDaysInactiveThreshold());
        CleanupMode cleanupMode = cleanupRule.getCleanupMode();
        if (this.isJsmCleanup(runAttributes)) {
            return this.doJsmLicenseCleanupV2(currentUserName, runAttributes, cleanupRule, inactivityCutoffTimestamp, this.getUserActivitySearchRestriction(cleanupMode, expiryDate), dryRunString, runId);
        }
        return this.doUserCleanupV2(currentUserName, runAttributes, cleanupRule, this.getUserActivitySearchRestriction(cleanupMode, expiryDate), inactivityCutoffTimestamp, expiryDate, dryRunString, runId);
    }

    private boolean isJsmCleanup(RunAttributes runAttributes) {
        if (runAttributes == null) {
            return false;
        }
        if (!runAttributes.isJsmCleanup()) {
            return false;
        }
        return this.hostApp.isProductMatch("jira");
    }

    @Override
    public boolean optionallyCleanupUserV2(String dryRunString, RunAttributes runAttributes, CleanupRuleDTOV2 cleanupRule, List<UserSummaryV2> affectedUsersList, User user, Directory userDirectory, boolean userInCleanableDirectory) {
        boolean isDryRun = runAttributes != null && runAttributes.isDryRun();
        boolean isListAction = cleanupRule.getCleanupAction() == CleanupAction.LIST;
        boolean isMoveToDirAction = cleanupRule.getCleanupAction().name().startsWith("MOVE_TO_DIR");
        if (isDryRun || isListAction || isMoveToDirAction) {
            this.addUserToAffectedUsers(dryRunString, user, cleanupRule.getCleanupMode(), String.format("Is dry run: %b, Is list action: %b", isDryRun, isListAction), affectedUsersList);
            return true;
        }
        boolean success = false;
        String cleanupMessage = "";
        ArrayList<String> removedGroupMemberships = new ArrayList<String>();
        ArrayList<String> failedRemoveGroupMemberships = new ArrayList<String>();
        if (cleanupRule.getCleanupMode() == CleanupMode.JSM) {
            success = this.cleanupJsmUser(user);
            cleanupMessage = "Cleaned with JSM user cleanup";
        } else {
            switch (cleanupRule.getCleanupAction()) {
                case REMOVE_FROM_GROUP: {
                    for (String group : cleanupRule.getGroupsToRemove()) {
                        if (this.hostApp.removeUserFromGroup((Principal)user, group)) {
                            removedGroupMemberships.add(group);
                            log.debug("User cleanup rule #{}: User {} was removed from group {}", new Object[]{cleanupRule.getId(), user.getName(), group});
                            continue;
                        }
                        log.debug("User cleanup rule #{}: User {} was not removed from group {}", new Object[]{cleanupRule.getId(), user.getName(), group});
                        log.debug("Is user in cleanable directory: " + userInCleanableDirectory);
                        failedRemoveGroupMemberships.add(group);
                    }
                    log.debug("User cleanup: User {} was removed from {} groups.", (Object)user.getName(), (Object)removedGroupMemberships.size());
                    cleanupMessage = String.format("Removed user from %d groups out of %d.", removedGroupMemberships.size(), cleanupRule.getGroupsToRemove().length);
                    if (!userInCleanableDirectory) {
                        cleanupMessage = cleanupMessage + " User is in read-only directory.";
                        log.warn("User cleanup: User {} to be cleaned is in read-only directory.", (Object)user.getName());
                    }
                    success = !removedGroupMemberships.isEmpty();
                    break;
                }
                case DEACTIVATE: {
                    log.debug("User cleanup: User {} is being deactivated.", (Object)user.getName());
                    success = this.cleanupUser(userDirectory, user, userInCleanableDirectory);
                    cleanupMessage = success ? "Deactivated user" : "Failed to deactivate user";
                }
            }
        }
        String string = cleanupMessage = success ? String.format("[SUCCESS] %s", cleanupMessage) : String.format("[FAILED] %s", cleanupMessage);
        if (removedGroupMemberships.size() != cleanupRule.getGroupsToRemove().length) {
            log.debug("User cleanup: User {} was removed from {} groups out of the configured {}.", new Object[]{user.getName(), removedGroupMemberships.size(), cleanupRule.getGroupsToRemove().length});
        }
        this.addUserToAffectedUsers(dryRunString, user, removedGroupMemberships, failedRemoveGroupMemberships, cleanupRule.getCleanupMode(), cleanupMessage, affectedUsersList);
        return success;
    }

    private boolean cleanupJsmUser(User user) {
        boolean success = true;
        for (Group jsmGroup : this.hostApp.getJSMGroups()) {
            if (!this.hostApp.isUserInGroup(user.getName(), jsmGroup.getName())) continue;
            success = success && this.hostApp.removeUserFromGroup((Principal)user, jsmGroup.getName());
        }
        return success;
    }

    private boolean cleanupUser(Directory userDirectory, User user, boolean userInCleanableDirectory) {
        if (userInCleanableDirectory) {
            return this.deactivateUser(userDirectory, user);
        }
        log.warn("User {} to be deactivated is in read-only directory.", (Object)user.getName());
        return false;
    }

    private void addUserToAffectedUsers(String dryRunString, User user, List<String> removedGroupMemberships, List<String> failedRemoveGroupMemberships, CleanupMode cleanupMode, String cleanupMessage, List<UserSummaryV2> affectedUsersList) {
        log.debug("{}Adding user {} to affected users", (Object)dryRunString, (Object)user.getName());
        String lastLoginMillis = this.hostApp.getLastLoginMillisFromUserWithAttributes(this.hostApp.getUserForCleanup(user));
        DateTime lastLogin = lastLoginMillis == null ? new DateTime((Object)((TimestampedUser)user).getCreatedDate()) : new DateTime(Long.parseLong(lastLoginMillis));
        HashSet userApplicationRoles = new HashSet();
        if (this.hostApp instanceof DefaultCleanupHostApp) {
            Set<String> userApplicationRolesFromUser = ((DefaultCleanupHostApp)this.hostApp).getUserApplicationRoles((Principal)user);
            userApplicationRolesFromUser.stream().forEach(userApplicationRoles::add);
        }
        affectedUsersList.add(new UserSummaryV2(user.getName(), user.getEmailAddress(), lastLogin.toString(), removedGroupMemberships.toArray(new String[0]), failedRemoveGroupMemberships.toArray(new String[0]), userApplicationRoles != null ? userApplicationRoles : Collections.emptySet(), cleanupMode, cleanupMessage));
    }

    private void addUserToAffectedUsers(String dryRunString, User user, CleanupMode cleanupMode, String cleanupMessage, List<UserSummaryV2> affectedUsersList) {
        log.debug("{}Adding user {} to affected users", (Object)dryRunString, (Object)user.getName());
        String lastLoginMillis = this.hostApp.getLastLoginMillisFromUserWithAttributes(this.hostApp.getUserForCleanup(user));
        DateTime lastLogin = lastLoginMillis == null ? new DateTime((Object)((TimestampedUser)user).getCreatedDate()) : new DateTime(Long.parseLong(lastLoginMillis));
        HashSet userApplicationRoles = new HashSet();
        if (this.hostApp instanceof DefaultCleanupHostApp) {
            Set<String> userApplicationRolesFromUser = ((DefaultCleanupHostApp)this.hostApp).getUserApplicationRoles((Principal)user);
            userApplicationRolesFromUser.stream().forEach(userApplicationRoles::add);
        }
        affectedUsersList.add(new UserSummaryV2(user.getName(), user.getEmailAddress(), lastLogin.toString(), new String[]{}, new String[]{}, userApplicationRoles != null ? userApplicationRoles : Collections.emptySet(), cleanupMode, cleanupMessage));
    }

    @Override
    public UserCleanupResultV2 createAndSaveUserCleanupResultV2(RunAttributes runAttributes, List<UserSummaryV2> affectedUsersList, DateTime now, String runId, CleanupRuleDTOV2 cleanupRule, CleanupMode cleanupMode) {
        String name = runAttributes != null && runAttributes.isDryRun() ? "dry-run" : "cleaned-users";
        DateTimeFormatter filenameDtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH-mm-ss'Z'");
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        String filenameId = now.toString(filenameDtf) + "_" + name;
        UnifiedLicenseInfo licenseSize = this.hostApp.getLicenseSize();
        UserCleanupResultV2 result = new UserCleanupResultV2(filenameId, runId, cleanupRule.getJobRunnerKey(), now.toString(dtf), runAttributes != null && runAttributes.isDryRun(), runAttributes != null && runAttributes.isSimulateCronDate(), affectedUsersList.toArray(new UserSummaryV2[0]), cleanupRule.getCleanupAction(), cleanupRule.getGroupsToRemove(), cleanupRule.getCleanupEligibleGroups(), cleanupRule.getDaysInactiveThreshold(), licenseSize.getTotalBillableUsers(), licenseSize.getMaximumNumberOfUsers());
        CleanupResultType logtype = runAttributes != null && runAttributes.isDryRun() ? (runAttributes.isSimulateCronDate() ? CleanupResultType.DRY_SIMULATED_DATE : CleanupResultType.DRY) : CleanupResultType.LIVE;
        try {
            this.saveCleanupLogFile(filenameId, logtype, this.createJsonObjectFromCleanupResultV2(result), cleanupMode);
        }
        catch (Exception e) {
            List<String> usernamesList = Arrays.stream(result.getAffectedUsers()).map(userSummary -> userSummary.getUsername() + ": " + userSummary.getEmail()).collect(Collectors.toList());
            log.warn("User cleanup: Failed to save UserCleanupResults log to file.", (Throwable)e);
            log.warn("User cleanup: The following users where affected by the cleanup operation:");
            usernamesList.forEach(arg_0 -> ((Logger)log).warn(arg_0));
        }
        return result;
    }

    public UserCleanupResultV2[] getCleanupLog(CleanupLogAttributesV2 cleanupLogAttributes) {
        CleanupMode cleanupMode;
        CleanupMode cleanupMode2 = cleanupMode = cleanupLogAttributes.getJsmCleanup() ? CleanupMode.JSM : CleanupMode.USERS;
        CleanupResultType[] cleanupResultTypes = cleanupLogAttributes.getIncludeAllLogs() ? new CleanupResultType[]{CleanupResultType.DRY, CleanupResultType.DRY_SIMULATED_DATE, CleanupResultType.LIVE} : (cleanupLogAttributes.isDryRun() ? (cleanupLogAttributes.isSimulateCronDate() ? new CleanupResultType[]{CleanupResultType.DRY_SIMULATED_DATE} : new CleanupResultType[]{CleanupResultType.DRY}) : new CleanupResultType[]{CleanupResultType.LIVE});
        return this.getUserCleanupResultsFromFilesV2(cleanupResultTypes, cleanupMode);
    }

    public UserCleanupResultV2[] getCleanupLogV2(CleanupLogAttributesV2 cleanupLogAttributes) {
        CleanupMode cleanupMode;
        CleanupMode cleanupMode2 = cleanupMode = cleanupLogAttributes.getJsmCleanup() ? CleanupMode.JSM : CleanupMode.USERS;
        CleanupResultType[] cleanupResultTypes = cleanupLogAttributes.getIncludeAllLogs() ? CLEANUP_RESULT_TYPES : (cleanupLogAttributes.isDryRun() ? (cleanupLogAttributes.isSimulateCronDate() ? new CleanupResultType[]{CleanupResultType.DRY_SIMULATED_DATE} : new CleanupResultType[]{CleanupResultType.DRY}) : new CleanupResultType[]{CleanupResultType.LIVE});
        return this.getUserCleanupResultsFromFilesV2(cleanupResultTypes, cleanupMode);
    }

    public UserCleanupResultV2[] getUserCleanupResultsFromFiles(CleanupResultType[] cleanupResultTypes, CleanupMode cleanupMode) {
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
        ArrayList result = new ArrayList();
        ObjectReader jsonReader = this.jsonWrapper.objectReader();
        List<CleanupResultType> list = Arrays.asList(cleanupResultTypes);
        list.forEach(logType -> {
            File directory = this.getDirectoryFromResultType(baseDirectory, (CleanupResultType)((Object)logType));
            File[] filesInDir = directory.listFiles();
            List<File> files = Arrays.asList(filesInDir == null ? new File[]{} : filesInDir);
            files.forEach(file -> {
                try {
                    UserCleanupResultV2 cleanupResult = (UserCleanupResultV2)jsonReader.readValue(file, UserCleanupResultV2.class);
                    if (cleanupResult != null && cleanupResult.getRunId() != null) {
                        result.add(cleanupResult);
                    }
                }
                catch (IOException e) {
                    log.warn("User cleanup: Failed to get cleanup result from file: " + file.getName(), (Throwable)e);
                }
                catch (Exception e) {
                    log.warn("User cleanup: Failed to get cleanup result from file: " + file.getName(), (Throwable)e);
                }
            });
        });
        return result.stream().sorted(Comparator.comparing(UserCleanupResultV1::getFilenameId)).collect(Collectors.toList()).toArray(result.toArray(new UserCleanupResultV2[0]));
    }

    public UserCleanupResultV2[] getUserCleanupResultsFromFilesV2(CleanupResultType[] cleanupResultTypes, CleanupMode cleanupMode) {
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
        ArrayList result = new ArrayList();
        ObjectReader jsonReader = this.jsonWrapper.objectReader();
        List<CleanupResultType> list = Arrays.asList(cleanupResultTypes);
        list.forEach(logType -> {
            File directory = this.getDirectoryFromResultType(baseDirectory, (CleanupResultType)((Object)logType));
            File[] filesInDir = directory.listFiles();
            List<File> files = Arrays.asList(filesInDir == null ? new File[]{} : filesInDir);
            files.forEach(file -> {
                try {
                    UserCleanupResultV2 cleanupResult = (UserCleanupResultV2)jsonReader.readValue(file, UserCleanupResultV2.class);
                    if (cleanupResult != null && cleanupResult.getRunId() != null) {
                        result.add(cleanupResult);
                    }
                }
                catch (IOException e) {
                    log.warn("User cleanup: Failed to get cleanup result from file: " + file.getName(), (Throwable)e);
                }
                catch (Exception e) {
                    log.warn("User cleanup: Failed to get cleanup result from file: " + file.getName(), (Throwable)e);
                }
            });
        });
        return result.stream().sorted(Comparator.comparing(UserCleanupResultV1::getFilenameId)).collect(Collectors.toList()).toArray(result.toArray(new UserCleanupResultV2[0]));
    }

    @Override
    public File getDirectoryFromResultType(File parentDir, CleanupResultType logType) {
        File directory;
        switch (logType) {
            case DRY: {
                directory = new File(parentDir, "dryRuns");
                break;
            }
            case DRY_SIMULATED_DATE: {
                directory = new File(parentDir, "dryRunsWithSimulatedDate");
                break;
            }
            default: {
                directory = new File(parentDir, "liveCleanupLogs");
            }
        }
        return directory;
    }

    @Override
    public void saveCleanupLogFile(String filenameId, CleanupResultType cleanupResultType, JSONObject jsonData, CleanupMode cleanupMode) throws IOException {
        int maxNofFiles;
        File directory;
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
        boolean isDry = true;
        switch (cleanupResultType) {
            case DRY: {
                directory = new File(baseDirectory, "dryRuns");
                break;
            }
            case DRY_SIMULATED_DATE: {
                directory = new File(baseDirectory, "dryRunsWithSimulatedDate");
                break;
            }
            default: {
                isDry = false;
                directory = new File(baseDirectory, "liveCleanupLogs");
            }
        }
        File[] filesInDir = directory.listFiles();
        int n = maxNofFiles = isDry ? 20 : 20;
        if (filesInDir != null && filesInDir.length >= maxNofFiles) {
            List sortedFiles = Arrays.stream(filesInDir).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
            while (sortedFiles.size() > maxNofFiles - 1 && sortedFiles.size() > 1) {
                this.clearCleanupLogFile(((File)sortedFiles.get(1)).getName(), cleanupResultType, cleanupMode);
                sortedFiles.remove(1);
            }
        }
        File file = new File(directory, filenameId);
        FileUtils.writeStringToFile((File)file, (String)jsonData.toString(), (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public boolean clearCleanupLogFile(String filenameId, CleanupResultType cleanupResultType, CleanupMode cleanupMode) {
        try {
            File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
            File directory = this.getDirectoryFromResultType(baseDirectory, cleanupResultType);
            File fileToDelete = new File(directory, filenameId);
            Path filePath = Paths.get(fileToDelete.getPath(), new String[0]);
            Path parentPathOfDeleteFile = filePath.getParent();
            if (parentPathOfDeleteFile == null || !parentPathOfDeleteFile.equals(Paths.get(directory.getPath(), new String[0]))) {
                SanitizedLogStatement.of(filenameId).andThenLog(id -> log.warn("The file path does not seem to target the correct directory. Bailing deletion of file {}", id));
                return false;
            }
            boolean success = false;
            for (int i = 0; i < 3; ++i) {
                if (Files.deleteIfExists(filePath)) {
                    success = true;
                    break;
                }
                try {
                    FileUtils.writeStringToFile((File)fileToDelete, (String)"", (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    String msg = "User cleanup: Delete of logfile failed, tried to clear file contents instead. Also failed to clear file contents: " + filenameId;
                    log.error(msg, (Throwable)e);
                    continue;
                }
                success = true;
            }
            if (!success) {
                String msg = "User cleanup: Failed to delete file: " + filenameId;
                SanitizedLogStatement.of(msg).andThenLog(m -> log.warn(m));
            }
            return success;
        }
        catch (IOException e) {
            String msg = "User cleanup: Something went wrong trying to delete file: " + filenameId;
            SanitizedLogStatement.of(msg).andThenLog(m -> log.error(m, (Throwable)e));
            return false;
        }
    }

    private JSONObject createJsonObjectFromCleanupResult(UserCleanupResultV1 result) {
        ObjectWriter objectWriter = this.jsonWrapper.objectWriter();
        try {
            String jsonStr = objectWriter.writeValueAsString((Object)result);
            return new JSONObject(jsonStr);
        }
        catch (JsonProcessingException e) {
            return new JSONObject();
        }
    }

    private JSONObject createJsonObjectFromCleanupResultV2(UserCleanupResultV2 result) {
        ObjectWriter objectWriter = this.jsonWrapper.objectWriter();
        try {
            String jsonStr = objectWriter.writeValueAsString((Object)result);
            return new JSONObject(jsonStr);
        }
        catch (JsonProcessingException e) {
            log.error("User cleanup: Failed to create JSON object from UserCleanupResultV2 {}", (Object)result, (Object)e);
            return new JSONObject();
        }
    }

    private boolean shouldCleanupUser(DateTime lastUsed, DateTime expiryDate) {
        return lastUsed.isBefore((ReadableInstant)expiryDate);
    }

    @Override
    public boolean deactivateUser(Directory directory, User user) {
        try {
            this.hostApp.updateUser(directory, user.getName(), user.getDisplayName(), user.getEmailAddress(), false);
            return true;
        }
        catch (Exception e) {
            log.error("User cleanup: Failed to deactivate user " + user.getName(), (Throwable)e);
            return false;
        }
    }

    public void manageUserGroups(User user, List<String> groups, String action) throws Exception {
        if ("add".equalsIgnoreCase(action)) {
            for (String group : groups) {
                if (this.hostApp.isUserInGroup(user.getName(), group) || this.hostApp.addUserToGroup((Principal)user, group)) continue;
                throw new Exception("Failed to add user " + user.getName() + " to group " + group);
            }
        } else if ("remove".equalsIgnoreCase(action)) {
            for (String group : groups) {
                if (!this.hostApp.isUserInGroup(user.getName(), group) || this.hostApp.removeUserFromGroup((Principal)user, group)) continue;
                throw new Exception("Failed to remove user " + user.getName() + " from group " + group);
            }
        } else {
            throw new Exception("Invalid action specified");
        }
    }

    public void activateOrDeactivateUser(User user, String action) throws Exception {
        Directory userDirectory = this.getUserDirectory(user);
        if (userDirectory == null) {
            throw new Exception("Unable to find user directory");
        }
        if ("activate".equalsIgnoreCase(action)) {
            if (!this.activateUser(userDirectory, user)) {
                throw new Exception("Failed to activate user");
            }
        } else if ("deactivate".equalsIgnoreCase(action)) {
            if (!this.deactivateUser(userDirectory, user)) {
                throw new Exception("Failed to deactivate user");
            }
        } else {
            throw new Exception("Invalid action specified");
        }
    }

    private Directory getUserDirectory(User user) {
        Optional<Directory> dirStream = this.hostApp.getCrowdDirectoryService().findAllDirectories().stream().filter(directory -> directory.getId().longValue() == user.getDirectoryId()).findFirst();
        return dirStream.orElse(null);
    }

    private boolean activateUser(Directory userDirectory, User user) {
        try {
            this.hostApp.updateUser(userDirectory, user.getName(), user.getDisplayName(), user.getEmailAddress(), true);
            return true;
        }
        catch (Exception e) {
            log.error("User cleanup: Failed to activate user " + user.getName(), (Throwable)e);
            return false;
        }
    }

    private void migrateUser(long fromDirectoryId, long toDirectoryId, String remoteUser, User user, AtomicLong migratedCount, List<String> directoryExclusionList, CleanupAction action, CleanupRuleDTOV2 cleanupRule) throws Exception {
        if (!user.getName().equalsIgnoreCase(remoteUser)) {
            com.atlassian.crowd.model.user.UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(fromDirectoryId, user.getName());
            PostCleanupAction postCleanupAction = cleanupRule.getPostCleanupAction();
            try {
                UserTemplate newUser = new UserTemplate(user);
                newUser.setDirectoryId(toDirectoryId);
                if (CleanupAction.DEACTIVATE.equals((Object)cleanupRule.getCleanupAction())) {
                    newUser.setActive(false);
                }
                this.directoryManager.addUser(toDirectoryId, newUser, new PasswordCredential(InactiveUserCleanerV2.generatePassword()));
            }
            catch (InvalidUserException e) {
                return;
            }
            Set keys = userWithAttributes.getKeys();
            HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
            for (String key : keys) {
                Set values = userWithAttributes.getValues(key);
                attributes.put(key, values);
            }
            attributes.put("kantega_user_cleanup_migrated_at", Collections.singleton(String.valueOf(new Date().getTime())));
            if (user != null && user instanceof TimestampedUser) {
                try {
                    TimestampedUser bizUser = (TimestampedUser)user;
                    attributes.put("kantega_user_cleanup_org_created_date", Collections.singleton(String.valueOf(bizUser.getCreatedDate().getTime())));
                    attributes.put("kantega_user_cleanup_org_updated_date", Collections.singleton(String.valueOf(bizUser.getUpdatedDate().getTime())));
                }
                catch (Exception bizUser) {
                    // empty catch block
                }
            }
            this.directoryManager.storeUserAttributes(toDirectoryId, user.getName(), attributes);
            MembershipQuery groupQuery = QueryBuilder.queryFor(com.atlassian.crowd.model.group.Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
            List groups = this.directoryManager.searchDirectGroupRelationships(fromDirectoryId, groupQuery);
            for (com.atlassian.crowd.model.group.Group group : groups) {
                try {
                    this.directoryManager.findGroupByName(toDirectoryId, group.getName());
                }
                catch (GroupNotFoundException ex) {
                    GroupTemplate newGroup = new GroupTemplate(group);
                    newGroup.setDirectoryId(toDirectoryId);
                    this.directoryManager.addGroup(toDirectoryId, newGroup);
                }
                this.directoryManager.addUserToGroup(toDirectoryId, user.getName(), group.getName());
                if (postCleanupAction == PostCleanupAction.COPY_TO_DIR) continue;
                this.directoryManager.removeUserFromGroup(fromDirectoryId, user.getName(), group.getName());
            }
            if (postCleanupAction != PostCleanupAction.COPY_TO_DIR) {
                this.directoryManager.removeUser(fromDirectoryId, user.getName());
            }
            List allDirectories = this.crowdDirectoryService.findAllDirectories();
            Set<Long> excludedDirectoryIds = this.getExcludedDirectoryIds(allDirectories, directoryExclusionList);
            if (postCleanupAction != PostCleanupAction.COPY_TO_DIR) {
                for (Directory directory : allDirectories) {
                    long currentIteratedDirectoryId = directory.getId();
                    if (currentIteratedDirectoryId == toDirectoryId || excludedDirectoryIds.contains(currentIteratedDirectoryId)) continue;
                    try {
                        com.atlassian.crowd.model.user.UserWithAttributes userInOtherDirsWithAttributes = this.directoryManager.findUserWithAttributesByName(currentIteratedDirectoryId, user.getName());
                        if (userInOtherDirsWithAttributes == null) continue;
                        this.directoryManager.removeUser(currentIteratedDirectoryId, userInOtherDirsWithAttributes.getName());
                    }
                    catch (Exception exception) {}
                }
            }
            migratedCount.addAndGet(1L);
        }
    }

    public static String generatePassword() {
        Random random = new Random();
        return new BigInteger(130, random).toString(32) + "ABab23";
    }

    public Directory createInternalDirectory(String INTERNAL_DIRECTORY_NAME) throws DirectoryInstantiationException {
        Directory createdDirectory = (Directory)this.transactionTemplate.execute(() -> {
            ImmutableDirectory.Builder immutableDirectoryBuilder = ImmutableDirectory.newBuilder();
            immutableDirectoryBuilder.setName(INTERNAL_DIRECTORY_NAME);
            immutableDirectoryBuilder.setActive(true);
            immutableDirectoryBuilder.setType(DirectoryType.CROWD);
            immutableDirectoryBuilder.setDescription(INTERNAL_DIRECTORY_NAME);
            immutableDirectoryBuilder.setImplementationClass(InternalDirectory.class.getCanonicalName());
            immutableDirectoryBuilder.setCreatedDate(new Date());
            immutableDirectoryBuilder.setUpdatedDate(new Date());
            immutableDirectoryBuilder.setAllowedOperations((Set)Sets.newHashSet((Object[])OperationType.values()));
            HashMap<String, String> directoryAttributes = new HashMap<String, String>();
            directoryAttributes.put("user_encryption_method", "atlassian-security");
            directoryAttributes.put("kantega_user_cleanup_directory", "true");
            immutableDirectoryBuilder.setAttributes(directoryAttributes);
            Directory directory = immutableDirectoryBuilder.toDirectory();
            try {
                return this.crowdDirectoryService.addDirectory(directory);
            }
            catch (com.atlassian.crowd.exception.runtime.OperationFailedException e) {
                throw new RuntimeException(e);
            }
        });
        return createdDirectory;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public Map<String, Directory> findScimDirectories() {
        return Stream.ofAll((Iterable)this.directoryManager.findAllDirectories()).filter(d -> d.getType() == DirectoryType.INTERNAL).map(d -> Tuple.of((Object)((String)d.getAttributes().get("ksso.scim.tenantId")), (Object)d)).filter(tuple -> tuple._1 != null).toMap(tuple -> (String)tuple._1, tuple -> (Directory)tuple._2);
    }

    public Option<Directory> findDirectoryByTenantId(String tenantId) {
        return this.findScimDirectories().get((Object)tenantId);
    }

    private boolean directoryExists(String tenantId) {
        return this.findDirectoryByTenantId(tenantId).isDefined();
    }

    @Override
    public void controlCleanupConfiguration(CleanupRuleDTOV1 cleanupRule, RunAttributes runAttributes, boolean b) throws ConfigurationException {
    }

    @Override
    public void controlCleanupConfigurationV2(CleanupRuleDTOV2 cleanupRule, RunAttributes runAttributes, boolean b) throws ConfigurationException {
    }
}

